/*
 * Decompiled with CFR 0.152.
 */
package net.sf.uadetector.internal.util;

import java.io.Serializable;
import java.util.Comparator;

public final class AlphanumComparator
implements Comparator<String>,
Serializable {
    private static final long serialVersionUID = 5727692755534146935L;

    protected static int compareDigits(String s1, String s2) {
        int thisMarker = 0;
        int thatMarker = 0;
        int s1Length = s1.length();
        int s2Length = s2.length();
        while (thisMarker < s1Length && thatMarker < s2Length) {
            String thisChunk = AlphanumComparator.getChunk(s1, s1Length, thisMarker);
            thisMarker += thisChunk.length();
            String thatChunk = AlphanumComparator.getChunk(s2, s2Length, thatMarker);
            thatMarker += thatChunk.length();
            int result = 0;
            if (AlphanumComparator.isDigit(thisChunk.charAt(0)) && AlphanumComparator.isDigit(thatChunk.charAt(0))) {
                int thisChunkLength = thisChunk.length();
                result = thisChunkLength - thatChunk.length();
                if (result == 0) {
                    for (int i = 0; i < thisChunkLength; ++i) {
                        result = thisChunk.charAt(i) - thatChunk.charAt(i);
                        if (result == 0) continue;
                        return result;
                    }
                }
            } else {
                result = thisChunk.compareTo(thatChunk);
            }
            if (result == 0) continue;
            return result;
        }
        return s1Length - s2Length;
    }

    private static String getChunk(String s, int slength, int marker) {
        StringBuilder chunk = new StringBuilder();
        char c = s.charAt(marker);
        chunk.append(c);
        ++marker;
        if (AlphanumComparator.isDigit(c)) {
            while (marker < slength && AlphanumComparator.isDigit(c = s.charAt(marker))) {
                chunk.append(c);
                ++marker;
            }
        } else {
            while (marker < slength && !AlphanumComparator.isDigit(c = s.charAt(marker))) {
                chunk.append(c);
                ++marker;
            }
        }
        return chunk.toString();
    }

    private static boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    @Override
    public int compare(String a, String b) {
        int result = 0;
        if (a == null) {
            if (b != null) {
                result = -1;
            }
        } else {
            result = b == null ? 1 : AlphanumComparator.compareDigits(a, b);
        }
        return result;
    }
}

