/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.schedule;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.apache.turbine.services.schedule.AbstractSchedulerService;
import org.apache.turbine.services.schedule.JobEntry;
import org.apache.turbine.services.schedule.JobEntryNonPersistent;
import org.apache.turbine.util.TurbineException;

@Deprecated
public class TurbineNonPersistentSchedulerService
extends AbstractSchedulerService {
    @Override
    protected List<? extends JobEntry> loadJobs() throws TurbineException {
        Configuration conf = this.getConfiguration();
        List jobProps = conf.getList("scheduler.jobs");
        ArrayList<JobEntry> jobs = new ArrayList<JobEntry>();
        if (!jobProps.isEmpty()) {
            for (int i = 0; i < jobProps.size(); ++i) {
                String jobName = (String)jobProps.get(i);
                String jobPrefix = "scheduler.job." + jobName;
                String jobId = conf.getString(jobPrefix + ".ID", null);
                if (StringUtils.isEmpty((String)jobId)) {
                    throw new TurbineException("There is an error in the TurbineResources.properties file. \n" + jobPrefix + ".ID is not found.\n");
                }
                int sec = conf.getInt(jobPrefix + ".SECOND", -1);
                int min = conf.getInt(jobPrefix + ".MINUTE", -1);
                int hr = conf.getInt(jobPrefix + ".HOUR", -1);
                int wkday = conf.getInt(jobPrefix + ".WEEKDAY", -1);
                int dayOfMonth = conf.getInt(jobPrefix + ".DAY_OF_MONTH", -1);
                JobEntry je = this.newJob(sec, min, hr, wkday, dayOfMonth, jobName);
                je.setJobId(Integer.parseInt(jobId));
                jobs.add(je);
            }
        }
        return jobs;
    }

    @Override
    public JobEntry newJob(int sec, int min, int hour, int wd, int day_mo, String task) throws TurbineException {
        return new JobEntryNonPersistent(sec, min, hour, wd, day_mo, task);
    }

    @Override
    public JobEntry getJob(int oid) throws TurbineException {
        JobEntryNonPersistent je = new JobEntryNonPersistent();
        je.setJobId(oid);
        return this.scheduleQueue.getJob(je);
    }

    @Override
    public void removeJob(JobEntry je) {
        this.scheduleQueue.remove(je);
        this.restart();
    }

    @Override
    public void updateJob(JobEntry je) throws TurbineException {
        try {
            je.calcRunTime();
            this.scheduleQueue.modify(je);
            this.restart();
        }
        catch (Exception e) {
            throw new TurbineException("Problem updating Scheduled Job: " + je.getTask(), e);
        }
    }
}

