/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util.uri;

import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.turbine.Turbine;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.ServerData;
import org.apache.turbine.util.uri.URI;
import org.apache.turbine.util.uri.URIConstants;

public abstract class BaseURI
implements URI,
URIConstants {
    private static Log log = LogFactory.getLog(BaseURI.class);
    private ServerData serverData = new ServerData(null, 80, "http", null, null);
    private boolean redirect = false;
    private HttpServletResponse response = null;
    private String reference = null;

    public BaseURI() {
        this.init(Turbine.getDefaultServerData());
        this.setResponse(null);
    }

    public BaseURI(RunData runData) {
        this.init(runData.getServerData());
        this.setResponse(runData.getResponse());
    }

    public BaseURI(RunData runData, boolean redirect) {
        this.init(runData.getServerData());
        this.setResponse(runData.getResponse());
        this.setRedirect(redirect);
    }

    public BaseURI(ServerData serverData) {
        this.init(serverData);
        this.setResponse(null);
    }

    public BaseURI(ServerData serverData, boolean redirect) {
        this.init(serverData);
        this.setResponse(null);
        this.setRedirect(redirect);
    }

    private void init(ServerData serverData) {
        log.debug((Object)("init(" + serverData + ")"));
        if (serverData != null) {
            this.serverData = (ServerData)serverData.clone();
        } else {
            log.error((Object)"Passed null ServerData object!");
        }
        this.reference = null;
    }

    public void setRedirect(boolean redirect) {
        this.redirect = redirect;
    }

    public boolean isRedirect() {
        return this.redirect;
    }

    @Override
    public String getScriptName() {
        return this.serverData.getScriptName();
    }

    public void setScriptName(String scriptName) {
        this.serverData.setScriptName(scriptName);
    }

    @Override
    public String getContextPath() {
        return this.serverData.getContextPath();
    }

    public void setContextPath(String contextPath) {
        this.serverData.setContextPath(contextPath);
    }

    @Override
    public String getServerName() {
        return this.serverData.getServerName();
    }

    public void setServerName(String serverName) {
        this.serverData.setServerName(serverName);
    }

    @Override
    public int getServerPort() {
        int serverPort = this.serverData.getServerPort();
        if (serverPort == 0) {
            serverPort = this.getServerScheme().equals("https") ? 443 : 80;
        }
        return serverPort;
    }

    public void setServerPort(int serverPort) {
        this.serverData.setServerPort(serverPort);
    }

    public void setSecure() {
        this.setSecure(443);
    }

    public void setSecure(int port) {
        boolean useSSL = Turbine.getConfiguration().getBoolean("use.ssl", true);
        this.setServerScheme(useSSL ? "https" : "http");
        this.setServerPort(port);
    }

    public void setServerScheme(String serverScheme) {
        this.serverData.setServerScheme(StringUtils.isNotEmpty((String)serverScheme) ? serverScheme : "");
    }

    @Override
    public String getServerScheme() {
        String serverScheme = this.serverData.getServerScheme();
        return StringUtils.isNotEmpty((String)serverScheme) ? serverScheme : "http";
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    @Override
    public String getReference() {
        return this.hasReference() ? this.reference : "";
    }

    public boolean hasReference() {
        return StringUtils.isNotEmpty((String)this.reference);
    }

    protected void setResponse(HttpServletResponse response) {
        this.response = response;
    }

    protected HttpServletResponse getResponse() {
        return this.response;
    }

    protected void getContextAndScript(StringBuilder sb) {
        String script;
        String context = this.getContextPath();
        if (StringUtils.isNotEmpty((String)context)) {
            if (context.charAt(0) != '/') {
                sb.append('/');
            }
            sb.append(context);
        }
        if (StringUtils.isNotEmpty((String)(script = this.getScriptName()))) {
            if (script.charAt(0) != '/') {
                sb.append('/');
            }
            sb.append(script);
        }
    }

    protected void getSchemeAndPort(StringBuilder sb) {
        sb.append(this.getServerScheme());
        sb.append("://");
        sb.append(this.getServerName());
        if (this.getServerScheme().equals("http") && this.getServerPort() != 80 || this.getServerScheme().equals("https") && this.getServerPort() != 443) {
            sb.append(':');
            sb.append(this.getServerPort());
        }
    }

    protected String encodeResponse(String uri) {
        String res = uri;
        HttpServletResponse response = this.getResponse();
        if (response == null) {
            log.debug((Object)"No Response Object!");
        } else {
            try {
                if (this.isRedirect()) {
                    log.debug((Object)"Should Redirect");
                    res = response.encodeRedirectURL(uri);
                } else {
                    res = response.encodeURL(uri);
                }
            }
            catch (Exception e) {
                log.error((Object)("response" + response + ", uri: " + uri));
                log.error((Object)"While trying to encode the URI: ", (Throwable)e);
            }
        }
        log.debug((Object)("encodeResponse():  " + res));
        return res;
    }
}

