/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.intake;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fulcrum.intake.IntakeException;
import org.apache.fulcrum.intake.IntakeServiceFacade;
import org.apache.fulcrum.intake.Retrievable;
import org.apache.fulcrum.intake.model.Group;
import org.apache.fulcrum.parser.ValueParser;
import org.apache.fulcrum.pool.Recyclable;
import org.apache.turbine.services.pull.ApplicationTool;
import org.apache.turbine.util.RunData;

public class IntakeTool
implements ApplicationTool,
Recyclable {
    protected static final Log log = LogFactory.getLog(IntakeTool.class);
    public static final String DEFAULT_KEY = "_0";
    public static final String INTAKE_GRP = "intake-grp";
    protected HashMap<String, Group> groups;
    protected ValueParser pp;
    private final HashMap<String, Group> declaredGroups = new HashMap();
    private final StringBuilder allGroupsSB = new StringBuilder(256);
    private final StringBuilder groupSB = new StringBuilder(128);
    private final Map<String, PullHelper> pullMap;
    private boolean disposed;

    public IntakeTool() {
        String[] groupNames = IntakeServiceFacade.getGroupNames();
        int groupCount = 0;
        if (groupNames != null) {
            groupCount = groupNames.length;
        }
        this.groups = new HashMap((int)(1.25 * (double)groupCount + 1.0));
        this.pullMap = new HashMap<String, PullHelper>((int)(1.25 * (double)groupCount + 1.0));
        for (int i = groupCount - 1; i >= 0; --i) {
            this.pullMap.put(groupNames[i], new PullHelper(groupNames[i]));
        }
    }

    @Override
    public void init(Object runData) {
        int i;
        this.pp = ((RunData)runData).getParameters();
        String[] groupKeys = this.pp.getStrings(INTAKE_GRP);
        String[] groupNames = null;
        if (groupKeys == null || groupKeys.length == 0) {
            groupNames = IntakeServiceFacade.getGroupNames();
        } else {
            groupNames = new String[groupKeys.length];
            for (i = groupKeys.length - 1; i >= 0; --i) {
                groupNames[i] = IntakeServiceFacade.getGroupName((String)groupKeys[i]);
            }
        }
        for (i = groupNames.length - 1; i >= 0; --i) {
            try {
                List foundGroups = IntakeServiceFacade.getGroup((String)groupNames[i]).getObjects(this.pp);
                if (foundGroups == null) continue;
                for (Group group : foundGroups) {
                    this.groups.put(group.getObjectKey(), group);
                }
                continue;
            }
            catch (IntakeException e) {
                log.error((Object)e);
            }
        }
    }

    public void addGroupsToParameters(ValueParser vp) {
        for (Group group : this.groups.values()) {
            if (!this.declaredGroups.containsKey(group.getIntakeGroupName())) {
                this.declaredGroups.put(group.getIntakeGroupName(), null);
                vp.add(INTAKE_GRP, group.getGID());
            }
            vp.add(group.getGID(), group.getOID());
        }
        this.declaredGroups.clear();
    }

    public String declareGroups() {
        this.allGroupsSB.setLength(0);
        for (Group group : this.groups.values()) {
            this.declareGroup(group, this.allGroupsSB);
        }
        return this.allGroupsSB.toString();
    }

    public String declareGroup(Group group) {
        this.groupSB.setLength(0);
        this.declareGroup(group, this.groupSB);
        return this.groupSB.toString();
    }

    public void declareGroup(Group group, StringBuilder sb) {
        if (!this.declaredGroups.containsKey(group.getIntakeGroupName())) {
            this.declaredGroups.put(group.getIntakeGroupName(), null);
            sb.append("<input type=\"hidden\" name=\"").append(INTAKE_GRP).append("\" value=\"").append(group.getGID()).append("\"/>\n");
        }
        group.appendHtmlFormInput(sb);
    }

    public void newForm() {
        this.declaredGroups.clear();
        for (Group group : this.groups.values()) {
            group.resetDeclared();
        }
    }

    @Override
    public void refresh() {
    }

    public PullHelper get(String groupName) {
        return this.pullMap.get(groupName);
    }

    public PullHelper get(String groupName, boolean throwExceptions) throws IntakeException {
        return this.pullMap.get(groupName);
    }

    public boolean isAllValid() {
        boolean allValid = true;
        for (Group group : this.groups.values()) {
            allValid &= group.isAllValid();
        }
        return allValid;
    }

    public Group get(String groupName, String key) throws IntakeException {
        return this.get(groupName, key, true);
    }

    public Group get(String groupName, String key, boolean create) throws IntakeException {
        if (groupName == null) {
            throw new IntakeException("IntakeServiceFacade.get: groupName == null");
        }
        if (key == null) {
            throw new IntakeException("IntakeServiceFacade.get: key == null");
        }
        PullHelper ph = this.get(groupName);
        return ph == null ? null : ph.setKey(key, create);
    }

    public void remove(Group group) {
        if (group != null) {
            this.groups.remove(group.getObjectKey());
            group.removeFromRequest();
            String[] groupKeys = this.pp.getStrings(INTAKE_GRP);
            this.pp.remove(INTAKE_GRP);
            if (groupKeys != null) {
                for (int i = 0; i < groupKeys.length; ++i) {
                    if (groupKeys[i].equals(group.getGID())) continue;
                    this.pp.add(INTAKE_GRP, groupKeys[i]);
                }
            }
            try {
                IntakeServiceFacade.releaseGroup((Group)group);
            }
            catch (IntakeException ie) {
                log.error((Object)("Tried to release unknown group " + group.getIntakeGroupName()));
            }
        }
    }

    public void removeAll() {
        Object[] allGroups = this.groups.values().toArray();
        for (int i = allGroups.length - 1; i >= 0; --i) {
            Group group = (Group)allGroups[i];
            this.remove(group);
        }
    }

    public Map<String, Group> getGroups() {
        return this.groups;
    }

    public void recycle() {
        this.disposed = false;
    }

    public void dispose() {
        for (Group group : this.groups.values()) {
            try {
                IntakeServiceFacade.releaseGroup((Group)group);
            }
            catch (IntakeException ie) {
                log.error((Object)("Tried to release unknown group " + group.getIntakeGroupName()));
            }
        }
        this.groups.clear();
        this.declaredGroups.clear();
        this.pp = null;
        this.disposed = true;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public class PullHelper {
        String groupName;

        protected PullHelper(String groupName) {
            this.groupName = groupName;
        }

        public Group getDefault() throws IntakeException {
            return this.setKey(IntakeTool.DEFAULT_KEY);
        }

        public Group setKey(String key) throws IntakeException {
            return this.setKey(key, true);
        }

        public Group setKey(String key, boolean create) throws IntakeException {
            Group g = null;
            String inputKey = IntakeServiceFacade.getGroupKey((String)this.groupName) + key;
            if (IntakeTool.this.groups.containsKey(inputKey)) {
                g = IntakeTool.this.groups.get(inputKey);
            } else if (create) {
                g = IntakeServiceFacade.getGroup((String)this.groupName);
                IntakeTool.this.groups.put(inputKey, g);
                g.init(key, IntakeTool.this.pp);
            }
            return g;
        }

        public Group mapTo(Retrievable obj) {
            Group g = null;
            try {
                String inputKey = IntakeServiceFacade.getGroupKey((String)this.groupName) + obj.getQueryKey();
                if (IntakeTool.this.groups.containsKey(inputKey)) {
                    g = IntakeTool.this.groups.get(inputKey);
                } else {
                    g = IntakeServiceFacade.getGroup((String)this.groupName);
                    IntakeTool.this.groups.put(inputKey, g);
                }
                return g.init(obj);
            }
            catch (IntakeException e) {
                log.error((Object)e);
                return null;
            }
        }
    }
}

