/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.yaafi.framework.util;

import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.logger.Logger;
import org.apache.fulcrum.yaafi.framework.util.StringUtils;

public class ConfigurationUtil {
    public static void expand(Logger logger, DefaultConfiguration defaultConfiguration, Map vars) throws ConfigurationException {
        if (vars == null || vars.size() == 0) {
            return;
        }
        if (defaultConfiguration.getValue(null) != null) {
            String oldValue = defaultConfiguration.getValue();
            String newValue = ConfigurationUtil.expand(oldValue, vars);
            defaultConfiguration.setValue(newValue);
            if (!oldValue.equals(newValue)) {
                logger.debug("Changed element <" + defaultConfiguration.getName() + "> from '" + oldValue + "' ==> '" + newValue + "'");
            }
        }
        String attributeName = null;
        String[] attributeNames = defaultConfiguration.getAttributeNames();
        for (int i = 0; i < attributeNames.length; ++i) {
            attributeName = attributeNames[i];
            String oldAttributeValue = defaultConfiguration.getAttribute(attributeName);
            String newAttributeValue = ConfigurationUtil.expand(oldAttributeValue, vars);
            defaultConfiguration.setAttribute(attributeName, newAttributeValue);
            if (oldAttributeValue.equals(newAttributeValue)) continue;
            logger.debug("Changed attribute '" + defaultConfiguration.getName() + "@" + attributeName + "' from '" + oldAttributeValue + "' ==> '" + newAttributeValue + "'");
        }
        Configuration[] children = defaultConfiguration.getChildren();
        for (int i = 0; i < children.length; ++i) {
            ConfigurationUtil.expand(logger, (DefaultConfiguration)children[i], vars);
        }
    }

    private static String expand(String value, Map vars) {
        return StringUtils.stringSubstitution(value, vars, true).toString();
    }
}

