/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.yaafi.framework.interceptor;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.fulcrum.yaafi.framework.interceptor.AvalonInterceptorContext;
import org.apache.fulcrum.yaafi.framework.tls.ThreadLocalStorage;
import org.apache.fulcrum.yaafi.framework.tls.ThreadLocalStorageImpl;
import org.apache.fulcrum.yaafi.framework.util.ToStringBuilder;
import org.apache.fulcrum.yaafi.framework.util.Validate;

public class AvalonInterceptorContextImpl
implements AvalonInterceptorContext {
    private static final String TRANSACTIONID_KEY = "$org.apache.fulcrum.yaafi.framework.interceptor.AvalonInterceptorContext#transactionId";
    private static final String INVOCATIONDEPTH_KEY = "$org.apache.fulcrum.yaafi.framework.interceptor.AvalonInterceptorContext#invocationDepth";
    private String serviceName;
    private String serviceShorthand;
    private Object serviceDelegate;
    private Method method;
    private Object[] args;
    private HashMap requestContext;
    private static ThreadLocalStorageImpl tls = new ThreadLocalStorageImpl();
    private static volatile long invocationCounter = 0L;
    private Long invocationId;

    public AvalonInterceptorContextImpl(String serviceName, String serviceShorthand, Object serviceDelegate, Method method, Object[] args) {
        Validate.notEmpty(serviceName, "serviceName");
        Validate.notEmpty(serviceShorthand, "serviceShorthand");
        Validate.notNull(serviceDelegate, "serviceDelegate");
        Validate.notNull(method, "method");
        this.invocationId = new Long(++invocationCounter);
        this.serviceName = serviceName;
        this.serviceShorthand = serviceShorthand;
        this.serviceDelegate = serviceDelegate;
        this.method = method;
        this.args = args;
        this.requestContext = new HashMap();
    }

    @Override
    public final Map getRequestContext() {
        return this.requestContext;
    }

    @Override
    public final Object getServiceDelegate() {
        return this.serviceDelegate;
    }

    @Override
    public final String getServiceName() {
        return this.serviceName;
    }

    @Override
    public String getServiceShorthand() {
        return this.serviceShorthand;
    }

    @Override
    public final Object[] getArgs() {
        return this.args;
    }

    @Override
    public final Method getMethod() {
        return this.method;
    }

    @Override
    public final ThreadLocalStorage getThreadContext() {
        return tls;
    }

    @Override
    public boolean hasTransactionId() {
        return this.getTransactionId() != null;
    }

    @Override
    public Object getTransactionId() {
        return this.getThreadContext().get(TRANSACTIONID_KEY);
    }

    @Override
    public void setTransactionId(Object transactionId) {
        this.getThreadContext().put(TRANSACTIONID_KEY, transactionId);
    }

    @Override
    public void clearTransactionId() {
        this.setTransactionId(null);
    }

    @Override
    public void incrementInvocationDepth() {
        Integer invocationDepth = (Integer)this.getThreadContext().get(INVOCATIONDEPTH_KEY);
        if (invocationDepth != null) {
            int currInvocationDepth = invocationDepth;
            this.getThreadContext().put(INVOCATIONDEPTH_KEY, new Integer(++currInvocationDepth));
        } else {
            this.getThreadContext().put(INVOCATIONDEPTH_KEY, new Integer(0));
        }
    }

    @Override
    public void decrementInvocationDepth() {
        Integer invocationDepth = (Integer)this.getThreadContext().get(INVOCATIONDEPTH_KEY);
        if (invocationDepth != null) {
            int currInvocationDepth = invocationDepth;
            this.getThreadContext().put(INVOCATIONDEPTH_KEY, new Integer(--currInvocationDepth));
        }
    }

    @Override
    public int getInvocationDepth() {
        Integer invocationDepth = (Integer)this.getThreadContext().get(INVOCATIONDEPTH_KEY);
        if (invocationDepth != null) {
            return invocationDepth;
        }
        return 0;
    }

    @Override
    public final Long getInvocationId() {
        return this.invocationId;
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder(this);
        toStringBuilder.append("serviceShorthand", this.serviceShorthand);
        toStringBuilder.append("serviceName", this.serviceName);
        toStringBuilder.append("serviceDelegate", this.serviceDelegate);
        toStringBuilder.append("method", this.method.getName());
        toStringBuilder.append("args", this.args.length);
        toStringBuilder.append("transactionId", this.getTransactionId());
        toStringBuilder.append("invocationId", this.invocationId);
        toStringBuilder.append("invocationDepth", this.getInvocationDepth());
        toStringBuilder.append("requestContext", this.requestContext);
        return toStringBuilder.toString();
    }
}

