/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.intake.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.pool2.BaseKeyedPooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.fulcrum.intake.IntakeException;
import org.apache.fulcrum.intake.IntakeServiceFacade;
import org.apache.fulcrum.intake.Retrievable;
import org.apache.fulcrum.intake.model.AppData;
import org.apache.fulcrum.intake.model.Field;
import org.apache.fulcrum.intake.model.FieldAdapter;
import org.apache.fulcrum.parser.ValueParser;

@XmlType(name="group")
@XmlAccessorType(value=XmlAccessType.NONE)
public class Group
implements Serializable,
LogEnabled {
    private static final long serialVersionUID = -5452725641409669284L;
    public static final String EMPTY = "";
    public static final String NEW = "_0";
    private transient Logger log;
    @XmlAttribute(name="key", required=true)
    private String gid;
    @XmlAttribute(required=true)
    private String name;
    @XmlAttribute
    private int poolCapacity = 128;
    @XmlAttribute(name="mapToObject")
    private String defaultMapToObject;
    private AppData parent;
    protected Map<String, Field<?>> fields;
    protected Map<String, Field<?>[]> mapToObjectFields;
    protected Field<?>[] fieldsArray;
    protected String oid;
    protected ValueParser pp;
    protected boolean isDeclared;

    public void enableLogging(Logger logger) {
        this.log = logger.getChildLogger(this.getClass().getSimpleName());
    }

    public Group init(ValueParser pp) throws IntakeException {
        return this.init(NEW, pp);
    }

    public Group init(String key, ValueParser pp) throws IntakeException {
        int i;
        this.oid = key;
        this.pp = pp;
        for (i = this.fieldsArray.length - 1; i >= 0; --i) {
            this.fieldsArray[i].init(pp);
        }
        for (i = this.fieldsArray.length - 1; i >= 0; --i) {
            if (!this.fieldsArray[i].isSet() || this.fieldsArray[i].isValidated()) continue;
            this.fieldsArray[i].validate();
        }
        return this;
    }

    public Group init(Retrievable obj) {
        this.oid = obj.getQueryKey();
        for (Class<?> cls = obj.getClass(); cls != null; cls = cls.getSuperclass()) {
            Field<?>[] flds = this.mapToObjectFields.get(cls.getName());
            if (flds != null) {
                for (int i = flds.length - 1; i >= 0; --i) {
                    flds[i].init(obj);
                }
            }
            Class<?>[] interfaces = cls.getInterfaces();
            for (int idx = 0; idx < interfaces.length; ++idx) {
                Field<?>[] interfaceFields = this.mapToObjectFields.get(interfaces[idx].getName());
                if (interfaceFields == null) continue;
                for (int i = 0; i < interfaceFields.length; ++i) {
                    interfaceFields[i].init(obj);
                }
            }
        }
        return this;
    }

    public String[] getFieldNames() {
        String[] nameList = new String[this.fieldsArray.length];
        for (int i = 0; i < nameList.length; ++i) {
            nameList[i] = this.fieldsArray[i].name;
        }
        return nameList;
    }

    public String getIntakeGroupName() {
        return this.name;
    }

    public int getPoolCapacity() {
        return this.poolCapacity;
    }

    public String getGID() {
        return this.gid;
    }

    public String getOID() {
        return this.oid;
    }

    public String getObjectKey() {
        return this.gid + this.oid;
    }

    public String getDefaultMapToObject() {
        return this.defaultMapToObject;
    }

    public List<Group> getObjects(ValueParser pp) throws IntakeException {
        ArrayList<Group> objs = null;
        String[] oids = pp.getStrings(this.gid);
        if (oids != null) {
            objs = new ArrayList<Group>(oids.length);
            for (int i = oids.length - 1; i >= 0; --i) {
                objs.add(IntakeServiceFacade.getGroup(this.name).init(oids[i], pp));
            }
        }
        return objs;
    }

    public Field<?> get(String fieldName) throws IntakeException {
        if (this.fields.containsKey(fieldName)) {
            return this.fields.get(fieldName);
        }
        throw new IntakeException("Intake Field name: " + fieldName + " not found in Group " + this.name);
    }

    public List<Field<?>> getFields() {
        if (this.fieldsArray == null) {
            return new ArrayList();
        }
        return Arrays.asList(this.fieldsArray);
    }

    @XmlElement(name="field")
    @XmlJavaTypeAdapter(value=FieldAdapter.class)
    protected void setFields(List<Field<?>> inputFields) {
        int size = inputFields.size();
        this.fields = new HashMap((int)(1.25 * (double)size + 1.0));
        this.fieldsArray = new Field[size];
        for (int i = size - 1; i >= 0; --i) {
            Field<?> field = inputFields.get(i);
            this.fieldsArray[i] = field;
            this.fields.put(field.getName(), field);
        }
    }

    public boolean isAllValid() {
        boolean valid = true;
        for (int i = this.fieldsArray.length - 1; i >= 0; --i) {
            valid &= this.fieldsArray[i].isValid();
            if (!this.log.isDebugEnabled() || this.fieldsArray[i].isValid()) continue;
            this.log.debug("Group(" + this.oid + "): " + this.name + "; Field: " + this.fieldsArray[i].name + "; value=" + this.fieldsArray[i].getValue() + " is invalid!");
        }
        return valid;
    }

    public void setProperties(Object obj) throws IntakeException {
        for (Class<?> cls = obj.getClass(); cls != null; cls = cls.getSuperclass()) {
            Field<?>[] flds;
            if (this.log.isDebugEnabled()) {
                this.log.debug("setProperties(" + cls.getName() + ")");
            }
            if ((flds = this.mapToObjectFields.get(cls.getName())) != null) {
                for (int i = flds.length - 1; i >= 0; --i) {
                    flds[i].setProperty(obj);
                }
            }
            Class<?>[] interfaces = cls.getInterfaces();
            for (int idx = 0; idx < interfaces.length; ++idx) {
                Field<?>[] interfaceFields = this.mapToObjectFields.get(interfaces[idx].getName());
                if (interfaceFields == null) continue;
                for (int i = 0; i < interfaceFields.length; ++i) {
                    interfaceFields[i].setProperty(obj);
                }
            }
        }
        this.log.debug("setProperties() finished");
    }

    public void setValidProperties(Object obj) {
        for (Class<?> cls = obj.getClass(); cls != null; cls = cls.getSuperclass()) {
            Field<?>[] flds = this.mapToObjectFields.get(cls.getName());
            if (flds != null) {
                for (int i = flds.length - 1; i >= 0; --i) {
                    try {
                        flds[i].setProperty(obj);
                        continue;
                    }
                    catch (IntakeException e) {
                        // empty catch block
                    }
                }
            }
            Class<?>[] interfaces = cls.getInterfaces();
            for (int idx = 0; idx < interfaces.length; ++idx) {
                Field<?>[] interfaceFields = this.mapToObjectFields.get(interfaces[idx].getName());
                if (interfaceFields == null) continue;
                for (int i = 0; i < interfaceFields.length; ++i) {
                    try {
                        interfaceFields[i].setProperty(obj);
                        continue;
                    }
                    catch (IntakeException e) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public void getProperties(Object obj) throws IntakeException {
        for (Class<?> cls = obj.getClass(); cls != null; cls = cls.getSuperclass()) {
            Field<?>[] flds = this.mapToObjectFields.get(cls.getName());
            if (flds != null) {
                for (int i = flds.length - 1; i >= 0; --i) {
                    flds[i].getProperty(obj);
                }
            }
            Class<?>[] interfaces = cls.getInterfaces();
            for (int idx = 0; idx < interfaces.length; ++idx) {
                Field<?>[] interfaceFields = this.mapToObjectFields.get(interfaces[idx].getName());
                if (interfaceFields == null) continue;
                for (int i = 0; i < interfaceFields.length; ++i) {
                    interfaceFields[i].getProperty(obj);
                }
            }
        }
    }

    public void removeFromRequest() {
        String[] groups;
        if (this.pp != null && (groups = this.pp.getStrings(this.gid)) != null) {
            int i;
            this.pp.remove(this.gid);
            for (i = 0; i < groups.length; ++i) {
                if (groups[i] == null || groups[i].equals(this.oid)) continue;
                this.pp.add(this.gid, groups[i]);
            }
            for (i = this.fieldsArray.length - 1; i >= 0; --i) {
                this.fieldsArray[i].removeFromRequest();
            }
        }
    }

    public void resetDeclared() {
        this.isDeclared = false;
    }

    public String getHtmlFormInput() {
        StringBuilder sb = new StringBuilder(64);
        this.appendHtmlFormInput(sb);
        return sb.toString();
    }

    public void appendHtmlFormInput(StringBuilder sb) {
        if (!this.isDeclared) {
            this.isDeclared = true;
            sb.append("<input type=\"hidden\" name=\"").append(this.gid).append("\" value=\"").append(this.oid).append("\"/>\n");
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("<group name=\"").append(this.getIntakeGroupName()).append("\"");
        result.append(" key=\"").append(this.getGID()).append("\"");
        result.append(">\n");
        if (this.fieldsArray != null) {
            for (Field<?> field : this.fieldsArray) {
                result.append(field);
            }
        }
        result.append("</group>\n");
        return result.toString();
    }

    public AppData getAppData() {
        return this.parent;
    }

    public void afterUnmarshal(Unmarshaller um, Object parent) {
        this.parent = (AppData)parent;
        HashMap mapToObjectFieldLists = new HashMap((int)(1.25 * (double)this.fieldsArray.length + 1.0));
        for (Field<?> field : this.fieldsArray) {
            ArrayList tmpFields;
            if (StringUtils.isNotEmpty((String)field.mapToObject)) {
                field.mapToObject = this.parent.getBasePackage() + field.mapToObject;
            }
            if ((tmpFields = (ArrayList)mapToObjectFieldLists.get(field.getMapToObject())) == null) {
                tmpFields = new ArrayList(this.fieldsArray.length);
                mapToObjectFieldLists.put(field.getMapToObject(), tmpFields);
            }
            tmpFields.add(field);
        }
        this.mapToObjectFields = new HashMap<String, Field<?>[]>((int)(1.25 * (double)this.fieldsArray.length + 1.0));
        for (Map.Entry entry : mapToObjectFieldLists.entrySet()) {
            this.mapToObjectFields.put((String)entry.getKey(), ((List)entry.getValue()).toArray(new Field[((List)entry.getValue()).size()]));
        }
    }

    public static class GroupFactory
    extends BaseKeyedPooledObjectFactory<String, Group> {
        private final AppData appData;

        public GroupFactory(AppData appData) {
            this.appData = appData;
        }

        public Group create(String key) throws IntakeException {
            return this.appData.getGroup(key);
        }

        public PooledObject<Group> wrap(Group group) {
            return new DefaultPooledObject((Object)group);
        }

        public void passivateObject(String key, PooledObject<Group> pooledGroup) {
            Group group = (Group)pooledGroup.getObject();
            group.oid = null;
            group.pp = null;
            for (int i = group.fieldsArray.length - 1; i >= 0; --i) {
                group.fieldsArray[i].dispose();
            }
            group.isDeclared = false;
        }
    }
}

