package org.apache.turbine.services.schedule;


import java.math.BigDecimal;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

import org.apache.commons.lang.ObjectUtils;
import org.apache.torque.TorqueException;
import org.apache.torque.map.TableMap;
import org.apache.torque.om.BaseObject;
import org.apache.torque.om.ComboKey;
import org.apache.torque.om.DateKey;
import org.apache.torque.om.NumberKey;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.om.SimpleKey;
import org.apache.torque.om.StringKey;
import org.apache.torque.om.Persistent;
import org.apache.torque.util.Criteria;
import org.apache.torque.util.Transaction;





/**
 * This class was autogenerated by Torque on:
 *
 * [Thu Jun 23 17:25:46 CEST 2011]
 *
 * You should not use this class directly.  It should not even be
 * extended all references should be to JobEntry
 */
public abstract class BaseJobEntry extends BaseObject
{
    /** Serial version */
    private static final long serialVersionUID = 1308842746584L;

    /** The Peer class */
    private static final JobEntryPeer peer =
        new JobEntryPeer();


    /** The value for the jobId field */
    private int jobId;

    /** The value for the second field */
    private int second = -1;

    /** The value for the minute field */
    private int minute = -1;

    /** The value for the hour field */
    private int hour = -1;

    /** The value for the weekDay field */
    private int weekDay = -1;

    /** The value for the dayOfMonth field */
    private int dayOfMonth = -1;

    /** The value for the task field */
    private String task;

    /** The value for the email field */
    private String email;

    /** The value for the property field */
    private byte[] property;


    /**
     * Get the JobId
     *
     * @return int
     */
    public int getJobId()
    {
        return jobId;
    }


    /**
     * Set the value of JobId
     *
     * @param v new value
     */
    public void setJobId(int v) 
    {

        if (this.jobId != v)
        {
            this.jobId = v;
            setModified(true);
        }


    }

    /**
     * Get the Second
     *
     * @return int
     */
    public int getSecond()
    {
        return second;
    }


    /**
     * Set the value of Second
     *
     * @param v new value
     */
    public void setSecond(int v) 
    {

        if (this.second != v)
        {
            this.second = v;
            setModified(true);
        }


    }

    /**
     * Get the Minute
     *
     * @return int
     */
    public int getMinute()
    {
        return minute;
    }


    /**
     * Set the value of Minute
     *
     * @param v new value
     */
    public void setMinute(int v) 
    {

        if (this.minute != v)
        {
            this.minute = v;
            setModified(true);
        }


    }

    /**
     * Get the Hour
     *
     * @return int
     */
    public int getHour()
    {
        return hour;
    }


    /**
     * Set the value of Hour
     *
     * @param v new value
     */
    public void setHour(int v) 
    {

        if (this.hour != v)
        {
            this.hour = v;
            setModified(true);
        }


    }

    /**
     * Get the WeekDay
     *
     * @return int
     */
    public int getWeekDay()
    {
        return weekDay;
    }


    /**
     * Set the value of WeekDay
     *
     * @param v new value
     */
    public void setWeekDay(int v) 
    {

        if (this.weekDay != v)
        {
            this.weekDay = v;
            setModified(true);
        }


    }

    /**
     * Get the DayOfMonth
     *
     * @return int
     */
    public int getDayOfMonth()
    {
        return dayOfMonth;
    }


    /**
     * Set the value of DayOfMonth
     *
     * @param v new value
     */
    public void setDayOfMonth(int v) 
    {

        if (this.dayOfMonth != v)
        {
            this.dayOfMonth = v;
            setModified(true);
        }


    }

    /**
     * Get the Task
     *
     * @return String
     */
    public String getTask()
    {
        return task;
    }


    /**
     * Set the value of Task
     *
     * @param v new value
     */
    public void setTask(String v) 
    {

        if (!ObjectUtils.equals(this.task, v))
        {
            this.task = v;
            setModified(true);
        }


    }

    /**
     * Get the Email
     *
     * @return String
     */
    public String getEmail()
    {
        return email;
    }


    /**
     * Set the value of Email
     *
     * @param v new value
     */
    public void setEmail(String v) 
    {

        if (!ObjectUtils.equals(this.email, v))
        {
            this.email = v;
            setModified(true);
        }


    }

    /**
     * Get the Property
     *
     * @return byte[]
     */
    public byte[] getProperty()
    {
        return property;
    }


    /**
     * Set the value of Property
     *
     * @param v new value
     */
    public void setProperty(byte[] v) 
    {

        if (!ObjectUtils.equals(this.property, v))
        {
            this.property = v;
            setModified(true);
        }


    }

       
        
    private static List<String> fieldNames = null;

    /**
     * Generate a list of field names.
     *
     * @return a list of field names
     */
    public static synchronized List<String> getFieldNames()
    {
        if (fieldNames == null)
        {
            fieldNames = new ArrayList<String>();
            fieldNames.add("JobId");
            fieldNames.add("Second");
            fieldNames.add("Minute");
            fieldNames.add("Hour");
            fieldNames.add("WeekDay");
            fieldNames.add("DayOfMonth");
            fieldNames.add("Task");
            fieldNames.add("Email");
            fieldNames.add("Property");
            fieldNames = Collections.unmodifiableList(fieldNames);
        }
        return fieldNames;
    }

    /**
     * Retrieves a field from the object by field (Java) name passed in as a String.
     *
     * @param name field name
     * @return value
     */
    public Object getByName(String name)
    {
        if (name.equals("JobId"))
        {
            return new Integer(getJobId());
        }
        if (name.equals("Second"))
        {
            return new Integer(getSecond());
        }
        if (name.equals("Minute"))
        {
            return new Integer(getMinute());
        }
        if (name.equals("Hour"))
        {
            return new Integer(getHour());
        }
        if (name.equals("WeekDay"))
        {
            return new Integer(getWeekDay());
        }
        if (name.equals("DayOfMonth"))
        {
            return new Integer(getDayOfMonth());
        }
        if (name.equals("Task"))
        {
            return getTask();
        }
        if (name.equals("Email"))
        {
            return getEmail();
        }
        if (name.equals("Property"))
        {
            return getProperty();
        }
        return null;
    }

    /**
     * Set a field in the object by field (Java) name.
     *
     * @param name field name
     * @param value field value
     * @return True if value was set, false if not (invalid name / protected field).
     * @throws IllegalArgumentException if object type of value does not match field object type.
     * @throws TorqueException If a problem occurs with the set[Field] method.
     */
    public boolean setByName(String name, Object value )
        throws TorqueException, IllegalArgumentException
    {
        if (name.equals("JobId"))
        {
            if (value == null || ! (Integer.class.isInstance(value)))
            {
                throw new IllegalArgumentException("setByName: value parameter was null or not an Integer object.");
            }
            setJobId(((Integer) value).intValue());
            return true;
        }
        if (name.equals("Second"))
        {
            if (value == null || ! (Integer.class.isInstance(value)))
            {
                throw new IllegalArgumentException("setByName: value parameter was null or not an Integer object.");
            }
            setSecond(((Integer) value).intValue());
            return true;
        }
        if (name.equals("Minute"))
        {
            if (value == null || ! (Integer.class.isInstance(value)))
            {
                throw new IllegalArgumentException("setByName: value parameter was null or not an Integer object.");
            }
            setMinute(((Integer) value).intValue());
            return true;
        }
        if (name.equals("Hour"))
        {
            if (value == null || ! (Integer.class.isInstance(value)))
            {
                throw new IllegalArgumentException("setByName: value parameter was null or not an Integer object.");
            }
            setHour(((Integer) value).intValue());
            return true;
        }
        if (name.equals("WeekDay"))
        {
            if (value == null || ! (Integer.class.isInstance(value)))
            {
                throw new IllegalArgumentException("setByName: value parameter was null or not an Integer object.");
            }
            setWeekDay(((Integer) value).intValue());
            return true;
        }
        if (name.equals("DayOfMonth"))
        {
            if (value == null || ! (Integer.class.isInstance(value)))
            {
                throw new IllegalArgumentException("setByName: value parameter was null or not an Integer object.");
            }
            setDayOfMonth(((Integer) value).intValue());
            return true;
        }
        if (name.equals("Task"))
        {
            // Object fields can be null
            if (value != null && ! String.class.isInstance(value))
            {
                throw new IllegalArgumentException("Invalid type of object specified for value in setByName");
            }
            setTask((String) value);
            return true;
        }
        if (name.equals("Email"))
        {
            // Object fields can be null
            if (value != null && ! String.class.isInstance(value))
            {
                throw new IllegalArgumentException("Invalid type of object specified for value in setByName");
            }
            setEmail((String) value);
            return true;
        }
        if (name.equals("Property"))
        {
            // Object fields can be null
            if (value != null && ! byte[].class.isInstance(value))
            {
                throw new IllegalArgumentException("Invalid type of object specified for value in setByName");
            }
            setProperty((byte[]) value);
            return true;
        }
        return false;
    }

    /**
     * Retrieves a field from the object by name passed in
     * as a String.  The String must be one of the static
     * Strings defined in this Class' Peer.
     *
     * @param name peer name
     * @return value
     */
    public Object getByPeerName(String name)
    {
        if (name.equals(JobEntryPeer.JOB_ID))
        {
            return new Integer(getJobId());
        }
        if (name.equals(JobEntryPeer.SECOND))
        {
            return new Integer(getSecond());
        }
        if (name.equals(JobEntryPeer.MINUTE))
        {
            return new Integer(getMinute());
        }
        if (name.equals(JobEntryPeer.HOUR))
        {
            return new Integer(getHour());
        }
        if (name.equals(JobEntryPeer.WEEK_DAY))
        {
            return new Integer(getWeekDay());
        }
        if (name.equals(JobEntryPeer.DAY_OF_MONTH))
        {
            return new Integer(getDayOfMonth());
        }
        if (name.equals(JobEntryPeer.TASK))
        {
            return getTask();
        }
        if (name.equals(JobEntryPeer.EMAIL))
        {
            return getEmail();
        }
        if (name.equals(JobEntryPeer.PROPERTY))
        {
            return getProperty();
        }
        return null;
    }

    /**
     * Set field values by Peer Field Name
     *
     * @param name field name
     * @param value field value
     * @return True if value was set, false if not (invalid name / protected field).
     * @throws IllegalArgumentException if object type of value does not match field object type.
     * @throws TorqueException If a problem occurs with the set[Field] method.
     */
    public boolean setByPeerName(String name, Object value)
        throws TorqueException, IllegalArgumentException
    {
      if (JobEntryPeer.JOB_ID.equals(name))
        {
            return setByName("JobId", value);
        }
      if (JobEntryPeer.SECOND.equals(name))
        {
            return setByName("Second", value);
        }
      if (JobEntryPeer.MINUTE.equals(name))
        {
            return setByName("Minute", value);
        }
      if (JobEntryPeer.HOUR.equals(name))
        {
            return setByName("Hour", value);
        }
      if (JobEntryPeer.WEEK_DAY.equals(name))
        {
            return setByName("WeekDay", value);
        }
      if (JobEntryPeer.DAY_OF_MONTH.equals(name))
        {
            return setByName("DayOfMonth", value);
        }
      if (JobEntryPeer.TASK.equals(name))
        {
            return setByName("Task", value);
        }
      if (JobEntryPeer.EMAIL.equals(name))
        {
            return setByName("Email", value);
        }
      if (JobEntryPeer.PROPERTY.equals(name))
        {
            return setByName("Property", value);
        }
        return false;
    }

    /**
     * Retrieves a field from the object by Position as specified
     * in the xml schema.  Zero-based.
     *
     * @param pos position in xml schema
     * @return value
     */
    public Object getByPosition(int pos)
    {
        if (pos == 0)
        {
            return new Integer(getJobId());
        }
        if (pos == 1)
        {
            return new Integer(getSecond());
        }
        if (pos == 2)
        {
            return new Integer(getMinute());
        }
        if (pos == 3)
        {
            return new Integer(getHour());
        }
        if (pos == 4)
        {
            return new Integer(getWeekDay());
        }
        if (pos == 5)
        {
            return new Integer(getDayOfMonth());
        }
        if (pos == 6)
        {
            return getTask();
        }
        if (pos == 7)
        {
            return getEmail();
        }
        if (pos == 8)
        {
            return getProperty();
        }
        return null;
    }

    /**
     * Set field values by its position (zero based) in the XML schema.
     *
     * @param position The field position
     * @param value field value
     * @return True if value was set, false if not (invalid position / protected field).
     * @throws IllegalArgumentException if object type of value does not match field object type.
     * @throws TorqueException If a problem occurs with the set[Field] method.
     */
    public boolean setByPosition(int position, Object value)
        throws TorqueException, IllegalArgumentException
    {
    if (position == 0)
        {
            return setByName("JobId", value);
        }
    if (position == 1)
        {
            return setByName("Second", value);
        }
    if (position == 2)
        {
            return setByName("Minute", value);
        }
    if (position == 3)
        {
            return setByName("Hour", value);
        }
    if (position == 4)
        {
            return setByName("WeekDay", value);
        }
    if (position == 5)
        {
            return setByName("DayOfMonth", value);
        }
    if (position == 6)
        {
            return setByName("Task", value);
        }
    if (position == 7)
        {
            return setByName("Email", value);
        }
    if (position == 8)
        {
            return setByName("Property", value);
        }
        return false;
    }
     
    /**
     * Stores the object in the database.  If the object is new,
     * it inserts it; otherwise an update is performed.
     *
     * @throws Exception
     */
    public void save() throws Exception
    {
        save(JobEntryPeer.DATABASE_NAME);
    }

    /**
     * Stores the object in the database.  If the object is new,
     * it inserts it; otherwise an update is performed.
     * Note: this code is here because the method body is
     * auto-generated conditionally and therefore needs to be
     * in this file instead of in the super class, BaseObject.
     *
     * @param dbName
     * @throws TorqueException
     */
    public void save(String dbName) throws TorqueException
    {
        Connection con = null;
        try
        {
            con = Transaction.begin(dbName);
            save(con);
            Transaction.commit(con);
        }
        catch(TorqueException e)
        {
            Transaction.safeRollback(con);
            throw e;
        }
    }

    /** flag to prevent endless save loop, if this object is referenced
        by another object which falls in this transaction. */
    private boolean alreadyInSave = false;
    /**
     * Stores the object in the database.  If the object is new,
     * it inserts it; otherwise an update is performed.  This method
     * is meant to be used as part of a transaction, otherwise use
     * the save() method and the connection details will be handled
     * internally
     *
     * @param con
     * @throws TorqueException
     */
    public void save(Connection con) throws TorqueException
    {
        if (!alreadyInSave)
        {
            alreadyInSave = true;



            // If this object has been modified, then save it to the database.
            if (isModified())
            {
                if (isNew())
                {
                    JobEntryPeer.doInsert((JobEntry) this, con);
                    setNew(false);
                }
                else
                {
                    JobEntryPeer.doUpdate((JobEntry) this, con);
                }
            }

            alreadyInSave = false;
        }
    }


    /**
     * Set the PrimaryKey using ObjectKey.
     *
     * @param key jobId ObjectKey
     */
    public void setPrimaryKey(ObjectKey key)
        
    {
        setJobId(((NumberKey) key).intValue());
    }

    /**
     * Set the PrimaryKey using a String.
     *
     * @param key
     */
    public void setPrimaryKey(String key) 
    {
        setJobId(Integer.parseInt(key));
    }


    /**
     * returns an id that differentiates this object from others
     * of its class.
     */
    public ObjectKey getPrimaryKey()
    {
        return SimpleKey.keyFor(getJobId());
    }
 

    /**
     * Makes a copy of this object.
     * It creates a new object filling in the simple attributes.
     * It then fills all the association collections and sets the
     * related objects to isNew=true.
     */
    public JobEntry copy() throws TorqueException
    {
        return copy(true);
    }

    /**
     * Makes a copy of this object using connection.
     * It creates a new object filling in the simple attributes.
     * It then fills all the association collections and sets the
     * related objects to isNew=true.
     *
     * @param con the database connection to read associated objects.
     */
    public JobEntry copy(Connection con) throws TorqueException
    {
        return copy(true, con);
    }

    /**
     * Makes a copy of this object.
     * It creates a new object filling in the simple attributes.
     * If the parameter deepcopy is true, it then fills all the
     * association collections and sets the related objects to
     * isNew=true.
     *
     * @param deepcopy whether to copy the associated objects.
     */
    public JobEntry copy(boolean deepcopy) throws TorqueException
    {
        return copyInto(new JobEntry(), deepcopy);
    }

    /**
     * Makes a copy of this object using connection.
     * It creates a new object filling in the simple attributes.
     * If the parameter deepcopy is true, it then fills all the
     * association collections and sets the related objects to
     * isNew=true.
     *
     * @param deepcopy whether to copy the associated objects.
     * @param con the database connection to read associated objects.
     */
    public JobEntry copy(boolean deepcopy, Connection con) throws TorqueException
    {
        return copyInto(new JobEntry(), deepcopy, con);
    }
  
    /**
     * Fills the copyObj with the contents of this object.
     * The associated objects are also copied and treated as new objects.
     *
     * @param copyObj the object to fill.
     */
    protected JobEntry copyInto(JobEntry copyObj) throws TorqueException
    {
        return copyInto(copyObj, true);
    }

  
    /**
     * Fills the copyObj with the contents of this object using connection.
     * The associated objects are also copied and treated as new objects.
     *
     * @param copyObj the object to fill.
     * @param con the database connection to read associated objects.
     */
    protected JobEntry copyInto(JobEntry copyObj, Connection con) throws TorqueException
    {
        return copyInto(copyObj, true, con);
    }
  
    /**
     * Fills the copyObj with the contents of this object.
     * If deepcopy is true, The associated objects are also copied
     * and treated as new objects.
     *
     * @param copyObj the object to fill.
     * @param deepcopy whether the associated objects should be copied.
     */
    protected JobEntry copyInto(JobEntry copyObj, boolean deepcopy) throws TorqueException
    {
        copyObj.setJobId(jobId);
        copyObj.setSecond(second);
        copyObj.setMinute(minute);
        copyObj.setHour(hour);
        copyObj.setWeekDay(weekDay);
        copyObj.setDayOfMonth(dayOfMonth);
        copyObj.setTask(task);
        copyObj.setEmail(email);
        copyObj.setProperty(property);

        copyObj.setJobId( 0);

        if (deepcopy)
        {
        }
        return copyObj;
    }
        
    
    /**
     * Fills the copyObj with the contents of this object using connection.
     * If deepcopy is true, The associated objects are also copied
     * and treated as new objects.
     *
     * @param copyObj the object to fill.
     * @param deepcopy whether the associated objects should be copied.
     * @param con the database connection to read associated objects.
     */
    protected JobEntry copyInto(JobEntry copyObj, boolean deepcopy, Connection con) throws TorqueException
    {
        copyObj.setJobId(jobId);
        copyObj.setSecond(second);
        copyObj.setMinute(minute);
        copyObj.setHour(hour);
        copyObj.setWeekDay(weekDay);
        copyObj.setDayOfMonth(dayOfMonth);
        copyObj.setTask(task);
        copyObj.setEmail(email);
        copyObj.setProperty(property);

        copyObj.setJobId( 0);

        if (deepcopy)
        {
        }
        return copyObj;
    }
    
    

    /**
     * returns a peer instance associated with this om.  Since Peer classes
     * are not to have any instance attributes, this method returns the
     * same instance for all member of this class. The method could therefore
     * be static, but this would prevent one from overriding the behavior.
     */
    public JobEntryPeer getPeer()
    {
        return peer;
    }

    /**
     * Retrieves the TableMap object related to this Table data without
     * compiler warnings of using getPeer().getTableMap().
     *
     * @return The associated TableMap object.
     */
    public TableMap getTableMap() throws TorqueException
    {
        return JobEntryPeer.getTableMap();
    }


    public String toString()
    {
        StringBuffer str = new StringBuffer();
        str.append("JobEntry:\n");
        str.append("JobId = ")
           .append(getJobId())
           .append("\n");
        str.append("Second = ")
           .append(getSecond())
           .append("\n");
        str.append("Minute = ")
           .append(getMinute())
           .append("\n");
        str.append("Hour = ")
           .append(getHour())
           .append("\n");
        str.append("WeekDay = ")
           .append(getWeekDay())
           .append("\n");
        str.append("DayOfMonth = ")
           .append(getDayOfMonth())
           .append("\n");
        str.append("Task = ")
           .append(getTask())
           .append("\n");
        str.append("Email = ")
           .append(getEmail())
           .append("\n");
        str.append("Property = ")
           .append("<binary>")
           .append("\n");
        return(str.toString());
    }
}
