/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.intake.transform;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.fulcrum.intake.transform.DTDResolver;
import org.apache.fulcrum.intake.xmlmodel.AppData;
import org.apache.fulcrum.intake.xmlmodel.Rule;
import org.apache.fulcrum.intake.xmlmodel.XmlField;
import org.apache.fulcrum.intake.xmlmodel.XmlGroup;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlToAppData
extends DefaultHandler
implements LogEnabled {
    private Logger log;
    private AppData app = new AppData();
    private XmlGroup currGroup;
    private XmlField currField;
    private Rule currRule;
    private String currElement;
    private StringBuffer chars;
    private static SAXParserFactory saxFactory = SAXParserFactory.newInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AppData parseFile(String xmlFile) throws ParserConfigurationException, SAXException, IOException {
        SAXParser parser = saxFactory.newSAXParser();
        FileReader fr = new FileReader(xmlFile);
        BufferedReader br = new BufferedReader(fr);
        this.chars = new StringBuffer();
        try {
            InputSource is = new InputSource(br);
            parser.parse(is, (DefaultHandler)this);
        }
        finally {
            br.close();
        }
        return this.app;
    }

    public void enableLogging(Logger logger) {
        this.log = logger.getChildLogger("XmlToAppData");
    }

    public InputSource resolveEntity(String publicId, String systemId) {
        return new DTDResolver().resolveEntity(publicId, systemId);
    }

    public void startElement(String uri, String localName, String rawName, Attributes attributes) {
        this.currElement = rawName;
        if (rawName.equals("input-data")) {
            this.app.loadFromXML(attributes);
        } else if (rawName.equals("group")) {
            this.currGroup = this.app.addGroup(attributes);
        } else if (rawName.equals("field")) {
            this.currField = this.currGroup.addField(attributes);
        } else if (rawName.equals("rule")) {
            this.currRule = this.currField.addRule(attributes);
        }
    }

    public void endElement(String uri, String localName, String name) throws SAXException {
        if ("rule".equals(this.currElement) && this.chars.length() > 0) {
            this.currRule.setMessage(this.chars.toString());
        } else if ("required-message".equals(this.currElement) && this.chars.length() > 0) {
            this.log.warn("The required-message element is deprecated!  You should update your intake.xml file to use the 'required' rule instead.");
            this.currField.setIfRequiredMessage(this.chars.toString());
        }
        this.chars = new StringBuffer();
    }

    public void characters(char[] mesgArray, int start, int length) {
        this.chars.append(mesgArray, start, length);
    }

    public void warning(SAXParseException spe) {
        this.log.warn("Parser Exception: Line " + spe.getLineNumber() + " Row: " + spe.getColumnNumber() + " Msg: " + spe.getMessage());
    }

    public void error(SAXParseException spe) {
        this.log.error("Parser Exception: Line " + spe.getLineNumber() + " Row: " + spe.getColumnNumber() + " Msg: " + spe.getMessage());
    }

    public void fatalError(SAXParseException spe) {
        this.log.fatalError("Parser Exception: Line " + spe.getLineNumber() + " Row: " + spe.getColumnNumber() + " Msg: " + spe.getMessage());
    }

    static {
        saxFactory.setValidating(true);
    }
}

