/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.yaafi.interceptor.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Iterator;
import org.apache.fulcrum.yaafi.framework.util.StringUtils;
import org.apache.fulcrum.yaafi.interceptor.util.InterceptorToStringBuilder;

public class ArgumentToStringBuilderImpl
implements InterceptorToStringBuilder {
    public static final int INCLUDE_CLASSNAME = 1;
    public static final int INCLUDE_HASHCODE = 2;
    private static int defaultMode = 0;
    private int mode;
    private static final int MAX_LINE_LENGTH = 2000;
    private static final char SEPERATOR = ';';
    private static final String NULL_STRING = "<null>";
    private static final String LENGTH_STRING = "length=";
    private static final String VALUE_STRING = "value=";
    private int maxArgLength;
    private StringBuffer buffer;
    private Object target;

    public ArgumentToStringBuilderImpl() {
        this.mode = defaultMode;
        this.maxArgLength = 2000;
        this.buffer = new StringBuffer();
    }

    public ArgumentToStringBuilderImpl(Object target) {
        this(target, 2000);
    }

    public ArgumentToStringBuilderImpl(Object target, int maxArgLength) {
        this(target, maxArgLength, defaultMode);
    }

    public ArgumentToStringBuilderImpl(Object target, int maxArgLength, int mode) {
        this.buffer = new StringBuffer();
        this.target = target;
        this.maxArgLength = maxArgLength;
        this.mode = mode;
    }

    public void setMaxArgLength(int maxArgLength) {
        this.maxArgLength = maxArgLength;
    }

    public void setTarget(Object target) {
        this.target = target;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public int getMode() {
        return this.mode;
    }

    public String toString() {
        try {
            if (this.target == null) {
                this.buffer.append(NULL_STRING);
            } else if (this.target instanceof Object[]) {
                this.appendClassName(this.target);
                this.appendHashCode(this.target);
                this.appendChar('[');
                this.append(this.toString((Object[])this.target));
                this.appendChar(']');
            } else if (this.target instanceof boolean[]) {
                this.appendClassName(this.target);
                this.appendHashCode(this.target);
                this.appendChar('[');
                this.append(this.toString((boolean[])this.target));
                this.appendChar(']');
            } else if (this.target instanceof char[]) {
                this.appendClassName(this.target);
                this.appendHashCode(this.target);
                this.appendChar('[');
                this.append(this.toString((char[])this.target));
                this.appendChar(']');
            } else if (this.target instanceof byte[]) {
                this.appendClassName(this.target);
                this.appendHashCode(this.target);
                this.appendChar('[');
                this.append(this.toString((byte[])this.target));
                this.appendChar(']');
            } else if (this.target instanceof short[]) {
                this.appendClassName(this.target);
                this.appendHashCode(this.target);
                this.appendChar('[');
                this.append(this.toString((short[])this.target));
                this.appendChar(']');
            } else if (this.target instanceof int[]) {
                this.appendClassName(this.target);
                this.appendHashCode(this.target);
                this.appendChar('[');
                this.append(this.toString((int[])this.target));
                this.appendChar(']');
            } else if (this.target instanceof long[]) {
                this.appendClassName(this.target);
                this.appendHashCode(this.target);
                this.appendChar('[');
                this.append(this.toString((long[])this.target));
                this.appendChar(']');
            } else if (this.target instanceof float[]) {
                this.appendClassName(this.target);
                this.appendHashCode(this.target);
                this.appendChar('[');
                this.append(this.toString((float[])this.target));
                this.appendChar(']');
            } else if (this.target instanceof double[]) {
                this.appendClassName(this.target);
                this.appendHashCode(this.target);
                this.appendChar('[');
                this.append(this.toString((double[])this.target));
                this.appendChar(']');
            } else if (this.target instanceof String) {
                this.appendClassName(this.target);
                this.appendHashCode(this.target);
                this.appendChar('[');
                this.append(this.toString((String)this.target));
                this.appendChar(']');
            } else if (this.target instanceof Collection) {
                this.appendClassName(this.target);
                this.appendHashCode(this.target);
                this.appendChar('[');
                this.append(this.toString((Collection)this.target));
                this.appendChar(']');
            } else if (this.target instanceof Dictionary) {
                this.appendClassName(this.target);
                this.appendHashCode(this.target);
                this.appendChar('[');
                this.append(this.toString((Dictionary)this.target));
                this.appendChar(']');
            } else if (this.target instanceof Throwable) {
                this.append(this.toString((Throwable)this.target));
            } else {
                this.append(this.toString(this.target));
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            return "<" + t + ">";
        }
        return this.buffer.toString();
    }

    protected String toString(Throwable throwable) {
        String result = null;
        result = throwable == null ? NULL_STRING : this.getStackTrace(throwable);
        return result;
    }

    protected String toString(Object[] array) {
        StringBuffer temp = new StringBuffer();
        ArgumentToStringBuilderImpl toStringBuilder = null;
        if (array == null) {
            return NULL_STRING;
        }
        temp.append(LENGTH_STRING);
        temp.append(array.length);
        temp.append(',');
        for (int i = 0; i < array.length; ++i) {
            temp.append('[');
            temp.append(i);
            temp.append(']');
            temp.append('=');
            toStringBuilder = new ArgumentToStringBuilderImpl(array[i], this.getMaxArgLength(), this.getMode());
            temp.append(toStringBuilder.toString());
            if (i < array.length - 1) {
                temp.append(',');
            }
            if (temp.length() > this.getMaxArgLength()) break;
        }
        return temp.toString();
    }

    protected String toString(boolean[] array) {
        StringBuffer temp = new StringBuffer();
        if (array == null) {
            return NULL_STRING;
        }
        temp.append(LENGTH_STRING);
        temp.append(array.length);
        temp.append(',');
        temp.append(VALUE_STRING);
        for (int i = 0; i < array.length; ++i) {
            temp.append(array[i]);
            if (i < array.length - 1) {
                temp.append(',');
            }
            if (temp.length() > this.getMaxArgLength()) break;
        }
        return temp.toString();
    }

    protected String toString(char[] array) {
        StringBuffer temp = new StringBuffer();
        if (array == null) {
            return NULL_STRING;
        }
        temp.append(LENGTH_STRING);
        temp.append(array.length);
        temp.append(',');
        temp.append(VALUE_STRING);
        for (int i = 0; i < array.length; ++i) {
            temp.append(array[i]);
            if (i < array.length - 1) {
                temp.append('.');
            }
            if (temp.length() > this.getMaxArgLength()) break;
        }
        return temp.toString();
    }

    protected String toString(short[] array) {
        StringBuffer temp = new StringBuffer();
        if (array == null) {
            return NULL_STRING;
        }
        temp.append(LENGTH_STRING);
        temp.append(array.length);
        temp.append(',');
        temp.append(VALUE_STRING);
        for (int i = 0; i < array.length; ++i) {
            temp.append(array[i]);
            if (i < array.length - 1) {
                temp.append(',');
            }
            if (temp.length() > this.getMaxArgLength()) break;
        }
        return temp.toString();
    }

    protected String toString(int[] array) {
        StringBuffer temp = new StringBuffer();
        if (array == null) {
            return NULL_STRING;
        }
        temp.append(LENGTH_STRING);
        temp.append(array.length);
        temp.append(',');
        temp.append(VALUE_STRING);
        for (int i = 0; i < array.length; ++i) {
            temp.append(array[i]);
            if (i < array.length - 1) {
                temp.append(',');
            }
            if (temp.length() > this.getMaxArgLength()) break;
        }
        return temp.toString();
    }

    protected String toString(long[] array) {
        StringBuffer temp = new StringBuffer();
        if (array == null) {
            return NULL_STRING;
        }
        temp.append(LENGTH_STRING);
        temp.append(array.length);
        temp.append(',');
        temp.append(VALUE_STRING);
        for (int i = 0; i < array.length; ++i) {
            temp.append(array[i]);
            if (i < array.length - 1) {
                temp.append(',');
            }
            if (temp.length() > this.getMaxArgLength()) break;
        }
        return temp.toString();
    }

    protected String toString(float[] array) {
        StringBuffer temp = new StringBuffer();
        if (array == null) {
            return NULL_STRING;
        }
        temp.append(LENGTH_STRING);
        temp.append(array.length);
        temp.append(',');
        temp.append(VALUE_STRING);
        for (int i = 0; i < array.length; ++i) {
            temp.append(array[i]);
            if (i < array.length - 1) {
                temp.append(',');
            }
            if (temp.length() > this.getMaxArgLength()) break;
        }
        return temp.toString();
    }

    protected String toString(double[] array) {
        StringBuffer temp = new StringBuffer();
        if (array == null) {
            return NULL_STRING;
        }
        temp.append(LENGTH_STRING);
        temp.append(array.length);
        temp.append(',');
        temp.append(VALUE_STRING);
        for (int i = 0; i < array.length; ++i) {
            temp.append(array[i]);
            if (i < array.length - 1) {
                temp.append(',');
            }
            if (temp.length() > this.getMaxArgLength()) break;
        }
        return temp.toString();
    }

    protected String toString(String string) {
        StringBuffer temp = new StringBuffer();
        if (string == null) {
            return NULL_STRING;
        }
        temp.append(LENGTH_STRING);
        temp.append(string.length());
        temp.append(',');
        temp.append(VALUE_STRING);
        temp.append(string);
        return temp.toString();
    }

    protected String toString(byte[] array) {
        StringBuffer temp = new StringBuffer();
        if (array == null) {
            temp.append(NULL_STRING);
        } else {
            temp.append(LENGTH_STRING);
            temp.append(array.length);
        }
        return temp.toString();
    }

    protected String toString(Collection collection) {
        int index = 0;
        StringBuffer temp = new StringBuffer();
        ArgumentToStringBuilderImpl toStringBuilder = null;
        if (collection == null) {
            return NULL_STRING;
        }
        temp.append(LENGTH_STRING);
        temp.append(collection.size());
        temp.append(',');
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            temp.append('[');
            temp.append(index++);
            temp.append(']');
            temp.append('=');
            toStringBuilder = new ArgumentToStringBuilderImpl(iterator.next(), this.getMaxArgLength(), this.getMode());
            temp.append(toStringBuilder.toString());
            if (index < collection.size() - 1) {
                temp.append(',');
            }
            if (temp.length() <= this.getMaxArgLength()) continue;
            break;
        }
        return temp.toString();
    }

    protected String toString(Dictionary dictionary) {
        StringBuffer temp = new StringBuffer();
        if (dictionary == null) {
            return NULL_STRING;
        }
        temp.append(LENGTH_STRING);
        temp.append(dictionary.size());
        temp.append(',');
        temp.append(VALUE_STRING);
        temp.append(dictionary.toString());
        return temp.toString();
    }

    protected String toString(Object object) {
        String result = null;
        String temp = null;
        String className = null;
        if (object == null) {
            result = NULL_STRING;
        } else {
            temp = object.toString();
            if (!temp.startsWith(className = StringUtils.replace(object.getClass().getName(), "java.lang.", ""))) {
                int hashCode = object.hashCode();
                StringBuffer tempBuffer = new StringBuffer();
                tempBuffer.append(className);
                tempBuffer.append('@');
                tempBuffer.append(hashCode);
                tempBuffer.append('[');
                tempBuffer.append(temp);
                tempBuffer.append(']');
                result = tempBuffer.toString();
            } else {
                result = temp;
            }
        }
        return result;
    }

    protected void appendHashCode(Object target) {
        if ((this.mode & 2) == 0) {
            return;
        }
        if (this.target != null) {
            this.buffer.append('@');
            this.buffer.append(Integer.toHexString(target.hashCode()));
        }
    }

    protected void appendClassName(Object target) {
        boolean skipClassName = true;
        if ((this.mode & 1) == 0) {
            return;
        }
        if (this.target != null) {
            String className = target.getClass().getName();
            if (target instanceof boolean[]) {
                this.buffer.append("boolean[]");
            } else if (target instanceof byte[]) {
                this.buffer.append("byte[]");
            } else if (target instanceof char[]) {
                this.buffer.append("char[]");
            } else if (target instanceof short[]) {
                this.buffer.append("short[]");
            } else if (target instanceof int[]) {
                this.buffer.append("int[]");
            } else if (target instanceof long[]) {
                this.buffer.append("[ong[]");
            } else if (target instanceof float[]) {
                this.buffer.append("float[]");
            } else if (target instanceof double[]) {
                this.buffer.append("double[]");
            } else if (target instanceof Boolean) {
                this.buffer.append("Boolean");
            } else if (target instanceof Character) {
                this.buffer.append("Character");
            } else if (target instanceof Short) {
                this.buffer.append("Short");
            } else if (target instanceof Integer) {
                this.buffer.append("Integer");
            } else if (target instanceof Long) {
                this.buffer.append("Long");
            } else if (target instanceof Float) {
                this.buffer.append("Float");
            } else if (target instanceof Double) {
                this.buffer.append("Double");
            } else if (target instanceof String) {
                this.buffer.append("String");
            } else if (target instanceof Boolean[]) {
                this.buffer.append("Boolean[]");
            } else if (target instanceof Character[]) {
                this.buffer.append("Character[]");
            } else if (target instanceof Short[]) {
                this.buffer.append("Short[]");
            } else if (target instanceof Integer[]) {
                this.buffer.append("Integer[]");
            } else if (target instanceof Long[]) {
                this.buffer.append("Long[]");
            } else if (target instanceof Float[]) {
                this.buffer.append("Float[]");
            } else if (target instanceof Double[]) {
                this.buffer.append("Double[]");
            } else if (target instanceof String[]) {
                this.buffer.append("String[]");
            } else {
                skipClassName = false;
            }
            if (!skipClassName) {
                if ((className = StringUtils.replace(className, "java.lang.", "")).endsWith(";")) {
                    this.buffer.append(className.substring(0, className.length() - 1));
                } else {
                    this.buffer.append(className);
                }
            }
        }
    }

    protected void appendChar(char ch) {
        this.buffer.append(ch);
    }

    protected int getMaxArgLength() {
        return this.maxArgLength;
    }

    protected String getStackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        throwable.printStackTrace(pw);
        return sw.getBuffer().toString();
    }

    protected void append(String source) {
        String formattedSource = this.format(source);
        this.buffer.append(formattedSource);
    }

    protected String format(String source) {
        boolean isTruncated = false;
        StringBuffer stringBuffer = new StringBuffer(source);
        if (stringBuffer.length() > this.getMaxArgLength()) {
            stringBuffer.delete(this.getMaxArgLength() - 1, stringBuffer.length());
            isTruncated = true;
        }
        for (int i = 0; i < stringBuffer.length(); ++i) {
            if (stringBuffer.charAt(i) == '\r' || stringBuffer.charAt(i) == '\n' || stringBuffer.charAt(i) == '\t') {
                stringBuffer.setCharAt(i, ' ');
            }
            if (stringBuffer.charAt(i) != ';') continue;
            stringBuffer.setCharAt(i, ' ');
        }
        if (isTruncated) {
            if (source.endsWith("]")) {
                stringBuffer.append(" ...]");
            } else {
                stringBuffer.append(" ...");
            }
        }
        return stringBuffer.toString();
    }
}

