/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.localization;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class LocaleTokenizer
implements Iterator {
    private static final String LOCALE_SEPARATOR = ",";
    private static final char QUALITY_SEPARATOR = ';';
    protected static final Float DEFAULT_QUALITY = new Float(1.0f);
    private ArrayList locales = new ArrayList(3);

    public LocaleTokenizer(String header) {
        StringTokenizer tok = new StringTokenizer(header, LOCALE_SEPARATOR);
        while (tok.hasMoreTokens()) {
            AcceptLanguage acceptLang = new AcceptLanguage();
            String element = tok.nextToken().trim();
            int index = element.indexOf(59);
            if (index != -1) {
                String q = element.substring(index);
                element = element.substring(0, index);
                index = q.indexOf(61);
                if (index != -1) {
                    try {
                        acceptLang.quality = Float.valueOf(q.substring(index + 1));
                    }
                    catch (NumberFormatException useDefault) {
                        // empty catch block
                    }
                }
            }
            acceptLang.locale = (index = (element = element.trim()).indexOf(45)) == -1 ? new Locale(element, "") : new Locale(element.substring(0, index), element.substring(index + 1));
            this.locales.add(acceptLang);
        }
        Collections.sort(this.locales, Collections.reverseOrder());
    }

    public boolean hasNext() {
        return !this.locales.isEmpty();
    }

    public Object next() {
        if (this.locales.isEmpty()) {
            throw new NoSuchElementException();
        }
        return ((AcceptLanguage)this.locales.remove((int)0)).locale;
    }

    public final void remove() {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support remove()");
    }

    protected static class AcceptLanguage
    implements Comparable {
        Locale locale;
        Float quality = DEFAULT_QUALITY;

        protected AcceptLanguage() {
        }

        public final int compareTo(Object acceptLang) {
            return this.quality.compareTo(((AcceptLanguage)acceptLang).quality);
        }
    }
}

