/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.logger;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.avalon.excalibur.logger.AbstractLoggerManager;
import org.apache.avalon.excalibur.logger.DefaultLogTargetFactoryManager;
import org.apache.avalon.excalibur.logger.DefaultLogTargetManager;
import org.apache.avalon.excalibur.logger.LogTargetFactoryManager;
import org.apache.avalon.excalibur.logger.LogTargetManager;
import org.apache.avalon.excalibur.logger.LoggerManager;
import org.apache.avalon.excalibur.logger.util.LoggerUtil;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.container.ContainerUtil;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.LogKitLogger;
import org.apache.log.ErrorHandler;
import org.apache.log.Hierarchy;
import org.apache.log.LogEvent;
import org.apache.log.LogTarget;
import org.apache.log.Logger;
import org.apache.log.Priority;
import org.apache.log.util.Closeable;

public class LogKitLoggerManager
extends AbstractLoggerManager
implements LoggerManager,
Contextualizable,
Configurable,
Disposable {
    private final Set m_targets = new HashSet();
    private Context m_context;
    private final Hierarchy m_hierarchy;

    public LogKitLoggerManager() {
        this(null, null, null, null, null);
    }

    public LogKitLoggerManager(String prefix) {
        this(prefix, null, null, null, null);
    }

    public LogKitLoggerManager(String prefix, String switchToCategory) {
        this(prefix, null, switchToCategory, null, null);
    }

    public LogKitLoggerManager(String prefix, Hierarchy hierarchy, String switchToCategory) {
        this(prefix, hierarchy, switchToCategory, null, null);
    }

    public LogKitLoggerManager(Hierarchy hierarchy) {
        this(null, hierarchy, null, null, null);
    }

    public LogKitLoggerManager(String prefix, Hierarchy hierarchy) {
        this(prefix, hierarchy, null, null, null);
    }

    public LogKitLoggerManager(String prefix, Hierarchy hierarchy, org.apache.avalon.framework.logger.Logger defaultOverrideAndFallback) {
        this(prefix, hierarchy, null, defaultOverrideAndFallback, defaultOverrideAndFallback);
    }

    public LogKitLoggerManager(String prefix, Hierarchy hierarchy, org.apache.avalon.framework.logger.Logger defaultLoggerOverride, org.apache.avalon.framework.logger.Logger fallbackLogger) {
        this(prefix, hierarchy, null, defaultLoggerOverride, fallbackLogger);
    }

    public LogKitLoggerManager(String prefix, Hierarchy hierarchy, String switchToCategory, org.apache.avalon.framework.logger.Logger defaultLoggerOverride, org.apache.avalon.framework.logger.Logger fallbackLogger) {
        super(prefix, switchToCategory, defaultLoggerOverride);
        this.m_prefix = prefix;
        if (hierarchy == null) {
            this.m_hierarchy = new Hierarchy();
            this.m_hierarchy.getRootLogger().unsetLogTargets(true);
            OurErrorHandler errorHandler = new OurErrorHandler(this.getLogger());
            this.m_hierarchy.setErrorHandler((ErrorHandler)errorHandler);
        } else {
            this.m_hierarchy = hierarchy;
        }
        if (fallbackLogger != null) {
            this.enableLogging(fallbackLogger);
        }
    }

    public final void contextualize(Context context) throws ContextException {
        this.m_context = context;
    }

    protected org.apache.avalon.framework.logger.Logger doGetLoggerForCategory(String fullCategoryName) {
        return new LogKitLogger(this.m_hierarchy.getLoggerFor(fullCategoryName));
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        Configuration factories = configuration.getChild("factories");
        LogTargetFactoryManager targetFactoryManager = this.setupTargetFactoryManager(factories);
        Configuration targets = configuration.getChild("targets");
        LogTargetManager targetManager = this.setupTargetManager(targets, targetFactoryManager);
        Configuration categories = configuration.getChild("categories");
        Configuration[] category = categories.getChildren("category");
        this.setupLoggers(targetManager, this.m_prefix, category, true, categories.getAttributeAsBoolean("additive", false));
    }

    private final LogTargetFactoryManager setupTargetFactoryManager(Configuration configuration) throws ConfigurationException {
        DefaultLogTargetFactoryManager targetFactoryManager = new DefaultLogTargetFactoryManager();
        ContainerUtil.enableLogging((Object)targetFactoryManager, (org.apache.avalon.framework.logger.Logger)this.getLogger());
        try {
            ContainerUtil.contextualize((Object)targetFactoryManager, (Context)this.m_context);
        }
        catch (ContextException ce) {
            throw new ConfigurationException("cannot contextualize default factory manager", (Throwable)ce);
        }
        ContainerUtil.configure((Object)targetFactoryManager, (Configuration)configuration);
        return targetFactoryManager;
    }

    private final LogTargetManager setupTargetManager(Configuration configuration, LogTargetFactoryManager targetFactoryManager) throws ConfigurationException {
        DefaultLogTargetManager targetManager = new DefaultLogTargetManager();
        ContainerUtil.enableLogging((Object)targetManager, (org.apache.avalon.framework.logger.Logger)this.getLogger());
        targetManager.setLogTargetFactoryManager(targetFactoryManager);
        ContainerUtil.configure((Object)targetManager, (Configuration)configuration);
        return targetManager;
    }

    private final void setupLoggers(LogTargetManager targetManager, String parentCategory, Configuration[] categories, boolean root, boolean defaultAdditive) throws ConfigurationException {
        boolean rootLoggerAlive = false;
        for (int i = 0; i < categories.length; ++i) {
            String category = categories[i].getAttribute("name");
            String fullCategory = LoggerUtil.getFullCategoryName(parentCategory, category);
            String loglevel = categories[i].getAttribute("log-level").toUpperCase();
            boolean additive = categories[i].getAttributeAsBoolean("additive", defaultAdditive);
            Configuration[] targets = categories[i].getChildren("log-target");
            LogTarget[] logTargets = new LogTarget[targets.length];
            for (int j = 0; j < targets.length; ++j) {
                String id = targets[j].getAttribute("id-ref");
                logTargets[j] = targetManager.getLogTarget(id);
                if (logTargets[j] == null) {
                    throw new ConfigurationException("Category <" + fullCategory + ">: " + "Target <" + id + "> is not defined.");
                }
                if (this.m_targets.contains(logTargets[j])) continue;
                this.m_targets.add(logTargets[j]);
            }
            if (root && "".equals(category) && logTargets.length > 0) {
                this.m_hierarchy.setDefaultPriority(Priority.getPriorityForName((String)loglevel));
                this.m_hierarchy.setDefaultLogTargets(logTargets);
                rootLoggerAlive = true;
            }
            Logger logger = this.m_hierarchy.getLoggerFor(fullCategory);
            this.m_loggers.put(fullCategory, new LogKitLogger(logger));
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("added logger for category " + fullCategory);
            }
            logger.setPriority(Priority.getPriorityForName((String)loglevel));
            logger.setLogTargets(logTargets);
            logger.setAdditivity(additive);
            Configuration[] subCategories = categories[i].getChildren("category");
            if (null == subCategories) continue;
            this.setupLoggers(targetManager, fullCategory, subCategories, false, defaultAdditive);
        }
        if (root && !rootLoggerAlive) {
            String message = "No log targets configured for the root logger.";
            throw new ConfigurationException("No log targets configured for the root logger.");
        }
    }

    public void dispose() {
        Iterator iterator = this.m_targets.iterator();
        while (iterator.hasNext()) {
            LogTarget target = (LogTarget)iterator.next();
            if (!(target instanceof Closeable)) continue;
            ((Closeable)target).close();
        }
    }

    private static class OurErrorHandler
    implements ErrorHandler {
        private org.apache.avalon.framework.logger.Logger m_reliableLogger;

        OurErrorHandler(org.apache.avalon.framework.logger.Logger reliableLogger) {
            if (reliableLogger == null) {
                throw new NullPointerException("reliableLogger");
            }
            this.m_reliableLogger = reliableLogger;
        }

        public void error(String message, Throwable throwable, LogEvent event) {
            this.m_reliableLogger.fatalError(message, throwable);
            Priority p = event.getPriority();
            String nestedMessage = "nested log event: " + event.getMessage();
            if (p == Priority.DEBUG) {
                this.m_reliableLogger.debug(nestedMessage, event.getThrowable());
            } else if (p == Priority.INFO) {
                this.m_reliableLogger.info(nestedMessage, event.getThrowable());
            } else if (p == Priority.WARN) {
                this.m_reliableLogger.warn(nestedMessage, event.getThrowable());
            } else if (p == Priority.ERROR) {
                this.m_reliableLogger.error(nestedMessage, event.getThrowable());
            } else if (p == Priority.FATAL_ERROR) {
                this.m_reliableLogger.fatalError(nestedMessage, event.getThrowable());
            } else {
                this.m_reliableLogger.error("unrecognized priority " + nestedMessage, event.getThrowable());
            }
        }
    }
}

