/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.modules.pages;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ecs.Doctype;
import org.apache.turbine.Turbine;
import org.apache.turbine.modules.ActionLoader;
import org.apache.turbine.modules.LayoutLoader;
import org.apache.turbine.modules.Page;
import org.apache.turbine.modules.Screen;
import org.apache.turbine.modules.ScreenLoader;
import org.apache.turbine.pipeline.PipelineData;
import org.apache.turbine.services.assemblerbroker.TurbineAssemblerBroker;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.TurbineException;

public class DefaultPage
extends Page {
    protected Log log = LogFactory.getLog(this.getClass());
    protected ActionLoader actionLoader = (ActionLoader)TurbineAssemblerBroker.getLoader("action");
    protected ScreenLoader screenLoader = (ScreenLoader)TurbineAssemblerBroker.getLoader("screen");
    protected LayoutLoader layoutLoader = (LayoutLoader)TurbineAssemblerBroker.getLoader("layout");

    @Override
    @Deprecated
    public void doBuild(RunData data) throws Exception {
        this.doBuildBeforeAction(data);
        if (data.hasAction()) {
            this.actionLoader.exec(data, data.getAction());
        }
        if (StringUtils.isNotEmpty((String)data.getRedirectURI())) {
            return;
        }
        this.setDefaultDoctype(data);
        this.doBuildAfterAction(data);
        String screenName = data.getScreen();
        this.log.debug((Object)("Building " + screenName));
        Screen aScreen = this.screenLoader.getAssembler(screenName);
        String layout = aScreen.getLayout(data);
        if (layout != null) {
            this.layoutLoader.exec(data, layout);
        } else {
            this.screenLoader.exec(data, screenName);
        }
        this.doPostBuild(data);
    }

    @Override
    public void doBuild(PipelineData pipelineData) throws Exception {
        RunData data = this.getRunData(pipelineData);
        this.doBuildBeforeAction(pipelineData);
        if (data.hasAction()) {
            this.actionLoader.exec(pipelineData, data.getAction());
        }
        if (StringUtils.isNotEmpty((String)data.getRedirectURI())) {
            return;
        }
        this.setDefaultDoctype(data);
        this.doBuildAfterAction(pipelineData);
        String screenName = data.getScreen();
        this.log.debug((Object)("Building " + screenName));
        Screen aScreen = this.screenLoader.getAssembler(screenName);
        String layout = aScreen.getLayout(pipelineData);
        if (layout != null) {
            this.layoutLoader.exec(pipelineData, layout);
        } else {
            this.screenLoader.exec(pipelineData, screenName);
        }
        this.doPostBuild(pipelineData);
    }

    @Deprecated
    protected void doBuildBeforeAction(RunData data) throws Exception {
    }

    @Deprecated
    protected void doBuildAfterAction(RunData data) throws Exception {
    }

    @Deprecated
    protected void doPostBuild(RunData data) throws Exception {
    }

    protected void doBuildBeforeAction(PipelineData pipelineData) throws Exception {
    }

    protected void doBuildAfterAction(PipelineData pipelineData) throws Exception {
    }

    protected void doPostBuild(PipelineData pipelineData) throws Exception {
    }

    private void setDefaultDoctype(RunData data) throws Exception {
        String errMsg = "default.doctype property not set properly in TurbineResources.properties!";
        List doctypeProperty = Turbine.getConfiguration().getList("default.doctype");
        if (doctypeProperty != null) {
            switch (doctypeProperty.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    String doc = (String)doctypeProperty.get(0);
                    if (doc.equalsIgnoreCase("Html40Transitional")) {
                        data.getPage().setDoctype((Doctype)new Doctype.Html40Transitional());
                        break;
                    }
                    if (doc.equalsIgnoreCase("Html40Strict")) {
                        data.getPage().setDoctype((Doctype)new Doctype.Html40Strict());
                        break;
                    }
                    if (doc.equalsIgnoreCase("Html40Frameset")) {
                        data.getPage().setDoctype((Doctype)new Doctype.Html40Frameset());
                        break;
                    }
                    throw new TurbineException(errMsg);
                }
                case 2: {
                    data.getPage().setDoctype(new Doctype().setIdentifier((String)doctypeProperty.get(0)).setUri((String)doctypeProperty.get(1)));
                    break;
                }
                default: {
                    throw new TurbineException(errMsg);
                }
            }
        }
    }
}

