/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util.velocity;

import java.net.URL;
import java.util.Hashtable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmail;
import org.apache.turbine.Turbine;
import org.apache.turbine.services.velocity.TurbineVelocity;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class VelocityHtmlEmail
extends HtmlEmail {
    private static Log log = LogFactory.getLog((Class)VelocityHtmlEmail.class);
    private String htmlTemplate = null;
    private String textTemplate = null;
    private Context context = null;
    private Hashtable embmap = null;
    private String mailServer;

    public VelocityHtmlEmail(RunData data) {
        this.context = TurbineVelocity.getContext(data);
        this.embmap = new Hashtable();
    }

    public VelocityHtmlEmail(Context context) {
        this.context = context;
        this.embmap = new Hashtable();
    }

    public VelocityHtmlEmail setHtmlTemplate(String template) {
        this.htmlTemplate = template;
        return this;
    }

    public VelocityHtmlEmail setTextTemplate(String template) {
        this.textTemplate = template;
        return this;
    }

    public void setMailServer(String serverAddress) {
        this.mailServer = serverAddress;
    }

    public String getMailServer() {
        return StringUtils.isNotEmpty((String)this.mailServer) ? this.mailServer : Turbine.getConfiguration().getString("mail.server", "localhost");
    }

    public String send() throws EmailException {
        this.context.put("mail", (Object)this);
        try {
            if (this.htmlTemplate != null) {
                this.setHtmlMsg(TurbineVelocity.handleRequest(this.context, this.htmlTemplate));
            }
            if (this.textTemplate != null) {
                this.setTextMsg(TurbineVelocity.handleRequest(this.context, this.textTemplate));
            }
        }
        catch (Exception e) {
            throw new EmailException("Cannot parse velocity template", (Throwable)e);
        }
        this.setHostName(this.getMailServer());
        return super.send();
    }

    public String embed(String surl, String name) throws EmailException {
        String cid = "";
        try {
            URL url = new URL(surl);
            cid = this.embed(url, name);
        }
        catch (Exception e) {
            log.error((Object)("cannot embed " + surl + ": "), (Throwable)e);
        }
        return cid;
    }

    public String getCid(String filename) {
        String cid = (String)this.embmap.get(filename);
        return "cid:" + cid;
    }
}

