/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util.security;

import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import org.apache.turbine.om.security.Role;
import org.apache.turbine.util.security.SecuritySet;

public class RoleSet
extends SecuritySet {
    private static final long serialVersionUID = -5521518890129125912L;

    public RoleSet() {
    }

    public RoleSet(Collection roles) {
        this.add(roles);
    }

    public boolean add(Role role) {
        boolean res = this.contains(role);
        this.nameMap.put(role.getName(), role);
        this.idMap.put(role.getIdAsObj(), role);
        return res;
    }

    public boolean add(Collection roles) {
        boolean res = false;
        Iterator it = roles.iterator();
        while (it.hasNext()) {
            Role r = (Role)it.next();
            res |= this.add(r);
        }
        return res;
    }

    public boolean add(RoleSet roleSet) {
        boolean res = false;
        Iterator it = roleSet.iterator();
        while (it.hasNext()) {
            Role r = (Role)it.next();
            res |= this.add(r);
        }
        return res;
    }

    public boolean remove(Role role) {
        boolean res = this.contains(role);
        this.nameMap.remove(role.getName());
        this.idMap.remove(role.getIdAsObj());
        return res;
    }

    public boolean contains(Role role) {
        return this.nameMap.containsValue(role);
    }

    public Role getRole(String roleName) {
        return this.getRoleByName(roleName);
    }

    public Role getRoleByName(String roleName) {
        return StringUtils.isNotEmpty((String)roleName) ? (Role)this.nameMap.get(roleName) : null;
    }

    public Role getRoleById(int roleId) {
        return roleId != 0 ? (Role)this.idMap.get(new Integer(roleId)) : null;
    }

    public Role[] getRolesArray() {
        return this.getSet().toArray(new Role[0]);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("RoleSet: ");
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Role r = (Role)it.next();
            sb.append('[');
            sb.append(r.getName());
            sb.append(" -> ");
            sb.append(r.getIdAsObj());
            sb.append(']');
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }
}

