/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.intake.model;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.apache.turbine.services.intake.IntakeException;
import org.apache.turbine.services.intake.model.BigDecimalField;
import org.apache.turbine.services.intake.model.BooleanField;
import org.apache.turbine.services.intake.model.ComboKeyField;
import org.apache.turbine.services.intake.model.DateStringField;
import org.apache.turbine.services.intake.model.DoubleField;
import org.apache.turbine.services.intake.model.Field;
import org.apache.turbine.services.intake.model.FileItemField;
import org.apache.turbine.services.intake.model.FloatField;
import org.apache.turbine.services.intake.model.Group;
import org.apache.turbine.services.intake.model.IntegerField;
import org.apache.turbine.services.intake.model.LongField;
import org.apache.turbine.services.intake.model.NumberKeyField;
import org.apache.turbine.services.intake.model.ShortField;
import org.apache.turbine.services.intake.model.StringField;
import org.apache.turbine.services.intake.model.StringKeyField;
import org.apache.turbine.services.intake.xmlmodel.XmlField;

public abstract class FieldFactory {
    private static Map fieldCtors = FieldFactory.initFieldCtors();
    static /* synthetic */ Class class$org$apache$turbine$services$intake$xmlmodel$XmlField;
    static /* synthetic */ Class class$org$apache$turbine$services$intake$model$Group;

    private static Map initFieldCtors() {
        fieldCtors = new HashMap();
        fieldCtors.put("int", new FieldCtor(){

            public Field getInstance(XmlField f, Group g) throws IntakeException {
                return new IntegerField(f, g);
            }
        });
        fieldCtors.put("boolean", new FieldCtor(){

            public Field getInstance(XmlField f, Group g) throws IntakeException {
                return new BooleanField(f, g);
            }
        });
        fieldCtors.put("String", new FieldCtor(){

            public Field getInstance(XmlField f, Group g) throws IntakeException {
                return new StringField(f, g);
            }
        });
        fieldCtors.put("BigDecimal", new FieldCtor(){

            public Field getInstance(XmlField f, Group g) throws IntakeException {
                return new BigDecimalField(f, g);
            }
        });
        fieldCtors.put("NumberKey", new FieldCtor(){

            public Field getInstance(XmlField f, Group g) throws IntakeException {
                return new NumberKeyField(f, g);
            }
        });
        fieldCtors.put("ComboKey", new FieldCtor(){

            public Field getInstance(XmlField f, Group g) throws IntakeException {
                return new ComboKeyField(f, g);
            }
        });
        fieldCtors.put("StringKey", new FieldCtor(){

            public Field getInstance(XmlField f, Group g) throws IntakeException {
                return new StringKeyField(f, g);
            }
        });
        fieldCtors.put("FileItem", new FieldCtor(){

            public Field getInstance(XmlField f, Group g) throws IntakeException {
                return new FileItemField(f, g);
            }
        });
        fieldCtors.put("DateString", new FieldCtor(){

            public Field getInstance(XmlField f, Group g) throws IntakeException {
                return new DateStringField(f, g);
            }
        });
        fieldCtors.put("float", new FieldCtor(){

            public Field getInstance(XmlField f, Group g) throws IntakeException {
                return new FloatField(f, g);
            }
        });
        fieldCtors.put("double", new FieldCtor(){

            public Field getInstance(XmlField f, Group g) throws IntakeException {
                return new DoubleField(f, g);
            }
        });
        fieldCtors.put("short", new FieldCtor(){

            public Field getInstance(XmlField f, Group g) throws IntakeException {
                return new ShortField(f, g);
            }
        });
        fieldCtors.put("long", new FieldCtor(){

            public Field getInstance(XmlField f, Group g) throws IntakeException {
                return new LongField(f, g);
            }
        });
        fieldCtors.put("custom", new FieldCtor(){

            public Field getInstance(XmlField f, Group g) throws IntakeException {
                String fieldClass = f.getFieldClass();
                if (fieldClass != null && fieldClass.indexOf(46) == -1) {
                    fieldClass = "org.apache.turbine.services.intake.model." + fieldClass;
                }
                if (fieldClass != null) {
                    try {
                        Class<?> field = Class.forName(fieldClass);
                        Constructor<?> constructor = field.getConstructor(class$org$apache$turbine$services$intake$xmlmodel$XmlField == null ? (class$org$apache$turbine$services$intake$xmlmodel$XmlField = FieldFactory.class$("org.apache.turbine.services.intake.xmlmodel.XmlField")) : class$org$apache$turbine$services$intake$xmlmodel$XmlField, class$org$apache$turbine$services$intake$model$Group == null ? (class$org$apache$turbine$services$intake$model$Group = FieldFactory.class$("org.apache.turbine.services.intake.model.Group")) : class$org$apache$turbine$services$intake$model$Group);
                        return (Field)constructor.newInstance(f, g);
                    }
                    catch (ClassNotFoundException e) {
                        throw new IntakeException("Could not load Field class(" + fieldClass + ")", e);
                    }
                    catch (Exception e) {
                        throw new IntakeException("Could not create new instance of Field(" + fieldClass + ")", e);
                    }
                }
                throw new IntakeException("Custom field types must define a fieldClass");
            }
        });
        return fieldCtors;
    }

    public static final Field getInstance(XmlField xmlField, Group xmlGroup) throws IntakeException {
        FieldCtor fieldCtor = null;
        Field field = null;
        String type = xmlField.getType();
        fieldCtor = (FieldCtor)fieldCtors.get(type);
        if (fieldCtor == null) {
            throw new IntakeException("An Unsupported type has been specified for " + xmlField.getName() + " in group " + xmlGroup.getIntakeGroupName() + " type = " + type);
        }
        field = fieldCtor.getInstance(xmlField, xmlGroup);
        return field;
    }

    private static abstract class FieldCtor {
        private FieldCtor() {
        }

        public Field getInstance(XmlField f, Group g) throws IntakeException {
            return null;
        }
    }
}

