/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util.parser;

import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.turbine.services.TurbineServices;

public abstract class ParserUtils {
    public static final String URL_CASE_FOLDING_KEY = "url.case.folding";
    public static final String URL_CASE_FOLDING_NONE_VALUE = "none";
    public static final String URL_CASE_FOLDING_LOWER_VALUE = "lower";
    public static final String URL_CASE_FOLDING_UPPER_VALUE = "upper";
    private static final int URL_CASE_FOLDING_UNSET = 0;
    public static final int URL_CASE_FOLDING_NONE = 1;
    public static final int URL_CASE_FOLDING_LOWER = 2;
    public static final int URL_CASE_FOLDING_UPPER = 3;
    private static Log log = LogFactory.getLog((Class)ParserUtils.class);
    private static int folding = 0;

    public static String convertAndTrim(String value) {
        return ParserUtils.convertAndTrim(value, ParserUtils.getUrlFolding());
    }

    public static String convertAndTrim(String value, int fold) {
        String tmp = null;
        if (value != null) {
            tmp = value.trim();
            switch (fold) {
                case 1: {
                    break;
                }
                case 2: {
                    tmp = tmp.toLowerCase();
                    break;
                }
                case 3: {
                    tmp = tmp.toUpperCase();
                    break;
                }
                default: {
                    log.error((Object)("Passed " + fold + " as fold rule, which is illegal!"));
                }
            }
        }
        return tmp;
    }

    public static int getUrlFolding() {
        if (folding == 0) {
            Configuration conf = TurbineServices.getInstance().getConfiguration();
            String foldString = conf.getString(URL_CASE_FOLDING_KEY, URL_CASE_FOLDING_NONE_VALUE).toLowerCase();
            folding = 1;
            log.debug((Object)("Setting folding from " + foldString));
            if (StringUtils.isNotEmpty((String)foldString)) {
                if (foldString.equals(URL_CASE_FOLDING_NONE_VALUE)) {
                    folding = 1;
                } else if (foldString.equals(URL_CASE_FOLDING_LOWER_VALUE)) {
                    folding = 2;
                } else if (foldString.equals(URL_CASE_FOLDING_UPPER_VALUE)) {
                    folding = 3;
                } else {
                    log.error((Object)("Got " + foldString + " from " + URL_CASE_FOLDING_KEY + " property, which is illegal!"));
                }
            }
        }
        return folding;
    }
}

