/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.security.torque.om;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.ObjectUtils;
import org.apache.torque.TorqueException;
import org.apache.torque.map.TableMap;
import org.apache.torque.om.BaseObject;
import org.apache.torque.om.NumberKey;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.om.SimpleKey;
import org.apache.torque.util.Criteria;
import org.apache.torque.util.Transaction;
import org.apache.turbine.services.security.torque.om.TurbineRole;
import org.apache.turbine.services.security.torque.om.TurbineRolePeer;
import org.apache.turbine.services.security.torque.om.TurbineRolePermission;
import org.apache.turbine.services.security.torque.om.TurbineRolePermissionPeer;
import org.apache.turbine.services.security.torque.om.TurbineUserGroupRole;
import org.apache.turbine.services.security.torque.om.TurbineUserGroupRolePeer;

public abstract class BaseTurbineRole
extends BaseObject {
    private static final long serialVersionUID = 1225810431540L;
    private static final TurbineRolePeer peer = new TurbineRolePeer();
    private int roleId;
    private String name;
    protected List collTurbineRolePermissions;
    private Criteria lastTurbineRolePermissionsCriteria = null;
    protected List collTurbineUserGroupRoles;
    private Criteria lastTurbineUserGroupRolesCriteria = null;
    private static List fieldNames = null;
    private boolean alreadyInSave = false;

    public int getRoleId() {
        return this.roleId;
    }

    public void setRoleId(int v) throws TorqueException {
        int i;
        if (this.roleId != v) {
            this.roleId = v;
            this.setModified(true);
        }
        if (this.collTurbineRolePermissions != null) {
            for (i = 0; i < this.collTurbineRolePermissions.size(); ++i) {
                ((TurbineRolePermission)((Object)this.collTurbineRolePermissions.get(i))).setRoleId(v);
            }
        }
        if (this.collTurbineUserGroupRoles != null) {
            for (i = 0; i < this.collTurbineUserGroupRoles.size(); ++i) {
                ((TurbineUserGroupRole)((Object)this.collTurbineUserGroupRoles.get(i))).setRoleId(v);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String v) {
        if (!ObjectUtils.equals((Object)this.name, (Object)v)) {
            this.name = v;
            this.setModified(true);
        }
    }

    protected void initTurbineRolePermissions() {
        if (this.collTurbineRolePermissions == null) {
            this.collTurbineRolePermissions = new ArrayList();
        }
    }

    public void addTurbineRolePermission(TurbineRolePermission l) throws TorqueException {
        this.getTurbineRolePermissions().add(l);
        l.setTurbineRole((TurbineRole)this);
    }

    public void addTurbineRolePermission(TurbineRolePermission l, Connection con) throws TorqueException {
        this.getTurbineRolePermissions(con).add(l);
        l.setTurbineRole((TurbineRole)this);
    }

    public List getTurbineRolePermissions() throws TorqueException {
        if (this.collTurbineRolePermissions == null) {
            this.collTurbineRolePermissions = this.getTurbineRolePermissions(new Criteria(10));
        }
        return this.collTurbineRolePermissions;
    }

    public List getTurbineRolePermissions(Criteria criteria) throws TorqueException {
        if (this.collTurbineRolePermissions == null) {
            if (this.isNew()) {
                this.collTurbineRolePermissions = new ArrayList();
            } else {
                criteria.add(TurbineRolePermissionPeer.ROLE_ID, this.getRoleId());
                this.collTurbineRolePermissions = TurbineRolePermissionPeer.doSelect(criteria);
            }
        } else if (!this.isNew()) {
            criteria.add(TurbineRolePermissionPeer.ROLE_ID, this.getRoleId());
            if (!this.lastTurbineRolePermissionsCriteria.equals((Object)criteria)) {
                this.collTurbineRolePermissions = TurbineRolePermissionPeer.doSelect(criteria);
            }
        }
        this.lastTurbineRolePermissionsCriteria = criteria;
        return this.collTurbineRolePermissions;
    }

    public List getTurbineRolePermissions(Connection con) throws TorqueException {
        if (this.collTurbineRolePermissions == null) {
            this.collTurbineRolePermissions = this.getTurbineRolePermissions(new Criteria(10), con);
        }
        return this.collTurbineRolePermissions;
    }

    public List getTurbineRolePermissions(Criteria criteria, Connection con) throws TorqueException {
        if (this.collTurbineRolePermissions == null) {
            if (this.isNew()) {
                this.collTurbineRolePermissions = new ArrayList();
            } else {
                criteria.add(TurbineRolePermissionPeer.ROLE_ID, this.getRoleId());
                this.collTurbineRolePermissions = TurbineRolePermissionPeer.doSelect(criteria, con);
            }
        } else if (!this.isNew()) {
            criteria.add(TurbineRolePermissionPeer.ROLE_ID, this.getRoleId());
            if (!this.lastTurbineRolePermissionsCriteria.equals((Object)criteria)) {
                this.collTurbineRolePermissions = TurbineRolePermissionPeer.doSelect(criteria, con);
            }
        }
        this.lastTurbineRolePermissionsCriteria = criteria;
        return this.collTurbineRolePermissions;
    }

    protected List getTurbineRolePermissionsJoinTurbineRole(Criteria criteria) throws TorqueException {
        if (this.collTurbineRolePermissions == null) {
            if (this.isNew()) {
                this.collTurbineRolePermissions = new ArrayList();
            } else {
                criteria.add(TurbineRolePermissionPeer.ROLE_ID, this.getRoleId());
                this.collTurbineRolePermissions = TurbineRolePermissionPeer.doSelectJoinTurbineRole(criteria);
            }
        } else {
            criteria.add(TurbineRolePermissionPeer.ROLE_ID, this.getRoleId());
            if (!this.lastTurbineRolePermissionsCriteria.equals((Object)criteria)) {
                this.collTurbineRolePermissions = TurbineRolePermissionPeer.doSelectJoinTurbineRole(criteria);
            }
        }
        this.lastTurbineRolePermissionsCriteria = criteria;
        return this.collTurbineRolePermissions;
    }

    protected List getTurbineRolePermissionsJoinTurbinePermission(Criteria criteria) throws TorqueException {
        if (this.collTurbineRolePermissions == null) {
            if (this.isNew()) {
                this.collTurbineRolePermissions = new ArrayList();
            } else {
                criteria.add(TurbineRolePermissionPeer.ROLE_ID, this.getRoleId());
                this.collTurbineRolePermissions = TurbineRolePermissionPeer.doSelectJoinTurbinePermission(criteria);
            }
        } else {
            criteria.add(TurbineRolePermissionPeer.ROLE_ID, this.getRoleId());
            if (!this.lastTurbineRolePermissionsCriteria.equals((Object)criteria)) {
                this.collTurbineRolePermissions = TurbineRolePermissionPeer.doSelectJoinTurbinePermission(criteria);
            }
        }
        this.lastTurbineRolePermissionsCriteria = criteria;
        return this.collTurbineRolePermissions;
    }

    protected void initTurbineUserGroupRoles() {
        if (this.collTurbineUserGroupRoles == null) {
            this.collTurbineUserGroupRoles = new ArrayList();
        }
    }

    public void addTurbineUserGroupRole(TurbineUserGroupRole l) throws TorqueException {
        this.getTurbineUserGroupRoles().add(l);
        l.setTurbineRole((TurbineRole)this);
    }

    public void addTurbineUserGroupRole(TurbineUserGroupRole l, Connection con) throws TorqueException {
        this.getTurbineUserGroupRoles(con).add(l);
        l.setTurbineRole((TurbineRole)this);
    }

    public List getTurbineUserGroupRoles() throws TorqueException {
        if (this.collTurbineUserGroupRoles == null) {
            this.collTurbineUserGroupRoles = this.getTurbineUserGroupRoles(new Criteria(10));
        }
        return this.collTurbineUserGroupRoles;
    }

    public List getTurbineUserGroupRoles(Criteria criteria) throws TorqueException {
        if (this.collTurbineUserGroupRoles == null) {
            if (this.isNew()) {
                this.collTurbineUserGroupRoles = new ArrayList();
            } else {
                criteria.add(TurbineUserGroupRolePeer.ROLE_ID, this.getRoleId());
                this.collTurbineUserGroupRoles = TurbineUserGroupRolePeer.doSelect(criteria);
            }
        } else if (!this.isNew()) {
            criteria.add(TurbineUserGroupRolePeer.ROLE_ID, this.getRoleId());
            if (!this.lastTurbineUserGroupRolesCriteria.equals((Object)criteria)) {
                this.collTurbineUserGroupRoles = TurbineUserGroupRolePeer.doSelect(criteria);
            }
        }
        this.lastTurbineUserGroupRolesCriteria = criteria;
        return this.collTurbineUserGroupRoles;
    }

    public List getTurbineUserGroupRoles(Connection con) throws TorqueException {
        if (this.collTurbineUserGroupRoles == null) {
            this.collTurbineUserGroupRoles = this.getTurbineUserGroupRoles(new Criteria(10), con);
        }
        return this.collTurbineUserGroupRoles;
    }

    public List getTurbineUserGroupRoles(Criteria criteria, Connection con) throws TorqueException {
        if (this.collTurbineUserGroupRoles == null) {
            if (this.isNew()) {
                this.collTurbineUserGroupRoles = new ArrayList();
            } else {
                criteria.add(TurbineUserGroupRolePeer.ROLE_ID, this.getRoleId());
                this.collTurbineUserGroupRoles = TurbineUserGroupRolePeer.doSelect(criteria, con);
            }
        } else if (!this.isNew()) {
            criteria.add(TurbineUserGroupRolePeer.ROLE_ID, this.getRoleId());
            if (!this.lastTurbineUserGroupRolesCriteria.equals((Object)criteria)) {
                this.collTurbineUserGroupRoles = TurbineUserGroupRolePeer.doSelect(criteria, con);
            }
        }
        this.lastTurbineUserGroupRolesCriteria = criteria;
        return this.collTurbineUserGroupRoles;
    }

    protected List getTurbineUserGroupRolesJoinTurbineUser(Criteria criteria) throws TorqueException {
        if (this.collTurbineUserGroupRoles == null) {
            if (this.isNew()) {
                this.collTurbineUserGroupRoles = new ArrayList();
            } else {
                criteria.add(TurbineUserGroupRolePeer.ROLE_ID, this.getRoleId());
                this.collTurbineUserGroupRoles = TurbineUserGroupRolePeer.doSelectJoinTurbineUser(criteria);
            }
        } else {
            criteria.add(TurbineUserGroupRolePeer.ROLE_ID, this.getRoleId());
            if (!this.lastTurbineUserGroupRolesCriteria.equals((Object)criteria)) {
                this.collTurbineUserGroupRoles = TurbineUserGroupRolePeer.doSelectJoinTurbineUser(criteria);
            }
        }
        this.lastTurbineUserGroupRolesCriteria = criteria;
        return this.collTurbineUserGroupRoles;
    }

    protected List getTurbineUserGroupRolesJoinTurbineGroup(Criteria criteria) throws TorqueException {
        if (this.collTurbineUserGroupRoles == null) {
            if (this.isNew()) {
                this.collTurbineUserGroupRoles = new ArrayList();
            } else {
                criteria.add(TurbineUserGroupRolePeer.ROLE_ID, this.getRoleId());
                this.collTurbineUserGroupRoles = TurbineUserGroupRolePeer.doSelectJoinTurbineGroup(criteria);
            }
        } else {
            criteria.add(TurbineUserGroupRolePeer.ROLE_ID, this.getRoleId());
            if (!this.lastTurbineUserGroupRolesCriteria.equals((Object)criteria)) {
                this.collTurbineUserGroupRoles = TurbineUserGroupRolePeer.doSelectJoinTurbineGroup(criteria);
            }
        }
        this.lastTurbineUserGroupRolesCriteria = criteria;
        return this.collTurbineUserGroupRoles;
    }

    protected List getTurbineUserGroupRolesJoinTurbineRole(Criteria criteria) throws TorqueException {
        if (this.collTurbineUserGroupRoles == null) {
            if (this.isNew()) {
                this.collTurbineUserGroupRoles = new ArrayList();
            } else {
                criteria.add(TurbineUserGroupRolePeer.ROLE_ID, this.getRoleId());
                this.collTurbineUserGroupRoles = TurbineUserGroupRolePeer.doSelectJoinTurbineRole(criteria);
            }
        } else {
            criteria.add(TurbineUserGroupRolePeer.ROLE_ID, this.getRoleId());
            if (!this.lastTurbineUserGroupRolesCriteria.equals((Object)criteria)) {
                this.collTurbineUserGroupRoles = TurbineUserGroupRolePeer.doSelectJoinTurbineRole(criteria);
            }
        }
        this.lastTurbineUserGroupRolesCriteria = criteria;
        return this.collTurbineUserGroupRoles;
    }

    public static synchronized List getFieldNames() {
        if (fieldNames == null) {
            fieldNames = new ArrayList();
            fieldNames.add("RoleId");
            fieldNames.add("Name");
            fieldNames = Collections.unmodifiableList(fieldNames);
        }
        return fieldNames;
    }

    public Object getByName(String name) {
        if (name.equals("RoleId")) {
            return new Integer(this.getRoleId());
        }
        if (name.equals("Name")) {
            return this.getName();
        }
        return null;
    }

    public boolean setByName(String name, Object value) throws TorqueException, IllegalArgumentException {
        if (name.equals("RoleId")) {
            if (value == null || !Integer.class.isInstance(value)) {
                throw new IllegalArgumentException("setByName: value parameter was null or not an Integer object.");
            }
            this.setRoleId((Integer)value);
            return true;
        }
        if (name.equals("Name")) {
            if (value != null && !String.class.isInstance(value)) {
                throw new IllegalArgumentException("Invalid type of object specified for value in setByName");
            }
            this.setName((String)value);
            return true;
        }
        return false;
    }

    public Object getByPeerName(String name) {
        if (name.equals(TurbineRolePeer.ROLE_ID)) {
            return new Integer(this.getRoleId());
        }
        if (name.equals(TurbineRolePeer.ROLE_NAME)) {
            return this.getName();
        }
        return null;
    }

    public boolean setByPeerName(String name, Object value) throws TorqueException, IllegalArgumentException {
        if (TurbineRolePeer.ROLE_ID.equals(name)) {
            return this.setByName("RoleId", value);
        }
        if (TurbineRolePeer.ROLE_NAME.equals(name)) {
            return this.setByName("Name", value);
        }
        return false;
    }

    public Object getByPosition(int pos) {
        if (pos == 0) {
            return new Integer(this.getRoleId());
        }
        if (pos == 1) {
            return this.getName();
        }
        return null;
    }

    public boolean setByPosition(int position, Object value) throws TorqueException, IllegalArgumentException {
        if (position == 0) {
            return this.setByName("RoleId", value);
        }
        if (position == 1) {
            return this.setByName("Name", value);
        }
        return false;
    }

    public void save() throws Exception {
        this.save(TurbineRolePeer.DATABASE_NAME);
    }

    public void save(String dbName) throws TorqueException {
        Connection con = null;
        try {
            con = Transaction.begin((String)dbName);
            this.save(con);
            Transaction.commit((Connection)con);
        }
        catch (TorqueException e) {
            Transaction.safeRollback((Connection)con);
            throw e;
        }
    }

    public void save(Connection con) throws TorqueException {
        if (!this.alreadyInSave) {
            int i;
            this.alreadyInSave = true;
            if (this.isModified()) {
                if (this.isNew()) {
                    TurbineRolePeer.doInsert((TurbineRole)this, con);
                    this.setNew(false);
                } else {
                    TurbineRolePeer.doUpdate((TurbineRole)this, con);
                }
            }
            if (this.collTurbineRolePermissions != null) {
                for (i = 0; i < this.collTurbineRolePermissions.size(); ++i) {
                    ((TurbineRolePermission)((Object)this.collTurbineRolePermissions.get(i))).save(con);
                }
            }
            if (this.collTurbineUserGroupRoles != null) {
                for (i = 0; i < this.collTurbineUserGroupRoles.size(); ++i) {
                    ((TurbineUserGroupRole)((Object)this.collTurbineUserGroupRoles.get(i))).save(con);
                }
            }
            this.alreadyInSave = false;
        }
    }

    public void setPrimaryKey(ObjectKey key) throws TorqueException {
        this.setRoleId(((NumberKey)key).intValue());
    }

    public void setPrimaryKey(String key) throws TorqueException {
        this.setRoleId(Integer.parseInt(key));
    }

    public ObjectKey getPrimaryKey() {
        return SimpleKey.keyFor((int)this.getRoleId());
    }

    public TurbineRole copy() throws TorqueException {
        return this.copy(true);
    }

    public TurbineRole copy(Connection con) throws TorqueException {
        return this.copy(true, con);
    }

    public TurbineRole copy(boolean deepcopy) throws TorqueException {
        return this.copyInto(new TurbineRole(), deepcopy);
    }

    public TurbineRole copy(boolean deepcopy, Connection con) throws TorqueException {
        return this.copyInto(new TurbineRole(), deepcopy, con);
    }

    protected TurbineRole copyInto(TurbineRole copyObj) throws TorqueException {
        return this.copyInto(copyObj, true);
    }

    protected TurbineRole copyInto(TurbineRole copyObj, Connection con) throws TorqueException {
        return this.copyInto(copyObj, true, con);
    }

    protected TurbineRole copyInto(TurbineRole copyObj, boolean deepcopy) throws TorqueException {
        copyObj.setRoleId(this.roleId);
        copyObj.setName(this.name);
        copyObj.setRoleId(0);
        if (deepcopy) {
            List vTurbineUserGroupRoles;
            List vTurbineRolePermissions = this.getTurbineRolePermissions();
            if (vTurbineRolePermissions != null) {
                for (int i = 0; i < vTurbineRolePermissions.size(); ++i) {
                    TurbineRolePermission obj = (TurbineRolePermission)((Object)vTurbineRolePermissions.get(i));
                    copyObj.addTurbineRolePermission(obj.copy());
                }
            } else {
                copyObj.collTurbineRolePermissions = null;
            }
            if ((vTurbineUserGroupRoles = this.getTurbineUserGroupRoles()) != null) {
                for (int i = 0; i < vTurbineUserGroupRoles.size(); ++i) {
                    TurbineUserGroupRole obj = (TurbineUserGroupRole)((Object)vTurbineUserGroupRoles.get(i));
                    copyObj.addTurbineUserGroupRole(obj.copy());
                }
            } else {
                copyObj.collTurbineUserGroupRoles = null;
            }
        }
        return copyObj;
    }

    protected TurbineRole copyInto(TurbineRole copyObj, boolean deepcopy, Connection con) throws TorqueException {
        copyObj.setRoleId(this.roleId);
        copyObj.setName(this.name);
        copyObj.setRoleId(0);
        if (deepcopy) {
            List vTurbineUserGroupRoles;
            List vTurbineRolePermissions = this.getTurbineRolePermissions(con);
            if (vTurbineRolePermissions != null) {
                for (int i = 0; i < vTurbineRolePermissions.size(); ++i) {
                    TurbineRolePermission obj = (TurbineRolePermission)((Object)vTurbineRolePermissions.get(i));
                    copyObj.addTurbineRolePermission(obj.copy(con), con);
                }
            } else {
                copyObj.collTurbineRolePermissions = null;
            }
            if ((vTurbineUserGroupRoles = this.getTurbineUserGroupRoles(con)) != null) {
                for (int i = 0; i < vTurbineUserGroupRoles.size(); ++i) {
                    TurbineUserGroupRole obj = (TurbineUserGroupRole)((Object)vTurbineUserGroupRoles.get(i));
                    copyObj.addTurbineUserGroupRole(obj.copy(con), con);
                }
            } else {
                copyObj.collTurbineUserGroupRoles = null;
            }
        }
        return copyObj;
    }

    public TurbineRolePeer getPeer() {
        return peer;
    }

    public TableMap getTableMap() throws TorqueException {
        return TurbineRolePeer.getTableMap();
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("TurbineRole:\n");
        str.append("RoleId = ").append(this.getRoleId()).append("\n");
        str.append("Name = ").append(this.getName()).append("\n");
        return str.toString();
    }
}

