/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.intake.model;

import org.apache.turbine.services.intake.IntakeException;
import org.apache.turbine.services.intake.model.Field;
import org.apache.turbine.services.intake.model.Group;
import org.apache.turbine.services.intake.validator.FloatValidator;
import org.apache.turbine.services.intake.xmlmodel.XmlField;

public class FloatField
extends Field {
    public FloatField(XmlField field, Group group) throws IntakeException {
        super(field, group);
    }

    public void setDefaultValue(String prop) {
        this.defaultValue = null;
        if (prop == null) {
            return;
        }
        this.defaultValue = new Float(prop);
    }

    public void setEmptyValue(String prop) {
        this.emptyValue = null;
        if (prop == null) {
            return;
        }
        this.emptyValue = new Double(prop);
    }

    protected Object getSafeEmptyValue() {
        if (this.isMultiValued) {
            return new float[0];
        }
        return null == this.getEmptyValue() ? new Float(0.0) : this.getEmptyValue();
    }

    protected String getDefaultValidator() {
        return FloatValidator.class.getName();
    }

    protected void doSetValue() {
        if (this.isMultiValued) {
            Float[] inputs = this.parser.getFloatObjects(this.getKey());
            float[] values = new float[inputs.length];
            for (int i = 0; i < inputs.length; ++i) {
                values[i] = inputs[i] == null ? ((Float)this.getEmptyValue()).floatValue() : inputs[i].floatValue();
            }
            this.setTestValue(values);
        } else {
            this.setTestValue(this.parser.getFloatObject(this.getKey(), (Float)this.getEmptyValue()));
        }
    }
}

