/*
 * Decompiled with CFR 0.152.
 */
package test.ojb.odmg;

import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import ojb.broker.Identity;
import ojb.broker.cache.ObjectCacheFactory;
import ojb.odmg.DatabaseImpl;
import ojb.odmg.OJB;
import ojb.odmg.states.ModificationState;
import ojb.odmg.states.StateNewClean;
import ojb.odmg.states.StateNewDirty;
import org.odmg.DCollection;
import org.odmg.Database;
import org.odmg.ODMGException;
import org.odmg.OQLQuery;
import org.odmg.Transaction;
import test.ojb.odmg.Article;

public class OdmgExamples
extends TestCase {
    private static Class CLASS = class$test$ojb$odmg$OdmgExamples == null ? (class$test$ojb$odmg$OdmgExamples = OdmgExamples.class$("test.ojb.odmg.OdmgExamples")) : class$test$ojb$odmg$OdmgExamples;
    private String databaseName;
    static /* synthetic */ Class class$test$ojb$odmg$OdmgExamples;
    static /* synthetic */ Class class$test$ojb$odmg$Article;

    public static void main(String[] args) {
        String[] arr = new String[]{CLASS.getName()};
        TestRunner.main((String[])arr);
    }

    public OdmgExamples(String name) {
        super(name);
    }

    public void setUp() {
        this.databaseName = "repository.xml";
    }

    public void tearDown() {
        this.databaseName = null;
    }

    public void testModificationStates() {
        OJB odmg = OJB.getInstance();
        Database db = odmg.newDatabase();
        try {
            db.open(this.databaseName, 2);
        }
        catch (ODMGException ex) {
            Assert.fail((String)("ODMGException: " + ex.getMessage()));
        }
        ModificationState oldState = StateNewClean.getInstance();
        ModificationState newState = oldState.markDirty();
        Assert.assertEquals((Object)StateNewDirty.getInstance(), (Object)newState);
        oldState = newState;
        newState = oldState.markDirty();
        Assert.assertEquals((Object)oldState, (Object)newState);
        try {
            db.close();
        }
        catch (ODMGException ex) {
            Assert.fail((String)("ODMGException: " + ex.getMessage()));
        }
    }

    public void testOdmgSession() {
        OJB odmg = OJB.getInstance();
        Database db = odmg.newDatabase();
        try {
            db.open(this.databaseName, 2);
        }
        catch (ODMGException ex) {
            Assert.fail((String)("ODMGException: " + ex.getMessage()));
        }
        Transaction tx = odmg.newTransaction();
        try {
            tx.begin();
            Article example = new Article();
            example.setArticleId(777);
            db.makePersistent(example);
            example.setStock(333);
            example.addToStock(47);
            example.addToStock(7);
            example.addToStock(4);
            System.out.println("now commit all changes...");
            tx.commit();
        }
        catch (Exception ex) {
            tx.abort();
        }
        try {
            db.close();
        }
        catch (ODMGException ex) {
            Assert.fail((String)("ODMGException: " + ex.getMessage()));
        }
    }

    public void testOQLQuery() {
        OJB odmg = OJB.getInstance();
        Database db = odmg.newDatabase();
        try {
            db.open(this.databaseName, 2);
        }
        catch (ODMGException ex) {
            Assert.fail((String)("ODMGException: " + ex.getMessage()));
        }
        Transaction tx = odmg.newTransaction();
        try {
            tx.begin();
            OQLQuery query = odmg.newOQLQuery();
            query.create("select anArticle from " + (class$test$ojb$odmg$Article == null ? (class$test$ojb$odmg$Article = OdmgExamples.class$("test.ojb.odmg.Article")) : class$test$ojb$odmg$Article).getName() + " where articleId = 7");
            List results = (List)query.execute();
            Article a = (Article)results.get(0);
            Article example = new Article();
            example.setArticleId(7);
            Identity oid = new Identity(example);
            ObjectCacheFactory.getObjectCache().clear();
            Article b = (Article)((DatabaseImpl)db).getBroker().getObjectByIdentity(oid);
            Assert.assertEquals((String)"should be same object", (Object)a, (Object)b);
            System.out.println("now commit all changes...");
            tx.commit();
        }
        catch (Exception ex) {
            tx.abort();
            Assert.fail((String)("ODMGException: " + ex.getMessage()));
        }
        try {
            db.close();
        }
        catch (ODMGException ex) {
            Assert.fail((String)("ODMGException: " + ex.getMessage()));
        }
    }

    public void testOQLQueryBind() {
        OJB odmg = OJB.getInstance();
        Database db = odmg.newDatabase();
        try {
            db.open(this.databaseName, 2);
        }
        catch (ODMGException ex) {
            Assert.fail((String)("ODMGException: " + ex.getMessage()));
        }
        Transaction tx = odmg.newTransaction();
        try {
            tx.begin();
            OQLQuery query = odmg.newOQLQuery();
            query.create("select anArticle from " + (class$test$ojb$odmg$Article == null ? (class$test$ojb$odmg$Article = OdmgExamples.class$("test.ojb.odmg.Article")) : class$test$ojb$odmg$Article).getName() + " where articleId = $678");
            query.bind(new Integer(7));
            List results = (List)query.execute();
            Article a = (Article)results.get(0);
            Article example = new Article();
            example.setArticleId(7);
            Identity oid = new Identity(example);
            ObjectCacheFactory.getObjectCache().clear();
            Article b = (Article)((DatabaseImpl)db).getBroker().getObjectByIdentity(oid);
            Assert.assertEquals((String)"should be same object", (Object)a, (Object)b);
            System.out.println("now commit all changes...");
            tx.commit();
        }
        catch (Exception ex) {
            tx.abort();
            Assert.fail((String)("ODMGException: " + ex.getMessage()));
        }
        try {
            db.close();
        }
        catch (ODMGException ex) {
            Assert.fail((String)("ODMGException: " + ex.getMessage()));
        }
    }

    public void tesOQLQueryOnCollections() {
        OJB odmg = OJB.getInstance();
        Database db = odmg.newDatabase();
        try {
            db.open(this.databaseName, 2);
        }
        catch (ODMGException ex) {
            Assert.fail((String)("ODMGException: " + ex.getMessage()));
        }
        Transaction tx = odmg.newTransaction();
        try {
            tx.begin();
            OQLQuery query = odmg.newOQLQuery();
            query.create("select aLotOfArticles from " + (class$test$ojb$odmg$Article == null ? (class$test$ojb$odmg$Article = OdmgExamples.class$("test.ojb.odmg.Article")) : class$test$ojb$odmg$Article).getName() + " where productGroupId = 4");
            DCollection results = (DCollection)query.execute();
            results = results.query("price > 35");
            query = odmg.newOQLQuery();
            query.create("select aLotOfArticles from " + (class$test$ojb$odmg$Article == null ? (class$test$ojb$odmg$Article = OdmgExamples.class$("test.ojb.odmg.Article")) : class$test$ojb$odmg$Article).getName() + " where productGroupId = 4 and price  > 35");
            DCollection check = (DCollection)query.execute();
            Assert.assertEquals((Object)results, (Object)check);
            tx.commit();
        }
        catch (Exception ex) {
            tx.abort();
            ex.printStackTrace();
            Assert.fail((String)("ODMGException: " + ex.getMessage()));
        }
        try {
            db.close();
        }
        catch (ODMGException ex) {
            Assert.fail((String)("ODMGException: " + ex.getMessage()));
        }
    }

    public void tesWrongDbName() {
        OJB objectserver = OJB.getInstance();
        Database db = objectserver.newDatabase();
        String wrongDatabaseName = "ThereIsNoSuchFile";
        try {
            db.open(wrongDatabaseName, 2);
            Assert.fail((String)("should not be able to open database " + wrongDatabaseName));
        }
        catch (ODMGException ex) {
            return;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

