/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.messagelet.impl;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.messagelet.MessageDrivenObjectSupport;
import org.apache.commons.messagelet.impl.MessageletRequestImpl;
import org.apache.commons.messagelet.impl.MessageletResponseImpl;
import org.apache.commons.messagelet.impl.ServletRequestImpl;
import org.apache.commons.messagelet.impl.ServletResponseImpl;
import org.apache.commons.messenger.Messenger;
import org.apache.commons.messenger.MessengerListener;

public class MessageServletDispatcher
extends MessageDrivenObjectSupport
implements MessengerListener {
    private MessageletRequestImpl request;
    private MessageletResponseImpl response;
    private Messenger messenger;
    private String path;

    public MessageServletDispatcher() {
    }

    public MessageServletDispatcher(String path) {
        this();
        this.path = path;
    }

    public void init() throws ServletException {
        this.request = new MessageletRequestImpl(new ServletRequestImpl(this.getServletContext()));
        this.response = new MessageletResponseImpl(new ServletResponseImpl());
    }

    public void setMessenger(Messenger messenger) {
        this.response.setReplyMessenger(messenger);
    }

    public void onMessage(Message message) {
        try {
            this.response.setReplyToDestination(message.getJMSReplyTo());
        }
        catch (JMSException e) {
            this.log("Could not find JMS replyTo destination", e);
            this.response.setReplyToDestination(null);
        }
        try {
            this.request.setMessage(message);
            this.response.reset();
            this.getServletContext().getRequestDispatcher(this.getPath()).include((ServletRequest)this.request, (ServletResponse)this.response);
            this.response.finish();
        }
        catch (Throwable e) {
            this.handleException(message, e);
        }
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    protected void handleException(Message message, Throwable t) {
        this.log("Caught exception processing message: " + message, t);
    }
}

