/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.betwixt.strategy;

import java.io.Serializable;

public abstract class TypeBindingStrategy {
    public static final TypeBindingStrategy DEFAULT = new Default();

    public abstract BindingType bindingType(Class var1);

    public static final class Default
    extends TypeBindingStrategy {
        private static final Class[] INHERITED_SIMPLE = new Class[]{class$java$lang$Number == null ? (class$java$lang$Number = Default.class$("java.lang.Number")) : class$java$lang$Number, class$java$lang$String == null ? (class$java$lang$String = Default.class$("java.lang.String")) : class$java$lang$String, class$java$util$Date == null ? (class$java$util$Date = Default.class$("java.util.Date")) : class$java$util$Date, class$java$sql$Date == null ? (class$java$sql$Date = Default.class$("java.sql.Date")) : class$java$sql$Date, class$java$sql$Time == null ? (class$java$sql$Time = Default.class$("java.sql.Time")) : class$java$sql$Time, class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = Default.class$("java.sql.Timestamp")) : class$java$sql$Timestamp, class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = Default.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, class$java$math$BigInteger == null ? (class$java$math$BigInteger = Default.class$("java.math.BigInteger")) : class$java$math$BigInteger};
        private static final Class[] INHERITED_COMPLEX = new Class[]{class$java$lang$Throwable == null ? (class$java$lang$Throwable = Default.class$("java.lang.Throwable")) : class$java$lang$Throwable};
        static /* synthetic */ Class class$java$lang$Number;
        static /* synthetic */ Class class$java$lang$String;
        static /* synthetic */ Class class$java$util$Date;
        static /* synthetic */ Class class$java$sql$Date;
        static /* synthetic */ Class class$java$sql$Time;
        static /* synthetic */ Class class$java$sql$Timestamp;
        static /* synthetic */ Class class$java$math$BigDecimal;
        static /* synthetic */ Class class$java$math$BigInteger;
        static /* synthetic */ Class class$java$lang$Throwable;
        static /* synthetic */ Class class$java$lang$Object;

        public BindingType bindingType(Class type) {
            BindingType result = BindingType.COMPLEX;
            if (this.isStandardPrimitive(type)) {
                result = BindingType.PRIMITIVE;
            }
            return result;
        }

        protected boolean isStandardPrimitive(Class type) {
            if (type == null) {
                return false;
            }
            if (type.isPrimitive()) {
                return true;
            }
            if (type.equals(class$java$lang$Object == null ? (class$java$lang$Object = Default.class$("java.lang.Object")) : class$java$lang$Object)) {
                return false;
            }
            int i = 0;
            int size = INHERITED_SIMPLE.length;
            while (i < size) {
                if (INHERITED_SIMPLE[i].equals(type)) {
                    return true;
                }
                ++i;
            }
            int i2 = 0;
            int size2 = INHERITED_COMPLEX.length;
            while (i2 < size2) {
                if (INHERITED_COMPLEX[i2].equals(type)) {
                    return false;
                }
                ++i2;
            }
            int i3 = 0;
            int size3 = INHERITED_COMPLEX.length;
            while (i3 < size3) {
                if (INHERITED_COMPLEX[i3].isAssignableFrom(type)) {
                    return false;
                }
                ++i3;
            }
            if (type.getName().startsWith("java.lang.")) {
                return true;
            }
            int i4 = 0;
            int size4 = INHERITED_SIMPLE.length;
            while (i4 < size4) {
                if (INHERITED_SIMPLE[i4].isAssignableFrom(type)) {
                    return true;
                }
                ++i4;
            }
            return false;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static final class BindingType
    implements Serializable {
        private static final int COMPLEX_INDICATOR = 1;
        private static final int PRIMITIVE_INDICATOR = 2;
        public static final BindingType COMPLEX = new BindingType(1);
        public static final BindingType PRIMITIVE = new BindingType(2);
        private int type;

        private BindingType(int type) {
            this.type = type;
        }

        public boolean equals(Object object) {
            boolean result = false;
            if (object instanceof BindingType) {
                BindingType bindingType = (BindingType)object;
                result = this.type == bindingType.type;
            }
            return result;
        }

        public int hashCode() {
            return this.type;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("BindingType: ");
            switch (this.type) {
                case 1: {
                    buffer.append("COMPLEX");
                    break;
                }
                case 2: {
                    buffer.append("PRIMITIVE");
                }
            }
            return buffer.toString();
        }
    }
}

