/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.betwixt;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.betwixt.AttributeDescriptor;
import org.apache.commons.betwixt.BeanProperty;
import org.apache.commons.betwixt.Descriptor;
import org.apache.commons.betwixt.ElementDescriptor;
import org.apache.commons.betwixt.IntrospectionConfiguration;
import org.apache.commons.betwixt.NodeDescriptor;
import org.apache.commons.betwixt.XMLBeanInfo;
import org.apache.commons.betwixt.digester.MultiMappingBeanInfoDigester;
import org.apache.commons.betwixt.digester.XMLBeanInfoDigester;
import org.apache.commons.betwixt.digester.XMLIntrospectorHelper;
import org.apache.commons.betwixt.expression.EmptyExpression;
import org.apache.commons.betwixt.expression.IteratorExpression;
import org.apache.commons.betwixt.expression.MapEntryAdder;
import org.apache.commons.betwixt.expression.MethodUpdater;
import org.apache.commons.betwixt.expression.StringExpression;
import org.apache.commons.betwixt.registry.DefaultXMLBeanInfoRegistry;
import org.apache.commons.betwixt.registry.PolymorphicReferenceResolver;
import org.apache.commons.betwixt.registry.XMLBeanInfoRegistry;
import org.apache.commons.betwixt.strategy.ClassNormalizer;
import org.apache.commons.betwixt.strategy.DefaultNameMapper;
import org.apache.commons.betwixt.strategy.DefaultPluralStemmer;
import org.apache.commons.betwixt.strategy.NameMapper;
import org.apache.commons.betwixt.strategy.PluralStemmer;
import org.apache.commons.betwixt.strategy.TypeBindingStrategy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLIntrospector {
    protected Log log = LogFactory.getLog((Class)(class$org$apache$commons$betwixt$XMLIntrospector == null ? (class$org$apache$commons$betwixt$XMLIntrospector = XMLIntrospector.class$("org.apache.commons.betwixt.XMLIntrospector")) : class$org$apache$commons$betwixt$XMLIntrospector));
    private XMLBeanInfoRegistry registry;
    private XMLBeanInfoDigester digester;
    private MultiMappingBeanInfoDigester multiMappingdigester;
    private IntrospectionConfiguration configuration;
    private PolymorphicReferenceResolver polymorphicReferenceResolver;
    static /* synthetic */ Class class$org$apache$commons$betwixt$XMLIntrospector;
    static /* synthetic */ Class class$java$util$Map;

    public XMLIntrospector() {
        this(new IntrospectionConfiguration());
    }

    public XMLIntrospector(IntrospectionConfiguration configuration) {
        this.setConfiguration(configuration);
        DefaultXMLBeanInfoRegistry defaultRegistry = new DefaultXMLBeanInfoRegistry();
        this.setRegistry(defaultRegistry);
        this.setPolymorphicReferenceResolver(defaultRegistry);
    }

    public Log getLog() {
        return this.getConfiguration().getIntrospectionLog();
    }

    public void setLog(Log log) {
        this.getConfiguration().setIntrospectionLog(log);
    }

    public XMLBeanInfoRegistry getRegistry() {
        return this.registry;
    }

    public void setRegistry(XMLBeanInfoRegistry registry) {
        this.registry = registry;
    }

    public IntrospectionConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(IntrospectionConfiguration configuration) {
        this.configuration = configuration;
    }

    public ClassNormalizer getClassNormalizer() {
        return this.getConfiguration().getClassNormalizer();
    }

    public void setClassNormalizer(ClassNormalizer classNormalizer) {
        this.getConfiguration().setClassNormalizer(classNormalizer);
    }

    public PolymorphicReferenceResolver getPolymorphicReferenceResolver() {
        return this.polymorphicReferenceResolver;
    }

    public void setPolymorphicReferenceResolver(PolymorphicReferenceResolver polymorphicReferenceResolver) {
        this.polymorphicReferenceResolver = polymorphicReferenceResolver;
    }

    public boolean isCachingEnabled() {
        return true;
    }

    public void setCachingEnabled(boolean cachingEnabled) {
    }

    public boolean isAttributesForPrimitives() {
        return this.getConfiguration().isAttributesForPrimitives();
    }

    public void setAttributesForPrimitives(boolean attributesForPrimitives) {
        this.getConfiguration().setAttributesForPrimitives(attributesForPrimitives);
    }

    public boolean isWrapCollectionsInElement() {
        return this.getConfiguration().isWrapCollectionsInElement();
    }

    public void setWrapCollectionsInElement(boolean wrapCollectionsInElement) {
        this.getConfiguration().setWrapCollectionsInElement(wrapCollectionsInElement);
    }

    public PluralStemmer getPluralStemmer() {
        return this.getConfiguration().getPluralStemmer();
    }

    public void setPluralStemmer(PluralStemmer pluralStemmer) {
        this.getConfiguration().setPluralStemmer(pluralStemmer);
    }

    public NameMapper getNameMapper() {
        return this.getElementNameMapper();
    }

    public void setNameMapper(NameMapper nameMapper) {
        this.setElementNameMapper(nameMapper);
    }

    public NameMapper getElementNameMapper() {
        return this.getConfiguration().getElementNameMapper();
    }

    public void setElementNameMapper(NameMapper nameMapper) {
        this.getConfiguration().setElementNameMapper(nameMapper);
    }

    public NameMapper getAttributeNameMapper() {
        return this.getConfiguration().getAttributeNameMapper();
    }

    public void setAttributeNameMapper(NameMapper nameMapper) {
        this.getConfiguration().setAttributeNameMapper(nameMapper);
    }

    public boolean useBeanInfoSearchPath() {
        return this.getConfiguration().useBeanInfoSearchPath();
    }

    public void setUseBeanInfoSearchPath(boolean useBeanInfoSearchPath) {
        this.getConfiguration().setUseBeanInfoSearchPath(useBeanInfoSearchPath);
    }

    public void flushCache() {
    }

    public XMLBeanInfo introspect(Object bean) throws IntrospectionException {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((Object)"Introspecting...");
            this.getLog().debug(bean);
        }
        if (bean instanceof DynaBean) {
            XMLBeanInfo xmlBeanInfo = this.findByXMLDescriptor(bean.getClass());
            if (xmlBeanInfo != null) {
                return xmlBeanInfo;
            }
            return this.introspect(((DynaBean)bean).getDynaClass());
        }
        Class normalClass = this.getClassNormalizer().getNormalizedClass(bean);
        return this.introspect(normalClass);
    }

    public XMLBeanInfo introspect(DynaClass dynaClass) {
        XMLBeanInfo xmlInfo = this.createXMLBeanInfo(dynaClass);
        DynaClassBeanType beanClass = new DynaClassBeanType(dynaClass);
        this.populate(xmlInfo, beanClass);
        return xmlInfo;
    }

    public synchronized XMLBeanInfo introspect(Class aClass, InputSource source) throws IOException, SAXException {
        this.configureDigester(aClass);
        XMLBeanInfo result = (XMLBeanInfo)this.digester.parse(source);
        return result;
    }

    public XMLBeanInfo introspect(Class aClass) throws IntrospectionException {
        XMLBeanInfo xmlInfo;
        String[] searchPath = null;
        if (!this.getConfiguration().useBeanInfoSearchPath()) {
            searchPath = Introspector.getBeanInfoSearchPath();
            Introspector.setBeanInfoSearchPath(new String[0]);
        }
        if ((xmlInfo = this.registry.get(aClass)) == null) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((Object)("Attempting to lookup an XML descriptor for class: " + aClass));
            }
            if ((xmlInfo = this.findByXMLDescriptor(aClass)) == null) {
                BeanInfo info = Introspector.getBeanInfo(aClass);
                xmlInfo = this.introspect(info);
            }
            if (xmlInfo != null) {
                this.registry.put(aClass, xmlInfo);
            }
        } else {
            this.getLog().trace((Object)"Used cached XMLBeanInfo.");
        }
        if (this.getLog().isTraceEnabled()) {
            this.getLog().trace((Object)xmlInfo);
        }
        if (!this.getConfiguration().useBeanInfoSearchPath()) {
            Introspector.setBeanInfoSearchPath(searchPath);
        }
        return xmlInfo;
    }

    public XMLBeanInfo introspect(BeanInfo beanInfo) throws IntrospectionException {
        XMLBeanInfo xmlBeanInfo = this.createXMLBeanInfo(beanInfo);
        this.populate(xmlBeanInfo, new JavaBeanType(beanInfo));
        return xmlBeanInfo;
    }

    public synchronized Class[] register(InputSource source) throws IntrospectionException, IOException, SAXException {
        Map xmlBeanInfoByClass = this.loadMultiMapping(source);
        Set keySet = xmlBeanInfoByClass.keySet();
        Class[] mappedClasses = new Class[keySet.size()];
        int i = 0;
        Iterator it = keySet.iterator();
        while (it.hasNext()) {
            Class clazz = (Class)it.next();
            mappedClasses[i++] = clazz;
            XMLBeanInfo xmlBeanInfo = (XMLBeanInfo)xmlBeanInfoByClass.get(clazz);
            if (xmlBeanInfo == null) continue;
            this.getRegistry().put(clazz, xmlBeanInfo);
        }
        return mappedClasses;
    }

    private synchronized Map loadMultiMapping(InputSource mapping) throws IOException, SAXException {
        if (this.multiMappingdigester == null) {
            this.multiMappingdigester = new MultiMappingBeanInfoDigester();
            this.multiMappingdigester.setXMLIntrospector(this);
        }
        Map multiBeanInfoMap = (Map)this.multiMappingdigester.parse(mapping);
        return multiBeanInfoMap;
    }

    public void register(Class aClass, InputSource source) throws IOException, SAXException {
        XMLBeanInfo xmlBeanInfo = this.introspect(aClass, source);
        this.getRegistry().put(aClass, xmlBeanInfo);
    }

    private void populate(XMLBeanInfo xmlBeanInfo, BeanType bean) {
        String name = bean.getBeanName();
        ElementDescriptor elementDescriptor = new ElementDescriptor();
        elementDescriptor.setLocalName(this.getElementNameMapper().mapTypeToElementName(name));
        elementDescriptor.setPropertyType(bean.getElementType());
        if (this.getLog().isTraceEnabled()) {
            this.getLog().trace((Object)("Populating:" + bean));
        }
        if (bean.isPrimitiveType()) {
            this.getLog().trace((Object)"Bean is primitive");
            elementDescriptor.setTextExpression(StringExpression.getInstance());
        } else {
            Descriptor[] descriptors;
            int size;
            this.getLog().trace((Object)"Bean is standard type");
            boolean isLoopType = bean.isLoopType();
            ArrayList<ElementDescriptor> elements = new ArrayList<ElementDescriptor>();
            ArrayList attributes = new ArrayList();
            ArrayList contents = new ArrayList();
            if (!isLoopType || !this.isBasicCollection(bean.getClass())) {
                this.addProperties(bean.getProperties(), elements, attributes, contents);
            }
            if (isLoopType) {
                this.getLog().trace((Object)"Bean is loop");
                ElementDescriptor loopDescriptor = new ElementDescriptor();
                loopDescriptor.setCollective(true);
                loopDescriptor.setContextExpression(new IteratorExpression(EmptyExpression.getInstance()));
                if (bean.isMapType()) {
                    loopDescriptor.setQualifiedName("entry");
                }
                elements.add(loopDescriptor);
            }
            if ((size = elements.size()) > 0) {
                descriptors = new ElementDescriptor[size];
                elements.toArray(descriptors);
                elementDescriptor.setElementDescriptors((ElementDescriptor[])descriptors);
            }
            if ((size = attributes.size()) > 0) {
                descriptors = new AttributeDescriptor[size];
                attributes.toArray(descriptors);
                elementDescriptor.setAttributeDescriptors((AttributeDescriptor[])descriptors);
            }
            if ((size = contents.size()) > 0 && size > 0) {
                descriptors = new Descriptor[size];
                contents.toArray(descriptors);
                elementDescriptor.setContentDescriptors(descriptors);
            }
        }
        xmlBeanInfo.setElementDescriptor(elementDescriptor);
        this.defaultAddMethods(elementDescriptor, bean.getElementType());
        if (this.getLog().isTraceEnabled()) {
            this.getLog().trace((Object)"Populated descriptor:");
            this.getLog().trace((Object)elementDescriptor);
        }
    }

    private boolean isBasicCollection(Class type) {
        return type.getName().startsWith("java.util");
    }

    protected XMLBeanInfo createXMLBeanInfo(DynaClass dynaClass) {
        XMLBeanInfo beanInfo = new XMLBeanInfo(dynaClass.getClass());
        return beanInfo;
    }

    public Descriptor createDescriptor(PropertyDescriptor propertyDescriptor, boolean useAttributesForPrimitives) throws IntrospectionException {
        return this.createXMLDescriptor(new BeanProperty(propertyDescriptor));
    }

    public Descriptor createXMLDescriptor(BeanProperty beanProperty) {
        return beanProperty.createXMLDescriptor(this.configuration);
    }

    public void defaultAddMethods(ElementDescriptor rootDescriptor, Class beanClass) {
        if (beanClass != null) {
            ArrayList<Method> singleParameterAdders = new ArrayList<Method>();
            ArrayList<Method> twinParameterAdders = new ArrayList<Method>();
            Method[] methods = beanClass.getMethods();
            int i = 0;
            int size = methods.length;
            while (i < size) {
                Class<?>[] types;
                Method method = methods[i];
                String name = method.getName();
                if (name.startsWith("add") && (types = method.getParameterTypes()) != null) {
                    if (this.getLog().isTraceEnabled()) {
                        this.getLog().trace((Object)("Searching for match for " + method));
                    }
                    switch (types.length) {
                        case 1: {
                            singleParameterAdders.add(method);
                            break;
                        }
                        case 2: {
                            twinParameterAdders.add(method);
                            break;
                        }
                    }
                }
                ++i;
            }
            Map elementsByPropertyName = this.makeElementDescriptorMap(rootDescriptor);
            Iterator it = ((AbstractList)singleParameterAdders).iterator();
            while (it.hasNext()) {
                Method singleParameterAdder = (Method)it.next();
                this.setIteratorAdder(elementsByPropertyName, singleParameterAdder);
            }
            Iterator it2 = ((AbstractList)twinParameterAdders).iterator();
            while (it2.hasNext()) {
                Method twinParameterAdder = (Method)it2.next();
                this.setMapAdder(elementsByPropertyName, twinParameterAdder);
            }
            this.configureMappingDerivation(rootDescriptor);
        }
    }

    private void configureMappingDerivation(ElementDescriptor descriptor) {
        boolean useBindTime = this.getConfiguration().getMappingDerivationStrategy().useBindTimeTypeForMapping(descriptor.getPropertyType(), descriptor.getSingularPropertyType());
        descriptor.setUseBindTimeTypeForMapping(useBindTime);
        ElementDescriptor[] childDescriptors = descriptor.getElementDescriptors();
        int i = 0;
        int size = childDescriptors.length;
        while (i < size) {
            this.configureMappingDerivation(childDescriptors[i]);
            ++i;
        }
    }

    private void setIteratorAdder(Map elementsByPropertyName, Method singleParameterAdderMethod) {
        String adderName = singleParameterAdderMethod.getName();
        String propertyName = Introspector.decapitalize(adderName.substring(3));
        ElementDescriptor matchingDescriptor = this.getMatchForAdder(propertyName, elementsByPropertyName);
        if (matchingDescriptor != null) {
            Class<?> singularType = singleParameterAdderMethod.getParameterTypes()[0];
            if (this.getLog().isTraceEnabled()) {
                this.getLog().trace((Object)(adderName + "->" + propertyName));
            }
            this.getLog().trace((Object)"Matching collection or iteration");
            matchingDescriptor.setUpdater(new MethodUpdater(singleParameterAdderMethod));
            matchingDescriptor.setSingularPropertyType(singularType);
            matchingDescriptor.setHollow(!this.isPrimitiveType(singularType));
            String localName = matchingDescriptor.getLocalName();
            if (localName == null || localName.length() == 0) {
                matchingDescriptor.setLocalName(this.getElementNameMapper().mapTypeToElementName(propertyName));
            }
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((Object)("!! " + singleParameterAdderMethod));
                this.getLog().debug((Object)("!! " + singularType));
            }
        }
    }

    private void setMapAdder(Map elementsByPropertyName, Method twinParameterAdderMethod) {
        String adderName = twinParameterAdderMethod.getName();
        String propertyName = Introspector.decapitalize(adderName.substring(3));
        ElementDescriptor matchingDescriptor = this.getMatchForAdder(propertyName, elementsByPropertyName);
        if (matchingDescriptor != null && (class$java$util$Map == null ? (class$java$util$Map = XMLIntrospector.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(matchingDescriptor.getPropertyType())) {
            this.getLog().trace((Object)"Matching map");
            ElementDescriptor[] children = matchingDescriptor.getElementDescriptors();
            if (children.length == 0) {
                this.getLog().info((Object)"'entry' descriptor is missing for map. Updaters cannot be set");
            } else {
                Class<?>[] types = twinParameterAdderMethod.getParameterTypes();
                Class<?> keyType = types[0];
                Class<?> valueType = types[1];
                MapEntryAdder adder = new MapEntryAdder(twinParameterAdderMethod);
                int n = 0;
                int noOfGrandChildren = children.length;
                while (n < noOfGrandChildren) {
                    if ("key".equals(children[n].getLocalName())) {
                        children[n].setUpdater(adder.getKeyUpdater());
                        children[n].setSingularPropertyType(keyType);
                        if (children[n].getPropertyType() == null) {
                            children[n].setPropertyType(valueType);
                        }
                        if (this.isPrimitiveType(keyType)) {
                            children[n].setHollow(false);
                        }
                        if (this.getLog().isTraceEnabled()) {
                            this.getLog().trace((Object)("Key descriptor: " + children[n]));
                        }
                    } else if ("value".equals(children[n].getLocalName())) {
                        children[n].setUpdater(adder.getValueUpdater());
                        children[n].setSingularPropertyType(valueType);
                        if (children[n].getPropertyType() == null) {
                            children[n].setPropertyType(valueType);
                        }
                        if (this.isPrimitiveType(valueType)) {
                            children[n].setHollow(false);
                        }
                        if (this.isLoopType(valueType)) {
                            ElementDescriptor loopDescriptor = new ElementDescriptor();
                            loopDescriptor.setHollow(true);
                            loopDescriptor.setSingularPropertyType(valueType);
                            loopDescriptor.setPropertyType(valueType);
                            children[n].addElementDescriptor(loopDescriptor);
                            loopDescriptor.setCollective(true);
                        }
                        if (this.getLog().isTraceEnabled()) {
                            this.getLog().trace((Object)("Value descriptor: " + children[n]));
                        }
                    }
                    ++n;
                }
            }
        }
    }

    private ElementDescriptor getMatchForAdder(String propertyName, Map elementsByPropertyName) {
        ElementDescriptor matchingDescriptor = null;
        if (propertyName.length() > 0) {
            if (this.getLog().isTraceEnabled()) {
                this.getLog().trace((Object)("findPluralDescriptor( " + propertyName + " ):root property name=" + propertyName));
            }
            PluralStemmer stemmer = this.getPluralStemmer();
            matchingDescriptor = stemmer.findPluralDescriptor(propertyName, elementsByPropertyName);
            if (this.getLog().isTraceEnabled()) {
                this.getLog().trace((Object)("findPluralDescriptor( " + propertyName + " ):ElementDescriptor=" + matchingDescriptor));
            }
        }
        return matchingDescriptor;
    }

    private Map makeElementDescriptorMap(ElementDescriptor rootDescriptor) {
        HashMap<String, ElementDescriptor> result = new HashMap<String, ElementDescriptor>();
        String rootPropertyName = rootDescriptor.getPropertyName();
        if (rootPropertyName != null) {
            result.put(rootPropertyName, rootDescriptor);
        }
        this.makeElementDescriptorMap(rootDescriptor, result);
        return result;
    }

    private void makeElementDescriptorMap(ElementDescriptor rootDescriptor, Map map) {
        ElementDescriptor[] children = rootDescriptor.getElementDescriptors();
        if (children != null) {
            int i = 0;
            int size = children.length;
            while (i < size) {
                ElementDescriptor child = children[i];
                String propertyName = child.getPropertyName();
                if (propertyName != null) {
                    map.put(propertyName, child);
                }
                this.makeElementDescriptorMap(child, map);
                ++i;
            }
        }
    }

    protected PluralStemmer createPluralStemmer() {
        return new DefaultPluralStemmer();
    }

    protected NameMapper createNameMapper() {
        return new DefaultNameMapper();
    }

    protected synchronized XMLBeanInfo findByXMLDescriptor(Class aClass) {
        URL url;
        String name = aClass.getName();
        int idx = name.lastIndexOf(46);
        if (idx >= 0) {
            name = name.substring(idx + 1);
        }
        if ((url = aClass.getResource(name = name + ".betwixt")) != null) {
            try {
                String urlText = url.toString();
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((Object)("Parsing Betwixt XML descriptor: " + urlText));
                }
                this.configureDigester(aClass);
                return (XMLBeanInfo)this.digester.parse(urlText);
            }
            catch (Exception e) {
                this.getLog().warn((Object)("Caught exception trying to parse: " + name), (Throwable)e);
            }
        }
        if (this.getLog().isTraceEnabled()) {
            this.getLog().trace((Object)("Could not find betwixt file " + name));
        }
        return null;
    }

    private synchronized void configureDigester(Class aClass) {
        if (this.digester == null) {
            this.digester = new XMLBeanInfoDigester();
            this.digester.setXMLIntrospector(this);
        }
        this.digester.setBeanClass(aClass);
    }

    protected void addProperties(BeanInfo beanInfo, List elements, List attributes, List contents) throws IntrospectionException {
        PropertyDescriptor[] descriptors = beanInfo.getPropertyDescriptors();
        if (descriptors != null) {
            int i = 0;
            int size = descriptors.length;
            while (i < size) {
                this.addProperty(beanInfo, descriptors[i], elements, attributes, contents);
                ++i;
            }
        }
        if (this.getLog().isTraceEnabled()) {
            this.getLog().trace((Object)elements);
            this.getLog().trace((Object)attributes);
            this.getLog().trace((Object)contents);
        }
    }

    protected void addProperties(BeanProperty[] beanProperties, List elements, List attributes, List contents) {
        if (beanProperties != null) {
            if (this.getLog().isTraceEnabled()) {
                this.getLog().trace((Object)(beanProperties.length + " properties to be added"));
            }
            int i = 0;
            int size = beanProperties.length;
            while (i < size) {
                this.addProperty(beanProperties[i], elements, attributes, contents);
                ++i;
            }
        }
        if (this.getLog().isTraceEnabled()) {
            this.getLog().trace((Object)"After properties have been added (elements, attributes, contents):");
            this.getLog().trace((Object)elements);
            this.getLog().trace((Object)attributes);
            this.getLog().trace((Object)contents);
        }
    }

    protected void addProperty(BeanInfo beanInfo, PropertyDescriptor propertyDescriptor, List elements, List attributes, List contents) throws IntrospectionException {
        this.addProperty(propertyDescriptor, elements, attributes, contents);
    }

    protected void addProperty(PropertyDescriptor propertyDescriptor, List elements, List attributes, List contents) throws IntrospectionException {
        this.addProperty(new BeanProperty(propertyDescriptor), elements, attributes, contents);
    }

    protected void addProperty(BeanProperty beanProperty, List elements, List attributes, List contents) {
        Descriptor nodeDescriptor = this.createXMLDescriptor(beanProperty);
        if (nodeDescriptor == null) {
            return;
        }
        if (nodeDescriptor instanceof ElementDescriptor) {
            elements.add(nodeDescriptor);
        } else if (nodeDescriptor instanceof AttributeDescriptor) {
            attributes.add(nodeDescriptor);
        } else {
            contents.add(nodeDescriptor);
        }
    }

    protected void addProperties(BeanInfo beanInfo, List elements, List attributes) throws IntrospectionException {
        PropertyDescriptor[] descriptors = beanInfo.getPropertyDescriptors();
        if (descriptors != null) {
            int i = 0;
            int size = descriptors.length;
            while (i < size) {
                this.addProperty(beanInfo, descriptors[i], elements, attributes);
                ++i;
            }
        }
        if (this.getLog().isTraceEnabled()) {
            this.getLog().trace((Object)elements);
            this.getLog().trace((Object)attributes);
        }
    }

    protected void addProperty(BeanInfo beanInfo, PropertyDescriptor propertyDescriptor, List elements, List attributes) throws IntrospectionException {
        NodeDescriptor nodeDescriptor = XMLIntrospectorHelper.createDescriptor(propertyDescriptor, this.isAttributesForPrimitives(), this);
        if (nodeDescriptor == null) {
            return;
        }
        if (nodeDescriptor instanceof ElementDescriptor) {
            elements.add(nodeDescriptor);
        } else {
            attributes.add(nodeDescriptor);
        }
    }

    protected XMLBeanInfo createXMLBeanInfo(BeanInfo beanInfo) {
        XMLBeanInfo xmlBeanInfo = new XMLBeanInfo(beanInfo.getBeanDescriptor().getBeanClass());
        return xmlBeanInfo;
    }

    public boolean isLoopType(Class type) {
        return this.getConfiguration().isLoopType(type);
    }

    public boolean isPrimitiveType(Class type) {
        TypeBindingStrategy.BindingType bindingType = this.configuration.getTypeBindingStrategy().bindingType(type);
        boolean result = bindingType.equals(TypeBindingStrategy.BindingType.PRIMITIVE);
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class DynaClassBeanType
    extends BeanType {
        private DynaClass dynaClass;
        private BeanProperty[] properties;
        static /* synthetic */ Class class$org$apache$commons$beanutils$DynaClass;

        public DynaClassBeanType(DynaClass dynaClass) {
            this.dynaClass = dynaClass;
            DynaProperty[] dynaProperties = dynaClass.getDynaProperties();
            this.properties = new BeanProperty[dynaProperties.length];
            int i = 0;
            int size = dynaProperties.length;
            while (i < size) {
                this.properties[i] = new BeanProperty(dynaProperties[i]);
                ++i;
            }
        }

        public String getBeanName() {
            return this.dynaClass.getName();
        }

        public Class getElementType() {
            return class$org$apache$commons$beanutils$DynaClass == null ? (class$org$apache$commons$beanutils$DynaClass = DynaClassBeanType.class$("org.apache.commons.beanutils.DynaClass")) : class$org$apache$commons$beanutils$DynaClass;
        }

        public boolean isPrimitiveType() {
            return false;
        }

        public boolean isMapType() {
            return false;
        }

        public boolean isLoopType() {
            return false;
        }

        public BeanProperty[] getProperties() {
            return this.properties;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private class JavaBeanType
    extends BeanType {
        private BeanInfo beanInfo;
        private Class beanClass;
        private String name;
        private BeanProperty[] properties;
        static /* synthetic */ Class class$java$util$Map;

        public JavaBeanType(BeanInfo beanInfo) {
            this.beanInfo = beanInfo;
            BeanDescriptor beanDescriptor = beanInfo.getBeanDescriptor();
            this.beanClass = beanDescriptor.getBeanClass();
            this.name = beanDescriptor.getName();
            if (this.beanClass.isArray()) {
                this.name = "Array";
            }
        }

        public Class getElementType() {
            return this.beanClass;
        }

        public String getBeanName() {
            return this.name;
        }

        public boolean isPrimitiveType() {
            return XMLIntrospector.this.isPrimitiveType(this.beanClass);
        }

        public boolean isLoopType() {
            return XMLIntrospector.this.getConfiguration().isLoopType(this.beanClass);
        }

        public boolean isMapType() {
            return (class$java$util$Map == null ? (class$java$util$Map = JavaBeanType.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(this.beanClass);
        }

        public BeanProperty[] getProperties() {
            if (this.properties == null) {
                BeanInfo[] additionals;
                ArrayList<PropertyDescriptor> propertyDescriptors = new ArrayList<PropertyDescriptor>();
                PropertyDescriptor[] descriptors = this.beanInfo.getPropertyDescriptors();
                if (descriptors != null) {
                    int i = 0;
                    int size = descriptors.length;
                    while (i < size) {
                        if (!XMLIntrospector.this.getConfiguration().getPropertySuppressionStrategy().suppressProperty(this.beanClass, descriptors[i].getPropertyType(), descriptors[i].getName())) {
                            propertyDescriptors.add(descriptors[i]);
                        }
                        ++i;
                    }
                }
                if ((additionals = this.beanInfo.getAdditionalBeanInfo()) != null) {
                    int i = 0;
                    int outerSize = additionals.length;
                    while (i < outerSize) {
                        BeanInfo additionalInfo = additionals[i];
                        descriptors = this.beanInfo.getPropertyDescriptors();
                        if (descriptors != null) {
                            int j = 0;
                            int innerSize = descriptors.length;
                            while (j < innerSize) {
                                if (!XMLIntrospector.this.getConfiguration().getPropertySuppressionStrategy().suppressProperty(this.beanClass, descriptors[j].getPropertyType(), descriptors[j].getName())) {
                                    propertyDescriptors.add(descriptors[j]);
                                }
                                ++j;
                            }
                        }
                        ++i;
                    }
                }
                this.addAllSuperinterfaces(this.beanClass, propertyDescriptors);
                this.properties = new BeanProperty[propertyDescriptors.size()];
                int count = 0;
                Iterator it = ((AbstractList)propertyDescriptors).iterator();
                while (it.hasNext()) {
                    PropertyDescriptor propertyDescriptor = (PropertyDescriptor)it.next();
                    this.properties[count] = new BeanProperty(propertyDescriptor);
                    ++count;
                }
            }
            return this.properties;
        }

        private void addAllSuperinterfaces(Class clazz, ArrayList propertyDescriptors) {
            if (clazz.isInterface()) {
                Class<?>[] superinterfaces = clazz.getInterfaces();
                int i = 0;
                int size = superinterfaces.length;
                while (i < size) {
                    try {
                        BeanInfo beanInfo = Introspector.getBeanInfo(superinterfaces[i]);
                        PropertyDescriptor[] descriptors = beanInfo.getPropertyDescriptors();
                        int j = 0;
                        int descriptorLength = descriptors.length;
                        while (j < descriptorLength) {
                            if (!XMLIntrospector.this.getConfiguration().getPropertySuppressionStrategy().suppressProperty(this.beanClass, descriptors[j].getPropertyType(), descriptors[j].getName())) {
                                propertyDescriptors.add(descriptors[j]);
                            }
                            ++j;
                        }
                        this.addAllSuperinterfaces(superinterfaces[i], propertyDescriptors);
                    }
                    catch (IntrospectionException ex) {
                        XMLIntrospector.this.log.info((Object)"Introspection on superinterface failed.", (Throwable)ex);
                    }
                    ++i;
                }
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private abstract class BeanType {
        private BeanType() {
        }

        public abstract String getBeanName();

        public abstract Class getElementType();

        public abstract boolean isPrimitiveType();

        public abstract boolean isMapType();

        public abstract boolean isLoopType();

        public abstract BeanProperty[] getProperties();

        public String toString() {
            return "Bean[name=" + this.getBeanName() + ", type=" + this.getElementType();
        }
    }
}

