/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.torque.turbine;

import java.sql.Connection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.fulcrum.security.entity.User;
import org.apache.fulcrum.security.model.turbine.entity.TurbineUserGroupRole;
import org.apache.fulcrum.security.torque.om.TurbineUserGroupRolePeer;
import org.apache.fulcrum.security.torque.om.TurbineUserPeer;
import org.apache.fulcrum.security.torque.peer.TurbineUserGroupRoleModelPeerMapper;
import org.apache.fulcrum.security.torque.security.turbine.TorqueAbstractTurbineTurbineSecurityEntityDefault;
import org.apache.fulcrum.security.util.DataBackendException;
import org.apache.torque.TorqueException;
import org.apache.torque.criteria.Criteria;
import org.apache.torque.om.SimpleKey;

public abstract class DefaultAbstractTurbineUser
extends TorqueAbstractTurbineTurbineSecurityEntityDefault {
    private static final long serialVersionUID = -7255623655281852566L;

    protected <T extends TurbineUserGroupRoleModelPeerMapper> List<T> getTurbineUserGroupRolesJoinTurbineGroup(Criteria criteria, Connection con) throws TorqueException, DataBackendException {
        criteria.and((Object)TurbineUserGroupRolePeer.USER_ID, (Object)this.getEntityId());
        try {
            return TurbineUserGroupRolePeer.doSelectJoinTurbineGroup(criteria, con);
        }
        catch (TorqueException e) {
            throw new DataBackendException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public <T extends TurbineUserGroupRoleModelPeerMapper> void retrieveAttachedObjects(Connection con, Boolean lazy, List<T> ugrs) throws DataBackendException, TorqueException {
        if (!lazy.booleanValue()) {
            HashSet<TurbineUserGroupRole> userGroupRoleSet = new HashSet<TurbineUserGroupRole>();
            if (ugrs == null) {
                ugrs = this.getTurbineUserGroupRolesJoinTurbineGroup(new Criteria(), con);
            }
            this.maptoModel(con, userGroupRoleSet, ugrs);
            this.setUserGroupRoleSet(userGroupRoleSet);
        }
    }

    @Override
    public void retrieveAttachedObjects(Connection con, Boolean lazy) throws TorqueException, DataBackendException {
        if (!lazy.booleanValue()) {
            HashSet<TurbineUserGroupRole> userGroupRoleSet = new HashSet<TurbineUserGroupRole>();
            List ugrs = this.getTurbineUserGroupRolesJoinTurbineGroup(new Criteria(), con);
            this.maptoModel(con, userGroupRoleSet, ugrs);
            this.setUserGroupRoleSet(userGroupRoleSet);
        }
    }

    @Override
    public void retrieveAttachedObjects(Connection con) throws DataBackendException, TorqueException {
        this.retrieveAttachedObjects(con, false);
    }

    @Override
    public void update(Connection con) throws TorqueException {
        try {
            Set userGroupRoleSet = this.getUserGroupRoleSet();
            if (userGroupRoleSet != null) {
                Criteria criteria = new Criteria();
                criteria.where((Object)TurbineUserGroupRolePeer.USER_ID, (Object)this.getEntityId());
                TurbineUserGroupRolePeer.doDelete(criteria, con);
                for (TurbineUserGroupRole ugr : userGroupRoleSet) {
                    org.apache.fulcrum.security.torque.om.TurbineUserGroupRole ttugr = new org.apache.fulcrum.security.torque.om.TurbineUserGroupRole();
                    ttugr.setGroupId((Integer)ugr.getGroup().getId());
                    ttugr.setUserId((Integer)ugr.getUser().getId());
                    ttugr.setRoleId((Integer)ugr.getRole().getId());
                    ttugr.save(con);
                }
            }
            this.save(con);
        }
        catch (Exception e) {
            throw new TorqueException((Throwable)e);
        }
    }

    @Override
    public void delete() throws TorqueException {
        TurbineUserPeer.doDelete(SimpleKey.keyFor((Number)this.getEntityId()));
    }

    private <T extends TurbineUserGroupRoleModelPeerMapper> void maptoModel(Connection con, Set<TurbineUserGroupRole> userGroupRoleSet, List<T> ugrs) throws DataBackendException {
        try {
            for (TurbineUserGroupRoleModelPeerMapper ttugr : ugrs) {
                TurbineUserGroupRole ugr = new TurbineUserGroupRole();
                ugr.setUser((User)this);
                ugr.setRole(ttugr.getTurbineRole(con));
                ugr.setGroup(ttugr.getTurbineGroup(con));
                userGroupRoleSet.add(ugr);
            }
        }
        catch (TorqueException e) {
            throw new DataBackendException(e.getMessage(), (Throwable)e);
        }
    }
}

