/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.memory.dynamic;

import org.apache.fulcrum.security.entity.Group;
import org.apache.fulcrum.security.entity.Permission;
import org.apache.fulcrum.security.entity.Role;
import org.apache.fulcrum.security.entity.User;
import org.apache.fulcrum.security.model.dynamic.AbstractDynamicModelManager;
import org.apache.fulcrum.security.model.dynamic.DynamicModelManager;
import org.apache.fulcrum.security.model.dynamic.entity.DynamicGroup;
import org.apache.fulcrum.security.model.dynamic.entity.DynamicPermission;
import org.apache.fulcrum.security.model.dynamic.entity.DynamicRole;
import org.apache.fulcrum.security.model.dynamic.entity.DynamicUser;
import org.apache.fulcrum.security.util.DataBackendException;
import org.apache.fulcrum.security.util.UnknownEntityException;

public class MemoryModelManagerImpl
extends AbstractDynamicModelManager
implements DynamicModelManager {
    public void grant(User user, Group group) throws DataBackendException, UnknownEntityException {
        boolean groupExists = false;
        boolean userExists = false;
        try {
            groupExists = this.getGroupManager().checkExists(group);
            userExists = this.getUserManager().checkExists(user);
            if (groupExists && userExists) {
                ((DynamicUser)user).addGroup(group);
                ((DynamicGroup)group).addUser(user);
                return;
            }
        }
        catch (Exception e) {
            throw new DataBackendException("grant(Role,Permission) failed", (Throwable)e);
        }
        if (!groupExists) {
            throw new UnknownEntityException("Unknown group '" + group.getName() + "'");
        }
        if (!userExists) {
            throw new UnknownEntityException("Unknown user '" + user.getName() + "'");
        }
    }

    public void revoke(User user, Group group) throws DataBackendException, UnknownEntityException {
        boolean groupExists = false;
        boolean userExists = false;
        try {
            groupExists = this.getGroupManager().checkExists(group);
            userExists = this.getUserManager().checkExists(user);
            if (groupExists && userExists) {
                ((DynamicUser)user).removeGroup(group);
                ((DynamicGroup)group).removeUser(user);
                return;
            }
        }
        catch (Exception e) {
            throw new DataBackendException("grant(Role,Permission) failed", (Throwable)e);
        }
        if (!groupExists) {
            throw new UnknownEntityException("Unknown group '" + group.getName() + "'");
        }
        if (!userExists) {
            throw new UnknownEntityException("Unknown user '" + user.getName() + "'");
        }
    }

    public synchronized void grant(Group group, Role role) throws DataBackendException, UnknownEntityException {
        boolean groupExists = false;
        boolean roleExists = false;
        try {
            groupExists = this.getGroupManager().checkExists(group);
            roleExists = this.getRoleManager().checkExists(role);
            if (groupExists && roleExists) {
                ((DynamicGroup)group).addRole(role);
                ((DynamicRole)role).addGroup(group);
                return;
            }
        }
        catch (Exception e) {
            throw new DataBackendException("grant(Group,Role) failed", (Throwable)e);
        }
        if (!groupExists) {
            throw new UnknownEntityException("Unknown group '" + group.getName() + "'");
        }
        if (!roleExists) {
            throw new UnknownEntityException("Unknown role '" + role.getName() + "'");
        }
    }

    public synchronized void revoke(Group group, Role role) throws DataBackendException, UnknownEntityException {
        boolean groupExists = false;
        boolean roleExists = false;
        try {
            groupExists = this.getGroupManager().checkExists(group);
            roleExists = this.getRoleManager().checkExists(role);
            if (groupExists && roleExists) {
                ((DynamicGroup)group).removeRole(role);
                ((DynamicRole)role).removeGroup(group);
                return;
            }
        }
        catch (Exception e) {
            throw new DataBackendException("revoke(Group,Role) failed", (Throwable)e);
        }
        if (!groupExists) {
            throw new UnknownEntityException("Unknown group '" + group.getName() + "'");
        }
        if (!roleExists) {
            throw new UnknownEntityException("Unknown role '" + role.getName() + "'");
        }
    }

    public synchronized void grant(Role role, Permission permission) throws DataBackendException, UnknownEntityException {
        boolean roleExists = false;
        boolean permissionExists = false;
        try {
            roleExists = this.getRoleManager().checkExists(role);
            permissionExists = this.getPermissionManager().checkExists(permission);
            if (roleExists && permissionExists) {
                ((DynamicRole)role).addPermission(permission);
                ((DynamicPermission)permission).addRole(role);
                return;
            }
        }
        catch (Exception e) {
            throw new DataBackendException("grant(Role,Permission) failed", (Throwable)e);
        }
        if (!roleExists) {
            throw new UnknownEntityException("Unknown role '" + role.getName() + "'");
        }
        if (!permissionExists) {
            throw new UnknownEntityException("Unknown permission '" + permission.getName() + "'");
        }
    }

    public synchronized void revoke(Role role, Permission permission) throws DataBackendException, UnknownEntityException {
        boolean roleExists = false;
        boolean permissionExists = false;
        try {
            roleExists = this.getRoleManager().checkExists(role);
            permissionExists = this.getPermissionManager().checkExists(permission);
            if (roleExists && permissionExists) {
                ((DynamicRole)role).removePermission(permission);
                ((DynamicPermission)permission).removeRole(role);
                return;
            }
        }
        catch (Exception e) {
            throw new DataBackendException("revoke(Role,Permission) failed", (Throwable)e);
        }
        if (!roleExists) {
            throw new UnknownEntityException("Unknown role '" + role.getName() + "'");
        }
        if (!permissionExists) {
            throw new UnknownEntityException("Unknown permission '" + permission.getName() + "'");
        }
    }
}

