/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.util;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.apache.fulcrum.security.entity.SecurityEntity;
import org.apache.fulcrum.security.model.dynamic.entity.impl.DynamicRoleImpl;
import org.apache.fulcrum.security.util.RoleSet;

public class RoleSetTest
extends TestCase {
    public RoleSetTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run(RoleSetTest.class);
    }

    public void testNullRole() throws Exception {
        RoleSet roleSet = new RoleSet();
        RoleSetTest.assertFalse((boolean)roleSet.contains(null));
    }

    public void testAddRoles() throws Exception {
        DynamicRoleImpl role = new DynamicRoleImpl();
        role.setId((Object)new Integer(1));
        role.setName("Eric");
        RoleSet roleSet = new RoleSet();
        RoleSetTest.assertTrue((boolean)roleSet.add((SecurityEntity)role));
        RoleSetTest.assertTrue((boolean)roleSet.contains((Object)role));
        DynamicRoleImpl role2 = new DynamicRoleImpl();
        role2.setName("Kate");
        role2.setId((Object)new Integer(2));
        roleSet.add((SecurityEntity)role2);
        DynamicRoleImpl role3 = new DynamicRoleImpl();
        role3.setId((Object)new Integer(1));
        role3.setName("Eric");
        roleSet.add((SecurityEntity)role3);
        RoleSetTest.assertTrue((boolean)roleSet.contains((Object)role));
        RoleSetTest.assertTrue((boolean)roleSet.contains((Object)role2));
        RoleSetTest.assertTrue((boolean)roleSet.contains((Object)role3));
    }

    public void testRoleSetWithSubclass() throws Exception {
        RoleSet roleSet = new RoleSet();
        RoleSubClass role = new RoleSubClass();
        role.setId(new Integer(1));
        role.setName("Eric");
        roleSet.add((SecurityEntity)role);
        RoleSetTest.assertTrue((boolean)roleSet.contains((Object)role));
        DynamicRoleImpl role2 = new DynamicRoleImpl();
        role2.setId((Object)new Integer(1));
        role2.setName("Eric");
        RoleSetTest.assertTrue((boolean)roleSet.contains((Object)role2));
    }

    class RoleSubClass
    extends DynamicRoleImpl {
        private String extraRoleData;

        RoleSubClass() {
        }

        public String getExtraRoleData() {
            return this.extraRoleData;
        }

        public void setExtraRoleData(String extraRoleData) {
            this.extraRoleData = extraRoleData;
        }
    }
}

