/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.model.test;

import org.apache.fulcrum.security.RoleManager;
import org.apache.fulcrum.security.SecurityService;
import org.apache.fulcrum.security.entity.Role;
import org.apache.fulcrum.security.util.EntityExistsException;
import org.apache.fulcrum.security.util.RoleSet;
import org.apache.fulcrum.security.util.UnknownEntityException;
import org.apache.fulcrum.testcontainer.BaseUnit5Test;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractRoleManagerTest
extends BaseUnit5Test {
    protected Role role;
    protected RoleManager roleManager;
    protected SecurityService securityService;

    @Test
    public void testGetRoleInstance() throws Exception {
        this.role = this.roleManager.getRoleInstance();
        Assertions.assertNotNull((Object)this.role);
        Assertions.assertTrue((this.role.getName() == null ? 1 : 0) != 0);
    }

    @Test
    public void testGetRoleInstanceString() throws Exception {
        this.role = this.roleManager.getRoleInstance("DOG_CATCHER");
        Assertions.assertEquals((Object)"dog_catcher", (Object)this.role.getName());
    }

    @Test
    public void testGetRoleByName() throws Exception {
        this.role = this.roleManager.getRoleInstance("DOG_CATCHERd");
        this.roleManager.addRole(this.role);
        Role role2 = this.roleManager.getRoleByName("DOG_CATCHERd");
        Assertions.assertEquals((Object)this.role.getName(), (Object)role2.getName());
    }

    @Test
    public void testGetRoleById() throws Exception {
        this.role = this.roleManager.getRoleInstance("CLEAN_KENNEL_A");
        this.roleManager.addRole(this.role);
        Role role2 = this.roleManager.getRoleById(this.role.getId());
        Assertions.assertEquals((Object)this.role.getName(), (Object)role2.getName());
    }

    @Test
    public void testRenameRole() throws Exception {
        this.role = this.roleManager.getRoleInstance("CLEAN_KENNEL_X");
        this.roleManager.addRole(this.role);
        int size = this.roleManager.getAllRoles().size();
        this.roleManager.renameRole(this.role, "CLEAN_GROOMING_ROOM");
        Role role2 = this.roleManager.getRoleById(this.role.getId());
        Assertions.assertEquals((Object)"clean_grooming_room", (Object)role2.getName());
        Assertions.assertEquals((int)size, (int)this.roleManager.getAllRoles().size());
    }

    @Test
    public void testGetAllRoles() throws Exception {
        int size = this.roleManager.getAllRoles().size();
        this.role = this.roleManager.getRoleInstance("CLEAN_KENNEL_J");
        this.roleManager.addRole(this.role);
        RoleSet roleSet = this.roleManager.getAllRoles();
        Assertions.assertEquals((int)(size + 1), (int)roleSet.size());
    }

    @Test
    public void testAddRole() throws Exception {
        this.role = this.roleManager.getRoleInstance("DOG_NAPPER");
        Assertions.assertNull((Object)this.role.getId());
        this.roleManager.addRole(this.role);
        Assertions.assertNotNull((Object)this.role.getId());
        Assertions.assertNotNull((Object)this.roleManager.getRoleById(this.role.getId()));
    }

    @Test
    public void testRemoveRole() throws Exception {
        this.role = this.roleManager.getRoleInstance("CLEAN_KENNEL_K");
        this.roleManager.addRole(this.role);
        int size = this.roleManager.getAllRoles().size();
        this.roleManager.removeRole(this.role);
        try {
            Role role2 = this.roleManager.getRoleById(this.role.getId());
            Assertions.fail((String)"Should have thrown UEE");
        }
        catch (UnknownEntityException unknownEntityException) {
            // empty catch block
        }
        Assertions.assertEquals((int)(size - 1), (int)this.roleManager.getAllRoles().size());
    }

    @Test
    public void testCheckExists() throws Exception {
        this.role = this.roleManager.getRoleInstance("GREET_PEOPLE");
        this.roleManager.addRole(this.role);
        Assertions.assertTrue((boolean)this.roleManager.checkExists(this.role));
        Role role2 = this.roleManager.getRoleInstance("WALK_DOGS");
        Assertions.assertFalse((boolean)this.roleManager.checkExists(role2));
    }

    @Test
    public void testCheckExistsWithString() throws Exception {
        this.role = this.roleManager.getRoleInstance("GREET_PEOPLE2");
        this.roleManager.addRole(this.role);
        Assertions.assertTrue((boolean)this.roleManager.checkExists(this.role.getName()));
        Role role2 = this.roleManager.getRoleInstance("WALK_DOGS2");
        Assertions.assertFalse((boolean)this.roleManager.checkExists(role2.getName()));
    }

    @Test
    public void testAddRoleTwiceFails() throws Exception {
        this.role = this.roleManager.getRoleInstance("EATLUNCH");
        this.roleManager.addRole(this.role);
        Assertions.assertTrue((boolean)this.roleManager.checkExists(this.role.getName()));
        Role role2 = this.roleManager.getRoleInstance("EATLUNCH");
        try {
            this.roleManager.addRole(role2);
        }
        catch (EntityExistsException entityExistsException) {
            // empty catch block
        }
    }
}

