/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.mail.james.mime4j.stream;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayDeque;
import org.apache.geronimo.mail.james.mime4j.Charsets;
import org.apache.geronimo.mail.james.mime4j.MimeException;
import org.apache.geronimo.mail.james.mime4j.codec.DecodeMonitor;
import org.apache.geronimo.mail.james.mime4j.io.LineNumberInputStream;
import org.apache.geronimo.mail.james.mime4j.stream.BodyDescriptor;
import org.apache.geronimo.mail.james.mime4j.stream.BodyDescriptorBuilder;
import org.apache.geronimo.mail.james.mime4j.stream.DefaultFieldBuilder;
import org.apache.geronimo.mail.james.mime4j.stream.EntityState;
import org.apache.geronimo.mail.james.mime4j.stream.EntityStateMachine;
import org.apache.geronimo.mail.james.mime4j.stream.FallbackBodyDescriptorBuilder;
import org.apache.geronimo.mail.james.mime4j.stream.Field;
import org.apache.geronimo.mail.james.mime4j.stream.FieldBuilder;
import org.apache.geronimo.mail.james.mime4j.stream.MimeConfig;
import org.apache.geronimo.mail.james.mime4j.stream.MimeEntity;
import org.apache.geronimo.mail.james.mime4j.stream.RawField;
import org.apache.geronimo.mail.james.mime4j.stream.RecursionMode;
import org.apache.geronimo.mail.james.mime4j.util.CharsetUtil;

public class MimeTokenStream {
    private final MimeConfig config;
    private final DecodeMonitor monitor;
    private final FieldBuilder fieldBuilder;
    private final BodyDescriptorBuilder bodyDescBuilder;
    private final ArrayDeque<EntityStateMachine> entities = new ArrayDeque();
    private EntityState state = EntityState.T_END_OF_STREAM;
    private EntityStateMachine currentStateMachine;
    private RecursionMode recursionMode = RecursionMode.M_RECURSE;
    private MimeEntity rootentity;

    public MimeTokenStream() {
        this(null);
    }

    public MimeTokenStream(MimeConfig config) {
        this(config, null, null, null);
    }

    public MimeTokenStream(MimeConfig config, BodyDescriptorBuilder bodyDescBuilder) {
        this(config, null, null, bodyDescBuilder);
    }

    public MimeTokenStream(MimeConfig config, DecodeMonitor monitor, BodyDescriptorBuilder bodyDescBuilder) {
        this(config, monitor, null, bodyDescBuilder);
    }

    public MimeTokenStream(MimeConfig config, DecodeMonitor monitor, FieldBuilder fieldBuilder, BodyDescriptorBuilder bodyDescBuilder) {
        this.config = config != null ? config : MimeConfig.DEFAULT;
        FieldBuilder fieldBuilder2 = this.fieldBuilder = fieldBuilder != null ? fieldBuilder : new DefaultFieldBuilder(this.config.getMaxHeaderLen());
        this.monitor = monitor != null ? monitor : (this.config.isStrictParsing() ? DecodeMonitor.STRICT : DecodeMonitor.SILENT);
        this.bodyDescBuilder = bodyDescBuilder != null ? bodyDescBuilder : new FallbackBodyDescriptorBuilder();
    }

    public void parse(InputStream stream) {
        this.doParse(stream, EntityState.T_START_MESSAGE);
    }

    public Field parseHeadless(InputStream stream, String contentType) {
        Field newContentType;
        if (contentType == null) {
            throw new IllegalArgumentException("Content type may not be null");
        }
        try {
            RawField rawContentType = new RawField("Content-Type", contentType);
            newContentType = this.bodyDescBuilder.addField(rawContentType);
            if (newContentType == null) {
                newContentType = rawContentType;
            }
        }
        catch (MimeException ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
        this.doParse(stream, EntityState.T_END_HEADER);
        try {
            this.next();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        catch (MimeException e) {
            throw new IllegalStateException(e);
        }
        return newContentType;
    }

    private void doParse(InputStream stream, EntityState start) {
        if (this.config.isCountLineNumbers()) {
            LineNumberInputStream lnstream = new LineNumberInputStream(stream);
            this.rootentity = new MimeEntity(lnstream, lnstream, this.config, start, EntityState.T_END_MESSAGE, this.monitor, this.fieldBuilder, this.bodyDescBuilder);
        } else {
            this.rootentity = new MimeEntity(null, stream, this.config, start, EntityState.T_END_MESSAGE, this.monitor, this.fieldBuilder, this.bodyDescBuilder);
        }
        this.rootentity.setRecursionMode(this.recursionMode);
        this.currentStateMachine = this.rootentity;
        this.entities.clear();
        this.entities.add(this.currentStateMachine);
        this.state = this.currentStateMachine.getState();
    }

    public boolean isRaw() {
        return this.recursionMode == RecursionMode.M_RAW;
    }

    public RecursionMode getRecursionMode() {
        return this.recursionMode;
    }

    public void setRecursionMode(RecursionMode mode) {
        this.recursionMode = mode;
        if (this.currentStateMachine != null) {
            this.currentStateMachine.setRecursionMode(mode);
        }
    }

    public void stop() {
        this.rootentity.stopSoft();
        this.fieldBuilder.release();
    }

    public EntityState getState() {
        return this.state;
    }

    public InputStream getInputStream() {
        return this.currentStateMachine.getContentStream();
    }

    public InputStream getDecodedInputStream() {
        return this.currentStateMachine.getDecodedContentStream();
    }

    public Reader getReader() throws UnsupportedEncodingException {
        Charset charset;
        BodyDescriptor bodyDescriptor = this.getBodyDescriptor();
        String mimeCharset = bodyDescriptor.getCharset();
        if (mimeCharset == null || "".equals(mimeCharset)) {
            charset = Charsets.US_ASCII;
        } else {
            charset = CharsetUtil.lookup(mimeCharset);
            if (charset == null) {
                throw new UnsupportedEncodingException(mimeCharset);
            }
        }
        InputStream instream = this.getDecodedInputStream();
        return new InputStreamReader(instream, charset);
    }

    public BodyDescriptor getBodyDescriptor() {
        return this.currentStateMachine.getBodyDescriptor();
    }

    public Field getField() {
        return this.currentStateMachine.getField();
    }

    public EntityState next() throws IOException, MimeException {
        if (this.state == EntityState.T_END_OF_STREAM || this.currentStateMachine == null) {
            throw new IllegalStateException("No more tokens are available.");
        }
        while (this.currentStateMachine != null) {
            EntityStateMachine next = this.currentStateMachine.advance();
            if (next != null) {
                this.entities.add(next);
                this.currentStateMachine = next;
            }
            this.state = this.currentStateMachine.getState();
            if (this.state != EntityState.T_END_OF_STREAM) {
                return this.state;
            }
            EntityStateMachine entityStateMachine = this.entities.removeLast();
            if (entityStateMachine instanceof MimeEntity) {
                ((MimeEntity)entityStateMachine).stop();
            }
            if (this.entities.isEmpty()) {
                this.currentStateMachine = null;
                continue;
            }
            this.currentStateMachine = this.entities.getLast();
            this.currentStateMachine.setRecursionMode(this.recursionMode);
        }
        this.state = EntityState.T_END_OF_STREAM;
        return this.state;
    }

    public static String stateToString(EntityState state) {
        return MimeEntity.stateToString(state);
    }

    public MimeConfig getConfig() {
        return this.config;
    }
}

