/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.binary;

import java.util.HashMap;
import java.util.Map;

public enum DataType {
    INT(1),
    LONG(2),
    STRING(3),
    DATETIME(4),
    DOUBLE(7),
    FLOAT(8),
    LIST(9),
    MAP(10),
    SET(11),
    UUID(12),
    EDGE(13),
    PATH(14),
    PROPERTY(15),
    GRAPH(16),
    VERTEX(17),
    VERTEXPROPERTY(18),
    DIRECTION(24),
    T(32),
    MERGE(46),
    TRAVERSER(33),
    BIGDECIMAL(34),
    BIGINTEGER(35),
    BYTE(36),
    BYTEBUFFER(37),
    SHORT(38),
    BOOLEAN(39),
    BULKSET(42),
    TREE(43),
    CHAR(128),
    DURATION(129),
    CUSTOM(0),
    MARKER(253),
    UNSPECIFIED_NULL(254);

    private final int code;
    private static final Map<Integer, DataType> typeByCode;
    private static final Map<DataType, byte[]> bufferByDataType;

    private DataType(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public byte getCodeByte() {
        return (byte)this.code;
    }

    byte[] getDataTypeBuffer() {
        return bufferByDataType.get((Object)this);
    }

    public static DataType get(int code) {
        return typeByCode.get(code);
    }

    static {
        typeByCode = new HashMap<Integer, DataType>();
        bufferByDataType = new HashMap<DataType, byte[]>();
        for (DataType t : DataType.values()) {
            typeByCode.put(t.code, t);
            bufferByDataType.put(t, new byte[]{(byte)t.code});
        }
    }
}

