/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.util.event;

import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.AddPropertyStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.event.CallbackRegistry;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.event.Event;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.event.EventCallback;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.EventStrategy;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;

public final class EventUtil {
    private EventUtil() {
    }

    public static void registerVertexPropertyChange(CallbackRegistry<Event> callbackRegistry, Traversal.Admin<Object, Object> traversal, Vertex vertex, String key, Object value) {
        if (EventUtil.hasAnyCallbacks(callbackRegistry)) {
            EventStrategy eventStrategy = EventUtil.forceGetEventStrategy(traversal);
            Property p = vertex.property(key);
            Property oldValue = p.isPresent() ? eventStrategy.detach(vertex.property(key)) : null;
            Event.VertexPropertyChangedEvent vpce = new Event.VertexPropertyChangedEvent(eventStrategy.detach(vertex), oldValue, value, new Object[0]);
            callbackRegistry.getCallbacks().forEach(c -> c.accept(vpce));
        }
    }

    public static void registerEdgePropertyChange(CallbackRegistry<Event> callbackRegistry, Traversal.Admin<Object, Object> traversal, Edge edge, String key, Object value) {
        if (EventUtil.hasAnyCallbacks(callbackRegistry)) {
            EventStrategy eventStrategy = EventUtil.forceGetEventStrategy(traversal);
            Property p = edge.property(key);
            Property oldValue = p.isPresent() ? eventStrategy.detach(edge.property(key)) : null;
            Event.EdgePropertyChangedEvent vpce = new Event.EdgePropertyChangedEvent(eventStrategy.detach(edge), oldValue, value);
            callbackRegistry.getCallbacks().forEach(c -> c.accept(vpce));
        }
    }

    public static void registerEdgeCreation(CallbackRegistry<Event.EdgeAddedEvent> callbackRegistry, Traversal.Admin<Object, Object> traversal, Edge addedEdge) {
        if (EventUtil.hasAnyCallbacks(callbackRegistry)) {
            Event.EdgeAddedEvent vae = EventUtil.createEdgeAddedEvent(traversal, addedEdge);
            callbackRegistry.getCallbacks().forEach(c -> c.accept(vae));
        }
    }

    public static void registerEdgeCreationWithGenericEventRegistry(CallbackRegistry<Event> callbackRegistry, Traversal.Admin<Object, Object> traversal, Edge addedEdge) {
        if (EventUtil.hasAnyCallbacks(callbackRegistry)) {
            Event.EdgeAddedEvent vae = EventUtil.createEdgeAddedEvent(traversal, addedEdge);
            callbackRegistry.getCallbacks().forEach(c -> c.accept(vae));
        }
    }

    private static Event.EdgeAddedEvent createEdgeAddedEvent(Traversal.Admin<Object, Object> traversal, Edge addedEdge) {
        EventStrategy eventStrategy = EventUtil.forceGetEventStrategy(traversal);
        return new Event.EdgeAddedEvent(eventStrategy.detach(addedEdge));
    }

    public static void registerVertexCreation(CallbackRegistry<Event.VertexAddedEvent> callbackRegistry, Traversal.Admin<Object, Object> traversal, Vertex addedVertex) {
        if (EventUtil.hasAnyCallbacks(callbackRegistry)) {
            Event.VertexAddedEvent vae = EventUtil.createVertexAddedEvent(traversal, addedVertex);
            callbackRegistry.getCallbacks().forEach(c -> c.accept(vae));
        }
    }

    public static void registerVertexCreationWithGenericEventRegistry(CallbackRegistry<Event> callbackRegistry, Traversal.Admin<Object, Object> traversal, Vertex addedVertex) {
        if (EventUtil.hasAnyCallbacks(callbackRegistry)) {
            Event.VertexAddedEvent vae = EventUtil.createVertexAddedEvent(traversal, addedVertex);
            callbackRegistry.getCallbacks().forEach(c -> c.accept(vae));
        }
    }

    private static Event.VertexAddedEvent createVertexAddedEvent(Traversal.Admin<Object, Object> traversal, Vertex addedVertex) {
        EventStrategy eventStrategy = EventUtil.forceGetEventStrategy(traversal);
        return new Event.VertexAddedEvent(eventStrategy.detach(addedVertex));
    }

    public static void registerElementRemoval(CallbackRegistry<Event> callbackRegistry, Traversal.Admin<Object, Object> traversal, Element elementForRemoval) {
        if (EventUtil.hasAnyCallbacks(callbackRegistry)) {
            Event removeEvent;
            EventStrategy eventStrategy = EventUtil.forceGetEventStrategy(traversal);
            if (elementForRemoval instanceof Vertex) {
                removeEvent = new Event.VertexRemovedEvent(eventStrategy.detach((Vertex)elementForRemoval));
            } else if (elementForRemoval instanceof Edge) {
                removeEvent = new Event.EdgeRemovedEvent(eventStrategy.detach((Edge)elementForRemoval));
            } else if (elementForRemoval instanceof VertexProperty) {
                removeEvent = new Event.VertexPropertyRemovedEvent(eventStrategy.detach((VertexProperty)elementForRemoval));
            } else {
                throw new IllegalStateException("The incoming object is not removable: " + elementForRemoval);
            }
            callbackRegistry.getCallbacks().forEach(c -> c.accept(removeEvent));
        }
    }

    public static void registerPropertyRemoval(CallbackRegistry<Event> callbackRegistry, Traversal.Admin<Object, Object> traversal, Property elementForRemoval) {
        if (EventUtil.hasAnyCallbacks(callbackRegistry)) {
            Event.ElementPropertyEvent removeEvent;
            EventStrategy eventStrategy = EventUtil.forceGetEventStrategy(traversal);
            if (elementForRemoval.element() instanceof Edge) {
                removeEvent = new Event.EdgePropertyRemovedEvent(eventStrategy.detach((Edge)elementForRemoval.element()), eventStrategy.detach(elementForRemoval));
            } else if (elementForRemoval.element() instanceof VertexProperty) {
                removeEvent = new Event.VertexPropertyPropertyRemovedEvent(eventStrategy.detach((VertexProperty)elementForRemoval.element()), eventStrategy.detach(elementForRemoval));
            } else {
                throw new IllegalStateException("The incoming object is not removable: " + elementForRemoval);
            }
            callbackRegistry.getCallbacks().forEach(c -> c.accept(removeEvent));
        }
    }

    public static void registerPropertyChange(CallbackRegistry<Event.ElementPropertyChangedEvent> callbackRegistry, EventStrategy es, Element affectedElement, Property removedProperty, Object value, Object[] vertexPropertyKeyValues) {
        Event.ElementPropertyChangedEvent event;
        if (affectedElement instanceof Vertex) {
            event = new Event.VertexPropertyChangedEvent(es.detach((Vertex)affectedElement), removedProperty, value, vertexPropertyKeyValues);
        } else if (affectedElement instanceof Edge) {
            event = new Event.EdgePropertyChangedEvent(es.detach((Edge)affectedElement), removedProperty, value);
        } else if (affectedElement instanceof VertexProperty) {
            event = new Event.VertexPropertyPropertyChangedEvent(es.detach((VertexProperty)affectedElement), removedProperty, value);
        } else {
            throw new IllegalStateException(String.format("The incoming object cannot be processed by change eventing in %s:  %s", AddPropertyStep.class.getName(), affectedElement));
        }
        for (EventCallback<Event.ElementPropertyChangedEvent> c : callbackRegistry.getCallbacks()) {
            c.accept(event);
        }
    }

    public static boolean hasAnyCallbacks(CallbackRegistry<? extends Event> callbackRegistry) {
        return callbackRegistry != null && !callbackRegistry.getCallbacks().isEmpty();
    }

    public static EventStrategy forceGetEventStrategy(Traversal.Admin<Object, Object> traversal) {
        return traversal.getStrategies().getStrategy(EventStrategy.class).get();
    }
}

