/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration;

import java.util.Arrays;
import java.util.HashMap;
import java.util.UUID;
import java.util.function.Supplier;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.MapConfiguration;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.step.HasContainerHolder;
import org.apache.tinkerpop.gremlin.process.traversal.step.Parameterizing;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.HasStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.AddEdgeStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.AddVertexStartStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.AddVertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.GraphStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.IdStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.PropertiesStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.HasContainer;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.AbstractTraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.PropertyType;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public final class ElementIdStrategy
extends AbstractTraversalStrategy<TraversalStrategy.DecorationStrategy>
implements TraversalStrategy.DecorationStrategy {
    public static final ElementIdStrategy INSTANCE = ElementIdStrategy.build().create();
    private final String idPropertyKey;
    private final Supplier<Object> idMaker;
    public static final String ID_PROPERTY_KEY = "idPropertyKey";
    public static final String ID_MAKER = "idMaker";

    private ElementIdStrategy(String idPropertyKey, Supplier<Object> idMaker) {
        this.idPropertyKey = idPropertyKey;
        this.idMaker = idMaker;
    }

    public String getIdPropertyKey() {
        return this.idPropertyKey;
    }

    public Supplier<Object> getIdMaker() {
        return this.idMaker;
    }

    @Override
    public void apply(Traversal.Admin<?, ?> traversal) {
        GraphStep graphStep;
        Object[] ids;
        TraversalHelper.getStepsOfAssignableClass(HasStep.class, traversal).stream().forEach(hasStep -> hasStep.getHasContainers().stream().filter(container -> container.getKey().equals(T.id.getAccessor())).forEach(container -> container.setKey(this.idPropertyKey)));
        if (traversal.getStartStep() instanceof GraphStep && (ids = (graphStep = (GraphStep)traversal.getStartStep()).getIdsAsValues()).length > 0 && !(ids[0] instanceof Element)) {
            if (graphStep instanceof HasContainerHolder) {
                ((HasContainerHolder)((Object)graphStep)).addHasContainer(new HasContainer(this.idPropertyKey, P.within(Arrays.asList(ids))));
            } else {
                TraversalHelper.insertAfterStep(new HasStep(traversal, new HasContainer(this.idPropertyKey, P.within(Arrays.asList(ids)))), graphStep, traversal);
            }
            graphStep.clearIds();
        }
        TraversalHelper.getStepsOfAssignableClass(IdStep.class, traversal).stream().forEach(step -> TraversalHelper.replaceStep(step, new PropertiesStep(traversal, PropertyType.VALUE, this.idPropertyKey), traversal));
        traversal.getSteps().forEach(step -> {
            if (step instanceof AddVertexStep || step instanceof AddVertexStartStep || step instanceof AddEdgeStep) {
                Parameterizing parameterizing = (Parameterizing)((Object)step);
                if (parameterizing.getParameters().contains(T.id)) {
                    parameterizing.getParameters().rename(T.id, this.idPropertyKey);
                } else if (!parameterizing.getParameters().contains(this.idPropertyKey)) {
                    parameterizing.getParameters().set(null, this.idPropertyKey, this.idMaker.get());
                }
            }
        });
    }

    public static Builder build() {
        return new Builder();
    }

    @Override
    public String toString() {
        return StringFactory.traversalStrategyString(this);
    }

    public static ElementIdStrategy create(Configuration configuration) {
        Builder builder = ElementIdStrategy.build();
        if (configuration.containsKey(ID_MAKER)) {
            builder.idMaker((Supplier)configuration.getProperty(ID_MAKER));
        }
        if (configuration.containsKey(ID_PROPERTY_KEY)) {
            builder.idPropertyKey(configuration.getString(ID_PROPERTY_KEY));
        }
        return builder.create();
    }

    @Override
    public Configuration getConfiguration() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("strategy", ElementIdStrategy.class.getCanonicalName());
        map.put(ID_PROPERTY_KEY, this.idPropertyKey);
        if (!this.idMaker.equals(Builder.DEFAULT_ID_MAKER)) {
            map.put(ID_MAKER, this.idMaker);
        }
        return new MapConfiguration(map);
    }

    public static ElementIdStrategy instance() {
        return INSTANCE;
    }

    public static final class Builder {
        private static final Supplier<Object> DEFAULT_ID_MAKER = () -> UUID.randomUUID().toString();
        private String idPropertyKey = "__id";
        private Supplier<Object> idMaker = DEFAULT_ID_MAKER;

        private Builder() {
        }

        public Builder idMaker(Supplier<Object> idMaker) {
            this.idMaker = idMaker;
            return this;
        }

        public Builder idPropertyKey(String idPropertyKey) {
            this.idPropertyKey = idPropertyKey;
            return this;
        }

        public ElementIdStrategy create() {
            return new ElementIdStrategy(this.idPropertyKey, this.idMaker);
        }
    }
}

