/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import org.apache.tinkerpop.gremlin.process.traversal.GremlinLang;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.OptionsStrategy;

public final class RequestOptions {
    public static final RequestOptions EMPTY = RequestOptions.build().create();
    private final String graphOrTraversalSource;
    private final Map<String, Object> parameters;
    private final Integer batchSize;
    private final Long timeout;
    private final String language;
    private final String materializeProperties;
    private final String bulkResults;

    private RequestOptions(Builder builder) {
        this.graphOrTraversalSource = builder.graphOrTraversalSource;
        this.parameters = builder.parameters;
        this.batchSize = builder.batchSize;
        this.timeout = builder.timeout;
        this.language = builder.language;
        this.materializeProperties = builder.materializeProperties;
        this.bulkResults = builder.bulkResults;
    }

    public Optional<String> getG() {
        return Optional.ofNullable(this.graphOrTraversalSource);
    }

    public Optional<Map<String, Object>> getParameters() {
        return Optional.ofNullable(this.parameters);
    }

    public Optional<Integer> getBatchSize() {
        return Optional.ofNullable(this.batchSize);
    }

    public Optional<Long> getTimeout() {
        return Optional.ofNullable(this.timeout);
    }

    public Optional<String> getLanguage() {
        return Optional.ofNullable(this.language);
    }

    public Optional<String> getMaterializeProperties() {
        return Optional.ofNullable(this.materializeProperties);
    }

    public Optional<String> getBulkResults() {
        return Optional.ofNullable(this.bulkResults);
    }

    public static Builder build() {
        return new Builder();
    }

    public static RequestOptions getRequestOptions(GremlinLang gremlinLang) {
        Map parameters;
        Iterator itty = gremlinLang.getOptionsStrategies().iterator();
        Builder builder = RequestOptions.build();
        while (itty.hasNext()) {
            OptionsStrategy optionsStrategy = (OptionsStrategy)itty.next();
            Map options = optionsStrategy.getOptions();
            if (options.containsKey("evaluationTimeout")) {
                builder.timeout(((Number)options.get("evaluationTimeout")).longValue());
            }
            if (options.containsKey("batchSize")) {
                builder.batchSize(((Number)options.get("batchSize")).intValue());
            }
            if (options.containsKey("materializeProperties")) {
                builder.materializeProperties((String)options.get("materializeProperties"));
            }
            if (options.containsKey("language")) {
                builder.language((String)options.get("language"));
            }
            if (!options.containsKey("bulkResults")) continue;
            builder.bulkResults((Boolean)options.get("bulkResults"));
        }
        if (builder.bulkResults == null) {
            builder.bulkResults(true);
        }
        if ((parameters = gremlinLang.getParameters()) != null && !parameters.isEmpty()) {
            parameters.forEach(builder::addParameter);
        }
        return builder.create();
    }

    public static final class Builder {
        private String graphOrTraversalSource = null;
        private Map<String, Object> parameters = null;
        private Integer batchSize = null;
        private Long timeout = null;
        private String materializeProperties = null;
        private String language = null;
        private String bulkResults = null;

        public Builder addG(String graphOrTraversalSource) {
            this.graphOrTraversalSource = graphOrTraversalSource;
            return this;
        }

        public Builder addParameter(String name, Object value) {
            if (null == this.parameters) {
                this.parameters = new HashMap<String, Object>();
            }
            if ("g".equals(name)) {
                this.graphOrTraversalSource = (String)value;
            }
            if ("language".equals(name)) {
                this.language = (String)value;
            }
            this.parameters.put(name, value);
            return this;
        }

        public Builder batchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public Builder timeout(long timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder language(String language) {
            this.language = language;
            return this;
        }

        public Builder materializeProperties(String materializeProperties) {
            this.materializeProperties = materializeProperties;
            return this;
        }

        public Builder bulkResults(boolean bulking) {
            this.bulkResults = String.valueOf(bulking);
            return this;
        }

        public RequestOptions create() {
            return new RequestOptions(this);
        }
    }
}

