/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.util.concurrent.Future;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.tinkerpop.gremlin.driver.Client;
import org.apache.tinkerpop.gremlin.driver.Host;
import org.apache.tinkerpop.gremlin.driver.LoadBalancingStrategy;
import org.apache.tinkerpop.gremlin.driver.RequestInterceptor;
import org.apache.tinkerpop.gremlin.driver.Settings;
import org.apache.tinkerpop.gremlin.driver.auth.Auth;
import org.apache.tinkerpop.gremlin.driver.interceptor.PayloadSerializingInterceptor;
import org.apache.tinkerpop.gremlin.util.MessageSerializer;
import org.apache.tinkerpop.gremlin.util.message.RequestMessage;
import org.apache.tinkerpop.gremlin.util.ser.GraphBinaryMessageSerializerV4;
import org.apache.tinkerpop.gremlin.util.ser.Serializers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Cluster {
    public static final String SERIALIZER_INTERCEPTOR_NAME = "serializer";
    private static final Logger logger = LoggerFactory.getLogger(Cluster.class);
    private final Manager manager;

    private Cluster(Builder builder) {
        this.manager = new Manager(builder);
    }

    public synchronized void init() {
        if (!this.manager.initialized) {
            this.manager.init();
        }
    }

    public <T extends Client> T connect(String sessionId) {
        throw new UnsupportedOperationException("not implemented");
    }

    public <T extends Client> T connect(String sessionId, boolean manageTransactions) {
        throw new UnsupportedOperationException("not implemented");
    }

    public <T extends Client> T connect() {
        Client.ClusteredClient client = new Client.ClusteredClient(this);
        this.manager.trackClient(client);
        return (T)client;
    }

    public String toString() {
        return this.manager.toString();
    }

    public static Builder build() {
        return new Builder();
    }

    public static Builder build(String address) {
        return new Builder(address);
    }

    public static Builder build(RequestInterceptor serializingInterceptor) {
        return new Builder(serializingInterceptor);
    }

    public static Builder build(File configurationFile) throws FileNotFoundException {
        Settings settings = Settings.read(new FileInputStream(configurationFile));
        return Cluster.getBuilderFromSettings(settings);
    }

    private static Builder getBuilderFromSettings(Settings settings) {
        List<String> addresses = settings.hosts;
        if (addresses.isEmpty()) {
            throw new IllegalStateException("At least one value must be specified to the hosts setting");
        }
        Builder builder = new Builder(settings.hosts.get(0)).port(settings.port).path(settings.path).enableSsl(settings.connectionPool.enableSsl).keyStore(settings.connectionPool.keyStore).keyStorePassword(settings.connectionPool.keyStorePassword).keyStoreType(settings.connectionPool.keyStoreType).trustStore(settings.connectionPool.trustStore).trustStorePassword(settings.connectionPool.trustStorePassword).trustStoreType(settings.connectionPool.trustStoreType).sslCipherSuites(settings.connectionPool.sslCipherSuites).sslEnabledProtocols(settings.connectionPool.sslEnabledProtocols).sslSkipCertValidation(settings.connectionPool.sslSkipCertValidation).nioPoolSize(settings.nioPoolSize).workerPoolSize(settings.workerPoolSize).reconnectInterval(settings.connectionPool.reconnectInterval).resultIterationBatchSize(settings.connectionPool.resultIterationBatchSize).maxResponseContentLength(settings.connectionPool.maxResponseContentLength).maxWaitForConnection(settings.connectionPool.maxWaitForConnection).maxConnectionPoolSize(settings.connectionPool.maxSize).connectionSetupTimeoutMillis(settings.connectionPool.connectionSetupTimeoutMillis).idleConnectionTimeoutMillis(settings.connectionPool.idleConnectionTimeout).enableUserAgentOnConnect(settings.enableUserAgentOnConnect).bulkResults(settings.bulkResults).validationRequest(settings.connectionPool.validationRequest);
        if (!settings.auth.type.isEmpty()) {
            builder.auth(Auth.from(settings.auth));
        }
        if (addresses.size() > 1) {
            addresses.stream().skip(1L).forEach(builder::addContactPoint);
        }
        try {
            builder.serializer(settings.serializer.create());
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not establish serializer - " + ex.getMessage());
        }
        return builder;
    }

    public static Cluster open() {
        return Cluster.build("localhost").create();
    }

    public static Cluster open(Configuration conf) {
        return Cluster.getBuilderFromSettings(Settings.from(conf)).create();
    }

    public static Cluster open(String configurationFile) throws Exception {
        File systemFile = new File(configurationFile);
        if (!systemFile.exists()) {
            ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
            URL resource = currentClassLoader.getResource(configurationFile);
            File resourceFile = new File(resource.getFile());
            if (!resourceFile.exists()) {
                throw new IllegalArgumentException(String.format("Configuration file at %s does not exist", configurationFile));
            }
            return Cluster.build(resourceFile).create();
        }
        return Cluster.build(systemFile).create();
    }

    public void close() {
        this.closeAsync().join();
    }

    public CompletableFuture<Void> closeAsync() {
        return this.manager.close().thenRun(() -> logger.info("Closed Cluster for hosts [{}]", (Object)this));
    }

    public boolean isClosing() {
        return this.manager.isClosing();
    }

    public boolean isClosed() {
        return this.manager.isClosing() && this.manager.close().isDone();
    }

    public List<URI> availableHosts() {
        return Collections.unmodifiableList(this.allHosts().stream().filter(Host::isAvailable).map(Host::getHostUri).collect(Collectors.toList()));
    }

    public String getPath() {
        return this.manager.path;
    }

    public String[] getSerializers() {
        return this.getSerializer().mimeTypesSupported();
    }

    public boolean isSslEnabled() {
        return ((Manager)this.manager).connectionPoolSettings.enableSsl;
    }

    public int maxConnectionPoolSize() {
        return ((Manager)this.manager).connectionPoolSettings.maxSize;
    }

    public int getResultIterationBatchSize() {
        return ((Manager)this.manager).connectionPoolSettings.resultIterationBatchSize;
    }

    public int getMaxWaitForConnection() {
        return ((Manager)this.manager).connectionPoolSettings.maxWaitForConnection;
    }

    public int getMaxWaitForClose() {
        return ((Manager)this.manager).connectionPoolSettings.maxWaitForClose;
    }

    public long getMaxResponseContentLength() {
        return ((Manager)this.manager).connectionPoolSettings.maxResponseContentLength;
    }

    public long getIdleConnectionTimeout() {
        return ((Manager)this.manager).connectionPoolSettings.idleConnectionTimeout;
    }

    public Class<? extends LoadBalancingStrategy> getLoadBalancingStrategy() {
        return this.manager.loadBalancingStrategy.getClass();
    }

    public int getPort() {
        return this.manager.port;
    }

    public Collection<Host> allHosts() {
        return Collections.unmodifiableCollection(this.manager.allHosts());
    }

    Factory getFactory() {
        return this.manager.factory;
    }

    MessageSerializer<?> getSerializer() {
        return this.manager.serializer;
    }

    List<Pair<String, ? extends RequestInterceptor>> getRequestInterceptors() {
        return this.manager.interceptors;
    }

    ScheduledExecutorService executor() {
        return this.manager.executor;
    }

    ScheduledExecutorService hostScheduler() {
        return this.manager.hostScheduler;
    }

    ScheduledExecutorService connectionScheduler() {
        return this.manager.connectionScheduler;
    }

    Settings.ConnectionPoolSettings connectionPoolSettings() {
        return this.manager.connectionPoolSettings;
    }

    LoadBalancingStrategy loadBalancingStrategy() {
        return this.manager.loadBalancingStrategy;
    }

    RequestMessage.Builder validationRequest() {
        return (RequestMessage.Builder)this.manager.validationRequest.get();
    }

    SslContext createSSLContext() throws Exception {
        SslContextBuilder builder;
        Settings.ConnectionPoolSettings connectionPoolSettings;
        SslProvider provider;
        block18: {
            if (this.manager.sslContextOptional.isPresent()) {
                return (SslContext)this.manager.sslContextOptional.get();
            }
            provider = SslProvider.JDK;
            connectionPoolSettings = this.connectionPoolSettings();
            builder = SslContextBuilder.forClient();
            try {
                FileInputStream in;
                char[] password;
                if (null != connectionPoolSettings.keyStore) {
                    String keyStoreType = null == connectionPoolSettings.keyStoreType ? KeyStore.getDefaultType() : connectionPoolSettings.keyStoreType;
                    KeyStore keystore = KeyStore.getInstance(keyStoreType);
                    password = null == connectionPoolSettings.keyStorePassword ? null : connectionPoolSettings.keyStorePassword.toCharArray();
                    in = new FileInputStream(connectionPoolSettings.keyStore);
                    try {
                        keystore.load(in, password);
                    }
                    finally {
                        ((InputStream)in).close();
                    }
                    KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                    kmf.init(keystore, password);
                    builder.keyManager(kmf);
                }
                if (null == connectionPoolSettings.trustStore) break block18;
                String trustStoreType = null != connectionPoolSettings.trustStoreType ? connectionPoolSettings.trustStoreType : (null != connectionPoolSettings.keyStoreType ? connectionPoolSettings.keyStoreType : KeyStore.getDefaultType());
                KeyStore truststore = KeyStore.getInstance(trustStoreType);
                password = null == connectionPoolSettings.trustStorePassword ? null : connectionPoolSettings.trustStorePassword.toCharArray();
                in = new FileInputStream(connectionPoolSettings.trustStore);
                try {
                    truststore.load(in, password);
                }
                finally {
                    ((InputStream)in).close();
                }
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                tmf.init(truststore);
                builder.trustManager(tmf);
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
                logger.error("There was an error enabling SSL.", (Throwable)e);
                return null;
            }
        }
        if (null != connectionPoolSettings.sslCipherSuites && !connectionPoolSettings.sslCipherSuites.isEmpty()) {
            builder.ciphers(connectionPoolSettings.sslCipherSuites);
        }
        if (null != connectionPoolSettings.sslEnabledProtocols && !connectionPoolSettings.sslEnabledProtocols.isEmpty()) {
            builder.protocols(connectionPoolSettings.sslEnabledProtocols.toArray(new String[0]));
        }
        if (connectionPoolSettings.sslSkipCertValidation) {
            logger.warn("SSL configured with sslSkipCertValidation thus trusts all certificates without verification (not suitable for production)");
            builder.trustManager(InsecureTrustManagerFactory.INSTANCE);
        }
        builder.sslProvider(provider);
        return builder.build();
    }

    public boolean isUserAgentOnConnectEnabled() {
        return this.manager.isUserAgentOnConnectEnabled();
    }

    public boolean isBulkResultsEnabled() {
        return this.manager.isBulkResultsEnabled();
    }

    class Manager {
        private final ConcurrentMap<InetSocketAddress, Host> hosts = new ConcurrentHashMap<InetSocketAddress, Host>();
        private boolean initialized;
        private final List<InetSocketAddress> contactPoints;
        private final Factory factory;
        private final MessageSerializer<?> serializer;
        private final Settings.ConnectionPoolSettings connectionPoolSettings;
        private final LoadBalancingStrategy loadBalancingStrategy;
        private final Optional<SslContext> sslContextOptional;
        private final Supplier<RequestMessage.Builder> validationRequest;
        private final List<Pair<String, ? extends RequestInterceptor>> interceptors;
        private final ScheduledThreadPoolExecutor executor;
        private final ScheduledThreadPoolExecutor hostScheduler;
        private final ScheduledThreadPoolExecutor connectionScheduler;
        private final int nioPoolSize;
        private final int workerPoolSize;
        private final int port;
        private final String path;
        private final boolean enableUserAgentOnConnect;
        private final boolean bulkResults;
        private final AtomicReference<CompletableFuture<Void>> closeFuture = new AtomicReference();
        private final List<WeakReference<Client>> openedClients = new ArrayList<WeakReference<Client>>();

        private Manager(Builder builder) {
            this.validateBuilder(builder);
            this.loadBalancingStrategy = builder.loadBalancingStrategy;
            this.contactPoints = builder.getContactPoints();
            this.interceptors = builder.interceptors;
            this.enableUserAgentOnConnect = builder.enableUserAgentOnConnect;
            this.bulkResults = builder.bulkResults;
            this.connectionPoolSettings = new Settings.ConnectionPoolSettings();
            this.connectionPoolSettings.maxSize = builder.maxConnectionPoolSize;
            this.connectionPoolSettings.maxWaitForConnection = builder.maxWaitForConnection;
            this.connectionPoolSettings.maxWaitForClose = builder.maxWaitForClose;
            this.connectionPoolSettings.maxResponseContentLength = builder.maxResponseContentLength;
            this.connectionPoolSettings.reconnectInterval = builder.reconnectInterval;
            this.connectionPoolSettings.resultIterationBatchSize = builder.resultIterationBatchSize;
            this.connectionPoolSettings.enableSsl = builder.enableSsl;
            this.connectionPoolSettings.keyStore = builder.keyStore;
            this.connectionPoolSettings.keyStorePassword = builder.keyStorePassword;
            this.connectionPoolSettings.trustStore = builder.trustStore;
            this.connectionPoolSettings.trustStorePassword = builder.trustStorePassword;
            this.connectionPoolSettings.keyStoreType = builder.keyStoreType;
            this.connectionPoolSettings.trustStoreType = builder.trustStoreType;
            this.connectionPoolSettings.sslCipherSuites = builder.sslCipherSuites;
            this.connectionPoolSettings.sslEnabledProtocols = builder.sslEnabledProtocols;
            this.connectionPoolSettings.sslSkipCertValidation = builder.sslSkipCertValidation;
            this.connectionPoolSettings.validationRequest = builder.validationRequest;
            this.connectionPoolSettings.connectionSetupTimeoutMillis = builder.connectionSetupTimeoutMillis;
            this.connectionPoolSettings.idleConnectionTimeout = builder.idleConnectionTimeoutMillis;
            this.sslContextOptional = Optional.ofNullable(builder.sslContext);
            this.nioPoolSize = builder.nioPoolSize;
            this.workerPoolSize = builder.workerPoolSize;
            this.port = builder.port;
            this.path = builder.path;
            this.factory = new Factory(builder.nioPoolSize);
            this.serializer = builder.serializer;
            this.executor = new ScheduledThreadPoolExecutor(builder.workerPoolSize, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("gremlin-driver-worker-%d").build());
            this.executor.setRemoveOnCancelPolicy(true);
            this.hostScheduler = new ScheduledThreadPoolExecutor(this.contactPoints.size() + 1, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("gremlin-driver-host-scheduler-%d").build());
            this.connectionScheduler = new ScheduledThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("gremlin-driver-conn-scheduler-%d").build());
            this.validationRequest = () -> RequestMessage.build((String)builder.validationRequest);
        }

        private void validateBuilder(Builder builder) {
            if (builder.maxConnectionPoolSize < 1) {
                throw new IllegalArgumentException("maxConnectionPoolSize must be greater than zero");
            }
            if (builder.maxWaitForConnection < 1) {
                throw new IllegalArgumentException("maxWaitForConnection must be greater than zero");
            }
            if (builder.maxWaitForClose < 1) {
                throw new IllegalArgumentException("maxWaitForClose must be greater than zero");
            }
            if (builder.maxResponseContentLength < 0L) {
                throw new IllegalArgumentException("maxResponseContentLength must be greater than or equal to zero");
            }
            if (builder.reconnectInterval < 1) {
                throw new IllegalArgumentException("reconnectInterval must be greater than zero");
            }
            if (builder.resultIterationBatchSize < 1) {
                throw new IllegalArgumentException("resultIterationBatchSize must be greater than zero");
            }
            if (builder.nioPoolSize < 1) {
                throw new IllegalArgumentException("nioPoolSize must be greater than zero");
            }
            if (builder.workerPoolSize < 1) {
                throw new IllegalArgumentException("workerPoolSize must be greater than zero");
            }
            if (builder.connectionSetupTimeoutMillis < 1L) {
                throw new IllegalArgumentException("connectionSetupTimeoutMillis must be greater than zero");
            }
            if (builder.idleConnectionTimeoutMillis != 0L && builder.idleConnectionTimeoutMillis < 1000L) {
                throw new IllegalArgumentException("idleConnectionTimeoutMillis must be zero or greater than or equal to 1000");
            }
        }

        synchronized void init() {
            if (this.initialized) {
                return;
            }
            this.initialized = true;
            this.contactPoints.forEach(address -> {
                Host host = this.add((InetSocketAddress)address);
            });
        }

        void trackClient(Client client) {
            this.openedClients.add(new WeakReference<Client>(client));
        }

        public Host add(InetSocketAddress address) {
            Host newHost = new Host(address, Cluster.this);
            Host previous = this.hosts.putIfAbsent(address, newHost);
            return previous == null ? newHost : null;
        }

        Collection<Host> allHosts() {
            return this.hosts.values();
        }

        synchronized CompletableFuture<Void> close() {
            if (this.closeFuture.get() != null) {
                return this.closeFuture.get();
            }
            ArrayList<CompletableFuture<Void>> clientCloseFutures = new ArrayList<CompletableFuture<Void>>(this.openedClients.size());
            for (WeakReference<Client> openedClient : this.openedClients) {
                Client client = (Client)openedClient.get();
                if (client == null) continue;
                clientCloseFutures.add(client.closeAsync());
            }
            CompletableFuture.allOf(clientCloseFutures.toArray(new CompletableFuture[0])).join();
            CompletableFuture<Void> closeIt = new CompletableFuture<Void>();
            this.factory.shutdown().awaitUninterruptibly().addListener(f -> {
                this.executor.shutdown();
                this.hostScheduler.shutdown();
                this.connectionScheduler.shutdown();
                closeIt.complete(null);
            });
            this.closeFuture.set(closeIt);
            return closeIt;
        }

        boolean isClosing() {
            return this.closeFuture.get() != null;
        }

        public String toString() {
            return String.join((CharSequence)", ", this.contactPoints.stream().map(InetSocketAddress::toString).collect(Collectors.toList()));
        }

        public boolean isUserAgentOnConnectEnabled() {
            return this.enableUserAgentOnConnect;
        }

        public boolean isBulkResultsEnabled() {
            return this.bulkResults;
        }
    }

    static class Factory {
        private final NioEventLoopGroup group;

        public Factory(int nioPoolSize) {
            BasicThreadFactory threadFactory = new BasicThreadFactory.Builder().namingPattern("gremlin-driver-loop-%d").build();
            this.group = new NioEventLoopGroup(nioPoolSize, (ThreadFactory)threadFactory);
        }

        Bootstrap createBootstrap() {
            Bootstrap b = (Bootstrap)new Bootstrap().group((EventLoopGroup)this.group);
            b.option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
            return b;
        }

        Future<?> shutdown() {
            this.group.shutdownGracefully(0L, 2L, TimeUnit.SECONDS);
            return this.group.terminationFuture();
        }
    }

    public static final class Builder {
        private static int INTERCEPTOR_NOT_FOUND = -1;
        private final List<InetAddress> addresses = new ArrayList<InetAddress>();
        private int port = 8182;
        private String path = "/gremlin";
        private MessageSerializer<?> serializer = null;
        private int nioPoolSize = Runtime.getRuntime().availableProcessors();
        private int workerPoolSize = Runtime.getRuntime().availableProcessors() * 2;
        private int maxConnectionPoolSize = 128;
        private int maxWaitForConnection = 16000;
        private int maxWaitForClose = 3000;
        private long maxResponseContentLength = Integer.MAX_VALUE;
        private int reconnectInterval = 1000;
        private int resultIterationBatchSize = 64;
        private boolean enableSsl = false;
        private String keyStore = null;
        private String keyStorePassword = null;
        private String trustStore = null;
        private String trustStorePassword = null;
        private String keyStoreType = null;
        private String trustStoreType = null;
        private String validationRequest = "''";
        private List<String> sslEnabledProtocols = new ArrayList<String>();
        private List<String> sslCipherSuites = new ArrayList<String>();
        private boolean sslSkipCertValidation = false;
        private SslContext sslContext = null;
        private LoadBalancingStrategy loadBalancingStrategy = new LoadBalancingStrategy.RoundRobin();
        private LinkedList<Pair<String, ? extends RequestInterceptor>> interceptors = new LinkedList();
        private long connectionSetupTimeoutMillis = 15000L;
        private long idleConnectionTimeoutMillis = 180000L;
        private boolean enableUserAgentOnConnect = true;
        private boolean bulkResults = false;

        private Builder() {
            this.addInterceptor(Cluster.SERIALIZER_INTERCEPTOR_NAME, new PayloadSerializingInterceptor((MessageSerializer)new GraphBinaryMessageSerializerV4()));
        }

        private Builder(String address) {
            this.addContactPoint(address);
            this.addInterceptor(Cluster.SERIALIZER_INTERCEPTOR_NAME, new PayloadSerializingInterceptor((MessageSerializer)new GraphBinaryMessageSerializerV4()));
        }

        private Builder(RequestInterceptor bodySerializer) {
            this.addInterceptor(Cluster.SERIALIZER_INTERCEPTOR_NAME, bodySerializer);
        }

        public Builder nioPoolSize(int nioPoolSize) {
            this.nioPoolSize = nioPoolSize;
            return this;
        }

        public Builder workerPoolSize(int workerPoolSize) {
            this.workerPoolSize = workerPoolSize;
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder serializer(String mimeType) {
            this.serializer = Serializers.valueOf((String)mimeType).simpleInstance();
            return this;
        }

        public Builder serializer(Serializers mimeType) {
            this.serializer = mimeType.simpleInstance();
            return this;
        }

        public Builder serializer(MessageSerializer<?> serializer) {
            this.serializer = serializer;
            return this;
        }

        public Builder enableSsl(boolean enable) {
            this.enableSsl = enable;
            return this;
        }

        public Builder sslContext(SslContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public Builder keyStore(String keyStore) {
            this.keyStore = keyStore;
            return this;
        }

        public Builder keyStorePassword(String keyStorePassword) {
            this.keyStorePassword = keyStorePassword;
            return this;
        }

        public Builder trustStore(String trustStore) {
            this.trustStore = trustStore;
            return this;
        }

        public Builder trustStorePassword(String trustStorePassword) {
            this.trustStorePassword = trustStorePassword;
            return this;
        }

        public Builder keyStoreType(String keyStoreType) {
            this.keyStoreType = keyStoreType;
            return this;
        }

        public Builder trustStoreType(String trustStoreType) {
            this.trustStoreType = trustStoreType;
            return this;
        }

        public Builder sslEnabledProtocols(List<String> sslEnabledProtocols) {
            this.sslEnabledProtocols = sslEnabledProtocols;
            return this;
        }

        public Builder sslCipherSuites(List<String> sslCipherSuites) {
            this.sslCipherSuites = sslCipherSuites;
            return this;
        }

        public Builder sslSkipCertValidation(boolean sslSkipCertValidation) {
            this.sslSkipCertValidation = sslSkipCertValidation;
            return this;
        }

        public Builder maxConnectionPoolSize(int maxSize) {
            this.maxConnectionPoolSize = maxSize;
            return this;
        }

        public Builder resultIterationBatchSize(int size) {
            this.resultIterationBatchSize = size;
            return this;
        }

        public Builder maxWaitForConnection(int maxWait) {
            this.maxWaitForConnection = maxWait;
            return this;
        }

        public Builder maxWaitForClose(int maxWait) {
            this.maxWaitForClose = maxWait;
            return this;
        }

        public Builder maxResponseContentLength(long maxResponseContentLength) {
            this.maxResponseContentLength = maxResponseContentLength;
            return this;
        }

        public Builder validationRequest(String script) {
            this.validationRequest = script;
            return this;
        }

        public Builder reconnectInterval(int interval) {
            this.reconnectInterval = interval;
            return this;
        }

        public Builder loadBalancingStrategy(LoadBalancingStrategy loadBalancingStrategy) {
            this.loadBalancingStrategy = loadBalancingStrategy;
            return this;
        }

        public Builder addInterceptorAfter(String priorInterceptorName, String nameOfInterceptor, RequestInterceptor interceptor) {
            int index = this.getInterceptorIndex(priorInterceptorName);
            if (INTERCEPTOR_NOT_FOUND == index) {
                throw new IllegalArgumentException(priorInterceptorName + " interceptor not found");
            }
            if (this.getInterceptorIndex(nameOfInterceptor) != INTERCEPTOR_NOT_FOUND) {
                throw new IllegalArgumentException(nameOfInterceptor + " interceptor already exists");
            }
            this.interceptors.add(index + 1, (Pair<String, ? extends RequestInterceptor>)Pair.of((Object)nameOfInterceptor, (Object)interceptor));
            return this;
        }

        public Builder addInterceptorBefore(String subsequentInterceptorName, String nameOfInterceptor, RequestInterceptor interceptor) {
            int index = this.getInterceptorIndex(subsequentInterceptorName);
            if (INTERCEPTOR_NOT_FOUND == index) {
                throw new IllegalArgumentException(subsequentInterceptorName + " interceptor not found");
            }
            if (this.getInterceptorIndex(nameOfInterceptor) != INTERCEPTOR_NOT_FOUND) {
                throw new IllegalArgumentException(nameOfInterceptor + " interceptor already exists");
            }
            if (index == 0) {
                this.interceptors.addFirst((Pair<String, ? extends RequestInterceptor>)Pair.of((Object)nameOfInterceptor, (Object)interceptor));
            } else {
                this.interceptors.add(index - 1, (Pair<String, ? extends RequestInterceptor>)Pair.of((Object)nameOfInterceptor, (Object)interceptor));
            }
            return this;
        }

        public Builder addInterceptor(String name, RequestInterceptor interceptor) {
            if (this.getInterceptorIndex(name) != INTERCEPTOR_NOT_FOUND) {
                throw new IllegalArgumentException(name + " interceptor already exists");
            }
            this.interceptors.add((Pair<String, ? extends RequestInterceptor>)Pair.of((Object)name, (Object)interceptor));
            return this;
        }

        public Builder removeInterceptor(String name) {
            int index = this.getInterceptorIndex(name);
            if (index == INTERCEPTOR_NOT_FOUND) {
                throw new IllegalArgumentException(name + " interceptor not found");
            }
            this.interceptors.remove(index);
            return this;
        }

        private int getInterceptorIndex(String name) {
            for (int i = 0; i < this.interceptors.size(); ++i) {
                if (!((String)this.interceptors.get(i).getLeft()).equals(name)) continue;
                return i;
            }
            return INTERCEPTOR_NOT_FOUND;
        }

        public Builder auth(Auth auth) {
            this.addInterceptor(auth.getClass().getSimpleName().toLowerCase() + "-auth", auth);
            return this;
        }

        public Builder addContactPoint(String address) {
            try {
                this.addresses.add(InetAddress.getByName(address));
                return this;
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }

        public Builder addContactPoints(String ... addresses) {
            for (String address : addresses) {
                this.addContactPoint(address);
            }
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder connectionSetupTimeoutMillis(long connectionSetupTimeoutMillis) {
            this.connectionSetupTimeoutMillis = connectionSetupTimeoutMillis;
            return this;
        }

        public Builder idleConnectionTimeoutMillis(long idleConnectionTimeoutMillis) {
            this.idleConnectionTimeoutMillis = idleConnectionTimeoutMillis;
            return this;
        }

        public Builder enableUserAgentOnConnect(boolean enableUserAgentOnConnect) {
            this.enableUserAgentOnConnect = enableUserAgentOnConnect;
            return this;
        }

        public Builder bulkResults(boolean bulkResults) {
            this.bulkResults = bulkResults;
            return this;
        }

        List<InetSocketAddress> getContactPoints() {
            return this.addresses.stream().map(addy -> new InetSocketAddress((InetAddress)addy, this.port)).collect(Collectors.toList());
        }

        public Cluster create() {
            if (this.addresses.isEmpty()) {
                this.addContactPoint("localhost");
            }
            if (null == this.serializer) {
                this.serializer = Serializers.GRAPHBINARY_V4.simpleInstance();
            }
            return new Cluster(this);
        }
    }
}

