"use strict";
/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.graphBinaryWriter = exports.graphBinaryReader = exports.anySerializer = exports.numberSerializationStrategy = exports.unspecifiedNullSerializer = exports.bulkSetSerializer = exports.traversalStrategySerializer = exports.textPSerializer = exports.booleanSerializer = exports.shortSerializer = exports.byteBufferSerializer = exports.byteSerializer = exports.bigIntegerSerializer = exports.lambdaSerializer = exports.enumSerializer = exports.traverserSerializer = exports.pSerializer = exports.bytecodeSerializer = exports.vertexPropertySerializer = exports.vertexSerializer = exports.propertySerializer = exports.pathSerializer = exports.edgeSerializer = exports.uuidSerializer = exports.setSerializer = exports.mapSerializer = exports.listSerializer = exports.floatSerializer = exports.doubleSerializer = exports.classSerializer = exports.timestampSerializer = exports.dateSerializer = exports.stringSerializer = exports.longSerializerNg = exports.longSerializer = exports.intSerializer = exports.serializers = exports.DataType = void 0;
/**
 * GraphBinary 1.0 support implementation.
 *
 * The officially expected entrypoint is GraphBinaryReader/GraphBinaryWriter pair of classes,
 * examine lib/driver/** for use cases.
 *
 * See AnySerializer.serialize() for the mechanism of serializer selection for a given JavaScript value,
 * also consider AnySerializer.serialize() unit tests for real examples.
 * See NumberSerializationStrategy to understand how it deals with JavaScript numbers' serialization.
 *
 * Consider AnySerializer.serialize()/deserialize() unit tests to see what is not implemented,
 * what is ignored, what is not expected to be (de)serialized, etc.
 *
 * TODO: it has the following open topics:
 * - [] Should we do anything for application/vnd.graphbinary-v1.0-stringd mime type support?
 * Core Data Types support:
 * - [] 0x22: BigDecimal
 * - [] 0x2b: Tree
 * - [] 0x2c: Metrics
 * - [] 0x2d: TraversalMetrics
 * - [] 0x00: Custom
 * Extended Types support:
 * - [] 0x80: Char
 * - [] 0x81: Duration
 * - [] 0x82: InetAddress
 * - [] 0x83: Instant
 * - [] 0x84: LocalDate
 * - [] 0x85: LocalDateTime
 * - [] 0x86: LocalTime
 * - [] 0x87: MonthDay
 * - [] 0x88: OffsetDateTime
 * - [] 0x89: OffsetTime
 * - [] 0x8a: Period
 * - [] 0x8b: Year
 * - [] 0x8c: YearMonth
 * - [] 0x8d: ZonedDateTime
 * - [] 0x8e: ZoneOffset
 *
 * @author Igor Ostapenko
 */
/*eslint-disable*/
const DataType_js_1 = __importDefault(require("./internals/DataType.cjs"));
const utils = __importStar(require("./internals/utils.cjs"));
const IntSerializer_js_1 = __importDefault(require("./internals/IntSerializer.cjs"));
const LongSerializer_js_1 = __importDefault(require("./internals/LongSerializer.cjs"));
const LongSerializerNg_js_1 = __importDefault(require("./internals/LongSerializerNg.cjs"));
const StringSerializer_js_1 = __importDefault(require("./internals/StringSerializer.cjs"));
const DateSerializer_js_1 = __importDefault(require("./internals/DateSerializer.cjs"));
const DoubleSerializer_js_1 = __importDefault(require("./internals/DoubleSerializer.cjs"));
const FloatSerializer_js_1 = __importDefault(require("./internals/FloatSerializer.cjs"));
const ArraySerializer_js_1 = __importDefault(require("./internals/ArraySerializer.cjs"));
const MapSerializer_js_1 = __importDefault(require("./internals/MapSerializer.cjs"));
const SetSerializer_js_1 = __importDefault(require("./internals/SetSerializer.cjs"));
const UuidSerializer_js_1 = __importDefault(require("./internals/UuidSerializer.cjs"));
const EdgeSerializer_js_1 = __importDefault(require("./internals/EdgeSerializer.cjs"));
const PathSerializer_js_1 = __importDefault(require("./internals/PathSerializer.cjs"));
const PropertySerializer_js_1 = __importDefault(require("./internals/PropertySerializer.cjs"));
const VertexSerializer_js_1 = __importDefault(require("./internals/VertexSerializer.cjs"));
const VertexPropertySerializer_js_1 = __importDefault(require("./internals/VertexPropertySerializer.cjs"));
const BytecodeSerializer_js_1 = __importDefault(require("./internals/BytecodeSerializer.cjs"));
const PSerializer_js_1 = __importDefault(require("./internals/PSerializer.cjs"));
const TraverserSerializer_js_1 = __importDefault(require("./internals/TraverserSerializer.cjs"));
const EnumSerializer_js_1 = __importDefault(require("./internals/EnumSerializer.cjs"));
const LambdaSerializer_js_1 = __importDefault(require("./internals/LambdaSerializer.cjs"));
const BigIntegerSerializer_js_1 = __importDefault(require("./internals/BigIntegerSerializer.cjs"));
const ByteSerializer_js_1 = __importDefault(require("./internals/ByteSerializer.cjs"));
const ByteBufferSerializer_js_1 = __importDefault(require("./internals/ByteBufferSerializer.cjs"));
const ShortSerializer_js_1 = __importDefault(require("./internals/ShortSerializer.cjs"));
const BooleanSerializer_js_1 = __importDefault(require("./internals/BooleanSerializer.cjs"));
const TextPSerializer_js_1 = __importDefault(require("./internals/TextPSerializer.cjs"));
const TraversalStrategySerializer_js_1 = __importDefault(require("./internals/TraversalStrategySerializer.cjs"));
const BulkSetSerializer_js_1 = __importDefault(require("./internals/BulkSetSerializer.cjs"));
const UnspecifiedNullSerializer_js_1 = __importDefault(require("./internals/UnspecifiedNullSerializer.cjs"));
const NumberSerializationStrategy_js_1 = __importDefault(require("./internals/NumberSerializationStrategy.cjs"));
const AnySerializer_js_1 = __importDefault(require("./internals/AnySerializer.cjs"));
const GraphBinaryReader_js_1 = __importDefault(require("./internals/GraphBinaryReader.cjs"));
const GraphBinaryWriter_js_1 = __importDefault(require("./internals/GraphBinaryWriter.cjs"));
const ioc = {};
ioc.DataType = DataType_js_1.default;
ioc.utils = utils;
ioc.serializers = {};
ioc.intSerializer = new IntSerializer_js_1.default(ioc);
ioc.longSerializer = new LongSerializer_js_1.default(ioc);
ioc.longSerializerNg = new LongSerializerNg_js_1.default(ioc);
ioc.stringSerializer = new StringSerializer_js_1.default(ioc, ioc.DataType.STRING);
ioc.dateSerializer = new DateSerializer_js_1.default(ioc, ioc.DataType.DATE);
ioc.timestampSerializer = new DateSerializer_js_1.default(ioc, ioc.DataType.TIMESTAMP);
ioc.classSerializer = new StringSerializer_js_1.default(ioc, ioc.DataType.CLASS);
ioc.doubleSerializer = new DoubleSerializer_js_1.default(ioc);
ioc.floatSerializer = new FloatSerializer_js_1.default(ioc);
ioc.listSerializer = new ArraySerializer_js_1.default(ioc, ioc.DataType.LIST);
ioc.mapSerializer = new MapSerializer_js_1.default(ioc);
ioc.setSerializer = new SetSerializer_js_1.default(ioc, ioc.DataType.SET);
ioc.uuidSerializer = new UuidSerializer_js_1.default(ioc);
ioc.edgeSerializer = new EdgeSerializer_js_1.default(ioc);
ioc.pathSerializer = new PathSerializer_js_1.default(ioc);
ioc.propertySerializer = new PropertySerializer_js_1.default(ioc);
ioc.vertexSerializer = new VertexSerializer_js_1.default(ioc);
ioc.vertexPropertySerializer = new VertexPropertySerializer_js_1.default(ioc);
ioc.bytecodeSerializer = new BytecodeSerializer_js_1.default(ioc);
ioc.pSerializer = new PSerializer_js_1.default(ioc);
ioc.traverserSerializer = new TraverserSerializer_js_1.default(ioc);
ioc.enumSerializer = new EnumSerializer_js_1.default(ioc);
ioc.lambdaSerializer = new LambdaSerializer_js_1.default(ioc);
ioc.bigIntegerSerializer = new BigIntegerSerializer_js_1.default(ioc);
ioc.byteSerializer = new ByteSerializer_js_1.default(ioc);
ioc.byteBufferSerializer = new ByteBufferSerializer_js_1.default(ioc);
ioc.shortSerializer = new ShortSerializer_js_1.default(ioc);
ioc.booleanSerializer = new BooleanSerializer_js_1.default(ioc);
ioc.textPSerializer = new TextPSerializer_js_1.default(ioc);
ioc.traversalStrategySerializer = new TraversalStrategySerializer_js_1.default(ioc);
ioc.bulkSetSerializer = new BulkSetSerializer_js_1.default(ioc);
ioc.unspecifiedNullSerializer = new UnspecifiedNullSerializer_js_1.default(ioc);
ioc.numberSerializationStrategy = new NumberSerializationStrategy_js_1.default(ioc);
ioc.anySerializer = new AnySerializer_js_1.default(ioc);
ioc.graphBinaryReader = new GraphBinaryReader_js_1.default(ioc);
ioc.graphBinaryWriter = new GraphBinaryWriter_js_1.default(ioc);
var DataType_js_2 = require("./internals/DataType.cjs");
Object.defineProperty(exports, "DataType", { enumerable: true, get: function () { return __importDefault(DataType_js_2).default; } });
exports.serializers = ioc.serializers, exports.intSerializer = ioc.intSerializer, exports.longSerializer = ioc.longSerializer, exports.longSerializerNg = ioc.longSerializerNg, exports.stringSerializer = ioc.stringSerializer, exports.dateSerializer = ioc.dateSerializer, exports.timestampSerializer = ioc.timestampSerializer, exports.classSerializer = ioc.classSerializer, exports.doubleSerializer = ioc.doubleSerializer, exports.floatSerializer = ioc.floatSerializer, exports.listSerializer = ioc.listSerializer, exports.mapSerializer = ioc.mapSerializer, exports.setSerializer = ioc.setSerializer, exports.uuidSerializer = ioc.uuidSerializer, exports.edgeSerializer = ioc.edgeSerializer, exports.pathSerializer = ioc.pathSerializer, exports.propertySerializer = ioc.propertySerializer, exports.vertexSerializer = ioc.vertexSerializer, exports.vertexPropertySerializer = ioc.vertexPropertySerializer, exports.bytecodeSerializer = ioc.bytecodeSerializer, exports.pSerializer = ioc.pSerializer, exports.traverserSerializer = ioc.traverserSerializer, exports.enumSerializer = ioc.enumSerializer, exports.lambdaSerializer = ioc.lambdaSerializer, exports.bigIntegerSerializer = ioc.bigIntegerSerializer, exports.byteSerializer = ioc.byteSerializer, exports.byteBufferSerializer = ioc.byteBufferSerializer, exports.shortSerializer = ioc.shortSerializer, exports.booleanSerializer = ioc.booleanSerializer, exports.textPSerializer = ioc.textPSerializer, exports.traversalStrategySerializer = ioc.traversalStrategySerializer, exports.bulkSetSerializer = ioc.bulkSetSerializer, exports.unspecifiedNullSerializer = ioc.unspecifiedNullSerializer, exports.numberSerializationStrategy = ioc.numberSerializationStrategy, exports.anySerializer = ioc.anySerializer, exports.graphBinaryReader = ioc.graphBinaryReader, exports.graphBinaryWriter = ioc.graphBinaryWriter;
exports.default = ioc;
