/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.language.grammar;

import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.RuleNode;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.tinkerpop.gremlin.language.grammar.DefaultGremlinBaseVisitor;
import org.apache.tinkerpop.gremlin.language.grammar.GremlinAntlrToJava;
import org.apache.tinkerpop.gremlin.language.grammar.GremlinParser;
import org.apache.tinkerpop.gremlin.language.grammar.GremlinParserException;
import org.apache.tinkerpop.gremlin.language.grammar.TraversalEnumParser;
import org.apache.tinkerpop.gremlin.language.grammar.TraversalTerminalMethodVisitor;
import org.apache.tinkerpop.gremlin.process.traversal.Merge;
import org.apache.tinkerpop.gremlin.process.traversal.Pick;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.util.DatetimeHelper;

public class GenericLiteralVisitor
extends DefaultGremlinBaseVisitor<Object> {
    public static final int TOTAL_INTEGER_RANGE_RESULT_COUNT_LIMIT = 1000000;
    protected final GremlinAntlrToJava antlr;

    public GenericLiteralVisitor(GremlinAntlrToJava antlr) {
        this.antlr = antlr;
    }

    public Number parseIntegral(GremlinParser.IntegerLiteralContext integerLiteral) {
        return (Number)this.visitIntegerLiteral(integerLiteral);
    }

    public Number parseFloating(GremlinParser.FloatLiteralContext floatLiteral) {
        return (Number)this.visitFloatLiteral(floatLiteral);
    }

    public String parseString(GremlinParser.StringLiteralContext stringLiteral) {
        return (String)this.visitStringLiteral(stringLiteral);
    }

    public String parseString(GremlinParser.StringNullableLiteralContext stringLiteral) {
        return (String)this.visitStringNullableLiteral(stringLiteral);
    }

    public OffsetDateTime parseDate(GremlinParser.DateLiteralContext dateLiteral) {
        return (OffsetDateTime)this.visitDateLiteral(dateLiteral);
    }

    public UUID parseUuid(GremlinParser.UuidLiteralContext uuidLiteral) {
        return (UUID)this.visitUuidLiteral(uuidLiteral);
    }

    public Map parseMap(GremlinParser.GenericMapLiteralContext mapLiteral) {
        return (Map)this.visitGenericMapLiteral(mapLiteral);
    }

    public boolean parseBoolean(GremlinParser.BooleanLiteralContext booleanLiteral) {
        return (Boolean)this.visitBooleanLiteral(booleanLiteral);
    }

    public Object[] parseObjectList(GremlinParser.GenericCollectionLiteralContext collectionLiteral) {
        if (collectionLiteral == null || collectionLiteral.genericLiteral() == null) {
            return new Object[0];
        }
        return collectionLiteral.genericLiteral().stream().filter(Objects::nonNull).map(this.antlr.genericVisitor::visitGenericLiteral).toArray(Object[]::new);
    }

    public Object[] parseObjectVarargs(GremlinParser.GenericLiteralVarargsContext varargsContext) {
        if (varargsContext == null || varargsContext.genericLiteralExpr() == null || varargsContext.genericLiteralExpr().genericLiteral() == null) {
            return new Object[0];
        }
        return varargsContext.genericLiteralExpr().genericLiteral().stream().filter(Objects::nonNull).map(this.antlr.genericVisitor::visitGenericLiteral).toArray(Object[]::new);
    }

    public String[] parseStringVarargs(GremlinParser.StringNullableLiteralVarargsContext varargsContext) {
        if (varargsContext == null) {
            return new String[0];
        }
        return (String[])varargsContext.stringNullableLiteral().stream().filter(Objects::nonNull).map(this.antlr.genericVisitor::parseString).toArray(String[]::new);
    }

    public static TraversalStrategy[] parseTraversalStrategyList(GremlinParser.TraversalStrategyVarargsContext traversalStrategyListContext, DefaultGremlinBaseVisitor<TraversalStrategy> traversalStrategyVisitor) {
        if (traversalStrategyListContext == null || traversalStrategyListContext.traversalStrategyExpr() == null) {
            return new TraversalStrategy[0];
        }
        return (TraversalStrategy[])traversalStrategyListContext.traversalStrategyExpr().traversalStrategy().stream().filter(Objects::nonNull).map(tstrat -> (TraversalStrategy)traversalStrategyVisitor.visitTraversalStrategy((GremlinParser.TraversalStrategyContext)tstrat)).toArray(TraversalStrategy[]::new);
    }

    private static String stripQuotes(String quotedString) {
        return quotedString.substring(1, quotedString.length() - 1);
    }

    private static Object createIntegerRange(int start, int end, String range) {
        ArrayList<Integer> results = new ArrayList<Integer>();
        int total_result_count = Math.abs(start - end);
        if (total_result_count > 1000000) {
            throw new IllegalArgumentException("Range " + range + " is too wide. Current limit is 1000000 items");
        }
        if (start <= end) {
            for (int cur = start; cur <= end; ++cur) {
                results.add(cur);
            }
        } else {
            for (int cur = start; cur >= end; --cur) {
                results.add(cur);
            }
        }
        return results;
    }

    private static Object createStringRange(String start, String end, String range) {
        char endLastCharacter;
        ArrayList<CallSite> results = new ArrayList<CallSite>();
        if (start.length() != end.length()) {
            throw new IllegalArgumentException("The start and end of Range " + range + " does not have same number of characters");
        }
        if (start.isEmpty()) {
            return results;
        }
        String commonPrefix = start.substring(0, start.length() - 1);
        if (!end.startsWith(commonPrefix)) {
            throw new IllegalArgumentException("The start and end of Range " + range + " does not share same prefix until the last character");
        }
        char startLastCharacter = start.charAt(start.length() - 1);
        if (startLastCharacter <= (endLastCharacter = end.charAt(end.length() - 1))) {
            for (char cur = startLastCharacter; cur <= endLastCharacter; cur = (char)(cur + '\u0001')) {
                results.add((CallSite)((Object)(commonPrefix + cur)));
            }
        } else {
            for (char cur = startLastCharacter; cur >= endLastCharacter; cur = (char)(cur - '\u0001')) {
                results.add((CallSite)((Object)(commonPrefix + cur)));
            }
        }
        return results;
    }

    @Override
    public Object visitGenericLiteralExpr(GremlinParser.GenericLiteralExprContext ctx) {
        int childCount = ctx.getChildCount();
        switch (childCount) {
            case 0: {
                return new Object[0];
            }
            case 1: {
                return this.antlr.genericVisitor.visitGenericLiteral(ctx.genericLiteral(0));
            }
        }
        ArrayList<Object> genericLiterals = new ArrayList<Object>();
        for (GremlinParser.GenericLiteralContext ic : ctx.genericLiteral()) {
            genericLiterals.add(this.antlr.genericVisitor.visitGenericLiteral(ic));
        }
        return genericLiterals.toArray();
    }

    @Override
    public Object visitGenericSetLiteral(GremlinParser.GenericSetLiteralContext ctx) {
        HashSet<Object> result = new HashSet<Object>(ctx.getChildCount() / 2);
        for (GremlinParser.GenericLiteralContext ic : ctx.genericLiteral()) {
            result.add(this.antlr.genericVisitor.visitGenericLiteral(ic));
        }
        return result;
    }

    @Override
    public Object visitGenericLiteral(GremlinParser.GenericLiteralContext ctx) {
        return this.visitChildren((RuleNode)ctx);
    }

    @Override
    public Object visitGenericMapLiteral(GremlinParser.GenericMapLiteralContext ctx) {
        if (ctx == null) {
            return null;
        }
        LinkedHashMap literalMap = new LinkedHashMap();
        ctx.children.stream().filter(c -> c instanceof GremlinParser.MapEntryContext).forEach(c -> {
            Object key;
            ParseTree kctx;
            GremlinParser.MapKeyContext mapKeyContext = ((GremlinParser.MapEntryContext)c).mapKey();
            boolean isKeyExpression = mapKeyContext.LPAREN() != null && mapKeyContext.RPAREN() != null;
            ParseTree parseTree = kctx = isKeyExpression ? mapKeyContext.getChild(1) : mapKeyContext.getChild(0);
            if (kctx instanceof GremlinParser.StringLiteralContext) {
                key = this.visitStringLiteral((GremlinParser.StringLiteralContext)kctx);
            } else if (kctx instanceof GremlinParser.NumericLiteralContext) {
                key = this.visitNumericLiteral((GremlinParser.NumericLiteralContext)kctx);
            } else if (kctx instanceof GremlinParser.TraversalTContext) {
                key = this.visitTraversalT((GremlinParser.TraversalTContext)kctx);
            } else if (kctx instanceof GremlinParser.TraversalTLongContext) {
                key = this.visitTraversalTLong((GremlinParser.TraversalTLongContext)kctx);
            } else if (kctx instanceof GremlinParser.TraversalDirectionContext) {
                key = this.visitTraversalDirection((GremlinParser.TraversalDirectionContext)kctx);
            } else if (kctx instanceof GremlinParser.TraversalDirectionLongContext) {
                key = this.visitTraversalDirectionLong((GremlinParser.TraversalDirectionLongContext)kctx);
            } else if (kctx instanceof GremlinParser.GenericCollectionLiteralContext) {
                key = this.visitGenericCollectionLiteral((GremlinParser.GenericCollectionLiteralContext)kctx);
            } else if (kctx instanceof GremlinParser.GenericSetLiteralContext) {
                key = this.visitGenericSetLiteral((GremlinParser.GenericSetLiteralContext)kctx);
            } else if (kctx instanceof GremlinParser.GenericMapLiteralContext) {
                key = this.visitGenericMapLiteral((GremlinParser.GenericMapLiteralContext)kctx);
            } else if (kctx instanceof GremlinParser.KeywordContext) {
                key = ((GremlinParser.KeywordContext)kctx).getText();
            } else if (kctx instanceof GremlinParser.NakedKeyContext) {
                key = ((GremlinParser.NakedKeyContext)kctx).getText();
            } else if (kctx instanceof TerminalNode) {
                key = ((TerminalNode)kctx).getText();
            } else {
                throw new GremlinParserException("Invalid key for map " + kctx.getText());
            }
            Object value = this.visitGenericLiteral((GremlinParser.GenericLiteralContext)c.getChild(2));
            literalMap.put(key, value);
        });
        return literalMap;
    }

    @Override
    public Object visitGenericMapNullableLiteral(GremlinParser.GenericMapNullableLiteralContext ctx) {
        if (ctx == null) {
            return null;
        }
        if (ctx.nullLiteral() != null) {
            return this.visitNullLiteral(ctx.nullLiteral());
        }
        return this.visitGenericMapLiteral(ctx.genericMapLiteral());
    }

    @Override
    public Object visitNestedTraversal(GremlinParser.NestedTraversalContext ctx) {
        return this.antlr.tvisitor.visitNestedTraversal(ctx);
    }

    @Override
    public Object visitTerminatedTraversal(GremlinParser.TerminatedTraversalContext ctx) {
        Traversal traversal = this.antlr.tvisitor.visitRootTraversal((GremlinParser.RootTraversalContext)ctx.getChild(0));
        return new TraversalTerminalMethodVisitor(traversal).visitTraversalTerminalMethod((GremlinParser.TraversalTerminalMethodContext)ctx.getChild(2));
    }

    @Override
    public Object visitIntegerLiteral(GremlinParser.IntegerLiteralContext ctx) {
        Object integerLiteral = ctx.getText().toLowerCase().replace("_", "");
        int lastCharIndex = ((String)integerLiteral).length() - 1;
        char suffix = ((String)integerLiteral).charAt(lastCharIndex);
        switch (suffix) {
            case 'b': {
                integerLiteral = ((String)integerLiteral).substring(0, lastCharIndex);
                return Byte.decode((String)integerLiteral);
            }
            case 's': {
                integerLiteral = ((String)integerLiteral).substring(0, lastCharIndex);
                return Short.decode((String)integerLiteral);
            }
            case 'i': {
                integerLiteral = ((String)integerLiteral).substring(0, lastCharIndex);
                return Integer.decode((String)integerLiteral);
            }
            case 'l': {
                integerLiteral = ((String)integerLiteral).substring(0, lastCharIndex);
                return Long.decode((String)integerLiteral);
            }
            case 'n': {
                integerLiteral = ((String)integerLiteral).substring(0, lastCharIndex);
                return new BigInteger((String)integerLiteral);
            }
        }
        try {
            return Integer.decode((String)integerLiteral);
        }
        catch (NumberFormatException ignoredExpection1) {
            try {
                return Long.decode((String)integerLiteral);
            }
            catch (NumberFormatException ignoredExpection2) {
                boolean negative;
                int startIndex = 0;
                char firstChar = ((String)integerLiteral).charAt(0);
                boolean bl = negative = firstChar == '-';
                if (firstChar == '-' || firstChar == '+') {
                    ++startIndex;
                }
                int radix = 10;
                if (((String)integerLiteral).charAt(startIndex + 1) == 'x') {
                    radix = 16;
                    integerLiteral = ((String)integerLiteral).substring(startIndex += 2);
                    if (negative) {
                        integerLiteral = "-" + (String)integerLiteral;
                    }
                } else if (((String)integerLiteral).charAt(startIndex) == '0') {
                    radix = 8;
                }
                return new BigInteger((String)integerLiteral, radix);
            }
        }
    }

    @Override
    public Object visitFloatLiteral(GremlinParser.FloatLiteralContext ctx) {
        int lastCharIndex;
        if (ctx.infLiteral() != null) {
            return this.visit((ParseTree)ctx.infLiteral());
        }
        if (ctx.nanLiteral() != null) {
            return this.visit((ParseTree)ctx.nanLiteral());
        }
        String floatLiteral = ctx.getText().toLowerCase();
        char lastCharacter = floatLiteral.charAt(lastCharIndex = floatLiteral.length() - 1);
        if (lastCharacter == 'm') {
            return new BigDecimal(floatLiteral.substring(0, lastCharIndex));
        }
        if (lastCharacter == 'f') {
            return new Float(ctx.getText());
        }
        if (lastCharacter == 'd') {
            return new Double(floatLiteral);
        }
        return new Double(floatLiteral);
    }

    @Override
    public Object visitBooleanLiteral(GremlinParser.BooleanLiteralContext ctx) {
        return Boolean.valueOf(ctx.getText());
    }

    @Override
    public Object visitDateLiteral(GremlinParser.DateLiteralContext ctx) {
        if (ctx.stringLiteral() == null) {
            return DatetimeHelper.datetime();
        }
        return DatetimeHelper.parse((String)this.antlr.genericVisitor.visitStringLiteral(ctx.stringLiteral()));
    }

    @Override
    public Object visitUuidLiteral(GremlinParser.UuidLiteralContext ctx) {
        if (ctx.stringLiteral() == null) {
            return UUID.randomUUID();
        }
        return UUID.fromString((String)this.antlr.genericVisitor.visitStringLiteral(ctx.stringLiteral()));
    }

    @Override
    public Object visitNumericLiteral(GremlinParser.NumericLiteralContext ctx) {
        if (ctx.floatLiteral() != null) {
            return this.visitFloatLiteral(ctx.floatLiteral());
        }
        if (ctx.integerLiteral() != null) {
            return this.visitIntegerLiteral(ctx.integerLiteral());
        }
        throw new GremlinParserException("Invalid numeric");
    }

    @Override
    public Object visitStringLiteral(GremlinParser.StringLiteralContext ctx) {
        return StringEscapeUtils.unescapeJava((String)GenericLiteralVisitor.stripQuotes(ctx.getText()));
    }

    @Override
    public Object visitTraversalT(GremlinParser.TraversalTContext ctx) {
        return TraversalEnumParser.parseTraversalEnumFromContext(T.class, ctx);
    }

    @Override
    public Object visitTraversalTLong(GremlinParser.TraversalTLongContext ctx) {
        return TraversalEnumParser.parseTraversalEnumFromContext(T.class, ctx);
    }

    @Override
    public Object visitTraversalCardinality(GremlinParser.TraversalCardinalityContext ctx) {
        if (null == ctx.LPAREN()) {
            return TraversalEnumParser.parseTraversalEnumFromContext(VertexProperty.Cardinality.class, ctx);
        }
        int idx = ctx.getChildCount() == 6 ? 2 : 0;
        String specifiedCard = ((ParseTree)ctx.children.get(idx)).getText();
        if (ctx.K_SINGLE() != null) {
            return VertexProperty.Cardinality.single(this.visitGenericLiteral(ctx.genericLiteral()));
        }
        if (ctx.K_LIST() != null) {
            return VertexProperty.Cardinality.list(this.visitGenericLiteral(ctx.genericLiteral()));
        }
        if (ctx.K_SET() != null) {
            return VertexProperty.Cardinality.set(this.visitGenericLiteral(ctx.genericLiteral()));
        }
        throw new GremlinParserException(String.format("A Cardinality value not recognized: %s", specifiedCard));
    }

    @Override
    public Object visitTraversalDirection(GremlinParser.TraversalDirectionContext ctx) {
        return TraversalEnumParser.parseTraversalDirectionFromContext(ctx);
    }

    @Override
    public Object visitTraversalDirectionLong(GremlinParser.TraversalDirectionLongContext ctx) {
        return TraversalEnumParser.parseTraversalDirectionFromContext(ctx);
    }

    @Override
    public Object visitTraversalMerge(GremlinParser.TraversalMergeContext ctx) {
        return TraversalEnumParser.parseTraversalEnumFromContext(Merge.class, ctx);
    }

    @Override
    public Object visitTraversalPick(GremlinParser.TraversalPickContext ctx) {
        return TraversalEnumParser.parseTraversalEnumFromContext(Pick.class, ctx);
    }

    @Override
    public Object visitTraversalGType(GremlinParser.TraversalGTypeContext ctx) {
        return TraversalEnumParser.parseTraversalGTypeFromContext(ctx);
    }

    @Override
    public Object visitTraversalStrategy(GremlinParser.TraversalStrategyContext ctx) {
        return this.antlr.traversalStrategyVisitor.visitTraversalStrategy(ctx);
    }

    @Override
    public Object visitGenericRangeLiteral(GremlinParser.GenericRangeLiteralContext ctx) {
        boolean childIndexOfParameterStart = false;
        int childIndexOfParameterEnd = 3;
        ParseTree startContext = ctx.getChild(0);
        ParseTree endContext = ctx.getChild(3);
        if (startContext instanceof GremlinParser.IntegerLiteralContext) {
            int start = Integer.valueOf(startContext.getText());
            int end = Integer.valueOf(endContext.getText());
            return GenericLiteralVisitor.createIntegerRange(start, end, ctx.getText());
        }
        String start = GenericLiteralVisitor.stripQuotes(startContext.getText());
        String end = GenericLiteralVisitor.stripQuotes(endContext.getText());
        return GenericLiteralVisitor.createStringRange(start, end, ctx.getText());
    }

    @Override
    public Object visitNullLiteral(GremlinParser.NullLiteralContext ctx) {
        return null;
    }

    @Override
    public Object visitNanLiteral(GremlinParser.NanLiteralContext ctx) {
        return Double.NaN;
    }

    @Override
    public Object visitInfLiteral(GremlinParser.InfLiteralContext ctx) {
        String infLiteral = ctx.getText();
        return infLiteral.charAt(0) == '-' ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
    }

    @Override
    public Object visitGenericCollectionLiteral(GremlinParser.GenericCollectionLiteralContext ctx) {
        ArrayList<Object> result = new ArrayList<Object>(ctx.getChildCount() / 2);
        for (GremlinParser.GenericLiteralContext ic : ctx.genericLiteral()) {
            result.add(this.antlr.genericVisitor.visitGenericLiteral(ic));
        }
        return result;
    }

    @Override
    public Object visitStringNullableLiteral(GremlinParser.StringNullableLiteralContext ctx) {
        if (ctx.K_NULL() != null) {
            return null;
        }
        return StringEscapeUtils.unescapeJava((String)GenericLiteralVisitor.stripQuotes(ctx.getText()));
    }

    @Override
    public Object[] visitStringNullableLiteralVarargs(GremlinParser.StringNullableLiteralVarargsContext ctx) {
        if (ctx == null) {
            return new Object[0];
        }
        return ctx.children.stream().filter(Objects::nonNull).filter(p -> p instanceof GremlinParser.StringNullableArgumentContext).map(p -> (GremlinParser.StringNullableArgumentContext)p).map(this.antlr.argumentVisitor::visitStringNullableArgument).toArray(Object[]::new);
    }
}

