/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.util.Iterator;
import java.util.Map;
import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.util.resources.Errors;
import org.opengis.util.GenericName;

abstract class FieldType
extends AbstractIdentifiedType {
    private static final long serialVersionUID = 1681767054884098122L;
    private final int minimumOccurs;
    private final int maximumOccurs;

    FieldType(Map<String, ?> identification, int minimumOccurs, int maximumOccurs) {
        super(identification);
        if (minimumOccurs < 0 || maximumOccurs < minimumOccurs) {
            throw new IllegalArgumentException(Errors.format((short)60, minimumOccurs, maximumOccurs));
        }
        this.minimumOccurs = minimumOccurs;
        this.maximumOccurs = maximumOccurs;
    }

    public int getMinimumOccurs() {
        return this.minimumOccurs;
    }

    public int getMaximumOccurs() {
        return this.maximumOccurs;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + 37 * (this.minimumOccurs + 31 * this.maximumOccurs);
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            FieldType that = (FieldType)obj;
            return this.minimumOccurs == that.minimumOccurs && this.maximumOccurs == that.maximumOccurs;
        }
        return false;
    }

    static StringBuilder toString(boolean deprecated, String className, GenericName name, Object valueType) {
        StringBuilder buffer = new StringBuilder(40);
        if (deprecated) {
            buffer.append("Deprecated");
        }
        buffer.append(className).append('[');
        if (name != null) {
            buffer.append('\u201c');
        }
        buffer.append(name);
        if (name != null) {
            buffer.append("\u201d : ");
        }
        return buffer.append(valueType).append(']');
    }

    static StringBuilder toString(boolean deprecated, String className, GenericName name, Object valueType, Iterator<?> values) {
        StringBuilder buffer = FieldType.toString(deprecated, className, name, valueType);
        if (values.hasNext()) {
            Object value = values.next();
            boolean isMultiValued = values.hasNext();
            buffer.append(" = ");
            if (isMultiValued) {
                buffer.append('{');
            }
            buffer.append(value);
            if (isMultiValued) {
                buffer.append(", ").append(values.next());
                if (values.hasNext()) {
                    buffer.append(", ...");
                }
                buffer.append('}');
            }
        }
        return buffer;
    }
}

