/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.batch.fs;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Locale;
import org.apache.tika.batch.FileResource;
import org.apache.tika.batch.fs.FSProperties;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;

public class FSFileResource
implements FileResource {
    private final Path fullPath;
    private final String relativePath;
    private final Metadata metadata;

    public FSFileResource(Path inputRoot, Path fullPath) {
        this.fullPath = fullPath;
        this.metadata = new Metadata();
        assert (fullPath.toAbsolutePath().startsWith(inputRoot.toAbsolutePath()));
        this.relativePath = inputRoot.relativize(fullPath).toString();
        this.metadata.set("resourceName", fullPath.getFileName().toString());
        long sz = -1L;
        try {
            sz = Files.size(fullPath);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.metadata.set("Content-Length", Long.toString(sz));
        this.metadata.set(FSProperties.FS_REL_PATH, this.relativePath);
        this.metadata.set(FileResource.FILE_EXTENSION, this.getExtension(fullPath));
    }

    private String getExtension(Path fullPath) {
        String p = fullPath.getFileName().toString();
        int i = p.lastIndexOf(".");
        if (i > -1) {
            return p.substring(i + 1).toLowerCase(Locale.ROOT);
        }
        return "";
    }

    @Override
    public String getResourceId() {
        return this.relativePath;
    }

    @Override
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    public InputStream openInputStream() throws IOException {
        return TikaInputStream.get(this.fullPath);
    }
}

