/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.json;

import java.io.IOException;
import java.io.Reader;
import java.text.MessageFormat;
import org.apache.tapestry5.json.JSONArray;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.json.exceptions.JSONSyntaxException;

class JSONTokener {
    private final String in;
    private int pos;

    JSONTokener(String in) {
        if (in != null && in.startsWith("\ufeff")) {
            in = in.substring(1);
        }
        this.in = in;
    }

    JSONTokener(Reader input) throws IOException {
        StringBuilder s = new StringBuilder();
        char[] readBuf = new char[102400];
        int n = input.read(readBuf);
        while (n >= 0) {
            s.append(readBuf, 0, n);
            n = input.read(readBuf);
        }
        this.in = s.toString();
        this.pos = 0;
    }

    Object nextValue(Class<?> desiredType) {
        int c = this.nextCleanInternal();
        if (JSONObject.class.equals(desiredType) && c != 123) {
            throw this.syntaxError(MessageFormat.format("A JSONObject text must start with '''{''' (actual: ''{0}'')", Character.toString((char)c)));
        }
        if (JSONArray.class.equals(desiredType) && c != 91) {
            throw this.syntaxError(MessageFormat.format("A JSONArray text must start with ''['' (actual: ''{0}'')", Character.toString((char)c)));
        }
        switch (c) {
            case -1: {
                throw this.syntaxError("End of input");
            }
            case 123: {
                return this.readObject();
            }
            case 91: {
                return this.readArray();
            }
            case 34: 
            case 39: {
                return this.nextString((char)c);
            }
        }
        --this.pos;
        return this.readLiteral();
    }

    private int nextCleanInternal() {
        block9: while (this.pos < this.in.length()) {
            char c = this.in.charAt(this.pos++);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block9;
                }
                case '/': {
                    if (this.pos == this.in.length()) {
                        return c;
                    }
                    char peek = this.in.charAt(this.pos);
                    switch (peek) {
                        case '*': {
                            ++this.pos;
                            int commentEnd = this.in.indexOf("*/", this.pos);
                            if (commentEnd == -1) {
                                this.pos = this.in.length();
                                throw this.syntaxError("Unclosed comment");
                            }
                            this.pos = commentEnd + 2;
                            continue block9;
                        }
                        case '/': {
                            ++this.pos;
                            this.skipToEndOfLine();
                            continue block9;
                        }
                    }
                    return c;
                }
                case '#': {
                    this.skipToEndOfLine();
                    continue block9;
                }
            }
            return c;
        }
        return -1;
    }

    private void skipToEndOfLine() {
        while (this.pos < this.in.length()) {
            char c = this.in.charAt(this.pos);
            if (c == '\r' || c == '\n') {
                ++this.pos;
                break;
            }
            ++this.pos;
        }
    }

    private String nextString(char quote) {
        StringBuilder builder = null;
        int start = this.pos;
        while (this.pos < this.in.length()) {
            char c;
            if ((c = this.in.charAt(this.pos++)) == quote) {
                if (builder == null) {
                    return new String(this.in.substring(start, this.pos - 1));
                }
                builder.append(this.in, start, this.pos - 1);
                return builder.toString();
            }
            if (c != '\\') continue;
            if (this.pos == this.in.length()) {
                throw this.syntaxError("Unterminated escape sequence");
            }
            if (builder == null) {
                builder = new StringBuilder();
            }
            builder.append(this.in, start, this.pos - 1);
            builder.append(this.readEscapeCharacter());
            start = this.pos;
        }
        throw this.syntaxError("Unterminated string");
    }

    private char readEscapeCharacter() {
        char escaped = this.in.charAt(this.pos++);
        switch (escaped) {
            case 'u': {
                if (this.pos + 4 > this.in.length()) {
                    throw this.syntaxError("Unterminated escape sequence");
                }
                String hex = this.in.substring(this.pos, this.pos + 4);
                try {
                    char c = (char)Integer.parseInt(hex, 16);
                    return c;
                }
                catch (NumberFormatException nfe) {
                    throw this.syntaxError("Invalid escape sequence: " + hex);
                }
                finally {
                    this.pos += 4;
                }
            }
            case 'x': {
                if (this.pos + 2 > this.in.length()) {
                    throw this.syntaxError("Unterminated escape sequence");
                }
                String hex = this.in.substring(this.pos, this.pos + 2);
                try {
                    char nfe = (char)Integer.parseInt(hex, 16);
                    return nfe;
                }
                catch (NumberFormatException nfe) {
                    throw this.syntaxError("Invalid escape sequence: " + hex);
                }
                finally {
                    this.pos += 2;
                }
            }
            case 't': {
                return '\t';
            }
            case 'b': {
                return '\b';
            }
            case 'n': {
                return '\n';
            }
            case 'r': {
                return '\r';
            }
            case 'f': {
                return '\f';
            }
        }
        return escaped;
    }

    private Object readLiteral() {
        String literal = this.nextToInternal("{}[]/\\:,=;# \t\f");
        if (literal.length() == 0) {
            throw this.syntaxError("Missing value");
        }
        if ("null".equalsIgnoreCase(literal)) {
            return JSONObject.NULL;
        }
        if ("true".equalsIgnoreCase(literal)) {
            return Boolean.TRUE;
        }
        if ("false".equalsIgnoreCase(literal)) {
            return Boolean.FALSE;
        }
        if (literal.indexOf(46) == -1) {
            int base = 10;
            String number = literal;
            if (number.startsWith("0x") || number.startsWith("0X")) {
                number = number.substring(2);
                base = 16;
            } else if (number.startsWith("0") && number.length() > 1) {
                number = number.substring(1);
                base = 8;
            }
            try {
                long longValue = Long.parseLong(number, base);
                if (longValue <= Integer.MAX_VALUE && longValue >= Integer.MIN_VALUE) {
                    return (int)longValue;
                }
                return longValue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        try {
            return Double.valueOf(literal);
        }
        catch (NumberFormatException numberFormatException) {
            return new String(literal);
        }
    }

    private String nextToInternal(String excluded) {
        int start = this.pos;
        while (this.pos < this.in.length()) {
            char c = this.in.charAt(this.pos);
            if (c == '\r' || c == '\n' || excluded.indexOf(c) != -1) {
                return this.in.substring(start, this.pos);
            }
            ++this.pos;
        }
        return this.in.substring(start);
    }

    private JSONObject readObject() {
        JSONObject result = new JSONObject();
        int first = this.nextCleanInternal();
        if (first == 125) {
            return result;
        }
        if (first != -1) {
            --this.pos;
        }
        block6: while (true) {
            Object name = null;
            try {
                name = this.nextValue(null);
            }
            catch (RuntimeException e) {
                if (e.getMessage().equals("End of input" + this)) {
                    throw this.syntaxError("A JSONObject text must end with '}'");
                }
                throw e;
            }
            if (!(name instanceof String)) {
                if (name == null) {
                    throw this.syntaxError("Names cannot be null");
                }
                throw this.syntaxError("Names must be strings, but " + name + " is of type " + name.getClass().getName());
            }
            int separator = this.nextCleanInternal();
            if (separator != 58 && separator != 61) {
                throw this.syntaxError("Expected a ':' after a key");
            }
            if (this.pos < this.in.length() && this.in.charAt(this.pos) == '>') {
                ++this.pos;
            }
            result.put((String)name, this.nextValue(null));
            switch (this.nextCleanInternal()) {
                case 125: {
                    return result;
                }
                case 44: 
                case 59: {
                    continue block6;
                }
            }
            break;
        }
        throw this.syntaxError("Expected a ',' or '}'");
    }

    private JSONArray readArray() {
        JSONArray result = new JSONArray();
        boolean hasTrailingSeparator = false;
        block9: while (true) {
            switch (this.nextCleanInternal()) {
                case -1: {
                    throw this.syntaxError("Expected a ',' or ']'");
                }
                case 93: {
                    if (hasTrailingSeparator) {
                        // empty if block
                    }
                    return result;
                }
                case 44: 
                case 59: {
                    result.put(JSONObject.NULL);
                    hasTrailingSeparator = true;
                    continue block9;
                }
            }
            --this.pos;
            result.put(this.nextValue(null));
            switch (this.nextCleanInternal()) {
                case 93: {
                    return result;
                }
                case 44: 
                case 59: {
                    hasTrailingSeparator = true;
                    continue block9;
                }
            }
            break;
        }
        throw this.syntaxError("Expected a ',' or ']'");
    }

    private JSONSyntaxException syntaxError(String message) {
        return new JSONSyntaxException(this.pos, message + this);
    }

    public String toString() {
        return " at character " + this.pos + " of " + this.in;
    }
}

