/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.io.IOException;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tapestry5.commons.services.InvalidationEventHub;
import org.apache.tapestry5.internal.services.ComponentDependencyRegistry;
import org.apache.tapestry5.ioc.annotations.ComponentClasses;
import org.apache.tapestry5.services.ComponentEventRequestHandler;
import org.apache.tapestry5.services.ComponentEventRequestParameters;
import org.apache.tapestry5.services.ComponentRequestHandler;
import org.apache.tapestry5.services.PageRenderRequestHandler;
import org.apache.tapestry5.services.PageRenderRequestParameters;
import org.apache.tapestry5.services.Traditional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentRequestHandlerTerminator
implements ComponentRequestHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComponentRequestHandlerTerminator.class);
    private final ComponentEventRequestHandler componentEventRequestHandler;
    private final PageRenderRequestHandler pageRenderRequestHandler;
    private final InvalidationEventHub invalidationEventHub;
    private final ComponentDependencyRegistry componentDependencyRegistry;
    private static final Pattern PATTERN = Pattern.compile("class (\\S+) cannot be cast to class (\\S+).*");

    public ComponentRequestHandlerTerminator(@Traditional ComponentEventRequestHandler componentEventRequestHandler, PageRenderRequestHandler pageRenderRequestHandler, @ComponentClasses InvalidationEventHub invalidationEventHub, ComponentDependencyRegistry componentDependencyRegistry) {
        this.componentEventRequestHandler = componentEventRequestHandler;
        this.pageRenderRequestHandler = pageRenderRequestHandler;
        this.invalidationEventHub = invalidationEventHub;
        this.componentDependencyRegistry = componentDependencyRegistry;
    }

    @Override
    public void handleComponentEvent(ComponentEventRequestParameters parameters) throws IOException {
        boolean retry = this.run(() -> this.componentEventRequestHandler.handle(parameters));
        if (retry) {
            this.componentEventRequestHandler.handle(parameters);
        }
    }

    @Override
    public void handlePageRender(PageRenderRequestParameters parameters) throws IOException {
        boolean retry = this.run(() -> this.pageRenderRequestHandler.handle(parameters));
        if (retry) {
            this.pageRenderRequestHandler.handle(parameters);
        }
    }

    private boolean run(RunnableWithIOException runnable) throws IOException {
        boolean retry = false;
        try {
            runnable.run();
        }
        catch (RuntimeException e) {
            Throwable throwable = e;
            while (!(throwable instanceof ClassCastException) && throwable.getCause() != null) {
                throwable = throwable.getCause();
            }
            if (throwable instanceof ClassCastException && throwable != null) {
                Matcher matcher = PATTERN.matcher(throwable.getMessage());
                if (matcher.matches() && matcher.groupCount() >= 2 && this.isTransformed(matcher.group(1)) && this.isTransformed(matcher.group(2))) {
                    LOGGER.warn("Caught exception and trying to recover by invalidating generated classes caches: {}", (Object)throwable.getMessage());
                    this.componentDependencyRegistry.disableInvalidations();
                    this.invalidationEventHub.fireInvalidationEvent(Collections.emptyList());
                    this.componentDependencyRegistry.enableInvalidations();
                    retry = true;
                }
            }
            throw e;
        }
        return retry;
    }

    private boolean isTransformed(String className) {
        return className != null && (className.contains(".pages.") || className.contains(".components.") || className.contains(".base."));
    }

    private static interface RunnableWithIOException {
        public void run() throws IOException;
    }
}

