/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.corelib.components;

import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.commons.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.ajax.AjaxResponseRenderer;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;

public class Graphviz {
    @Parameter(required=true, allowNull=false)
    @Property
    private String value;
    @Parameter(defaultPrefix="literal", value="false")
    private boolean showDownloadLink;
    @Parameter(defaultPrefix="literal", value="false")
    private boolean showSource;
    @Environmental
    private JavaScriptSupport javaScriptSupport;
    @Inject
    private AjaxResponseRenderer ajaxResponseRenderer;
    @Inject
    private ComponentResources resources;
    @Inject
    private Messages messages;
    private String cachedValue;

    void setupRender(MarkupWriter writer) {
        this.cachedValue = this.value;
        String elementName = this.resources.getElementName();
        if (elementName == null) {
            elementName = "div";
        }
        String id = this.javaScriptSupport.allocateClientId(this.resources);
        writer.element(elementName, "id", id);
        writer.end();
        this.javaScriptSupport.require("t5/core/graphviz").with(this.cachedValue, id, this.showDownloadLink);
        if (this.showDownloadLink) {
            writer.element("a", "href", "#", "id", id + "-download", "download", id + ".svg");
            writer.write(this.messages.get("download-graphviz-image"));
            writer.end();
        }
        if (this.showSource) {
            writer.element("pre", "id", id + "-source");
            writer.write(this.cachedValue);
            writer.end();
        }
    }
}

