/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.translator;

import java.text.ParseException;
import org.apache.tapestry5.Field;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.ValidationException;
import org.apache.tapestry5.internal.translator.AbstractTranslator;
import org.apache.tapestry5.internal.translator.NumericTranslatorSupport;
import org.apache.tapestry5.services.FormSupport;
import org.apache.tapestry5.services.Html5Support;

public class NumericTranslator<T extends Number>
extends AbstractTranslator<T> {
    private final NumericTranslatorSupport support;
    private final Html5Support html5Support;

    public NumericTranslator(String name, Class<T> type, NumericTranslatorSupport support, Html5Support html5Support) {
        super(name, type, support.getMessageKey(type));
        this.support = support;
        this.html5Support = html5Support;
    }

    @Override
    public void render(Field field, String message, MarkupWriter writer, FormSupport formSupport) {
        if (formSupport.isClientValidationEnabled()) {
            this.support.setupTranslation(this.getType(), writer.getElement(), message);
        }
        if (this.html5Support.isHtml5SupportEnabled()) {
            writer.getElement().forceAttributes("type", "number");
        }
    }

    @Override
    public T parseClient(Field field, String clientValue, String message) throws ValidationException {
        try {
            return this.support.parseClient(this.getType(), clientValue);
        }
        catch (ParseException ex) {
            throw new ValidationException(message);
        }
    }

    @Override
    public String toClient(T value) {
        return this.support.toClient(this.getType(), value);
    }
}

