// Copyright 2010 The Apache Software Foundation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package org.apache.tapestry5.ioc.internal.services;

import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.ElementType.TYPE;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

@Target({ TYPE, METHOD })
@Retention(RUNTIME)
@Documented
public @interface TestAnnotation
{

    TestAnnotation2[] annotationValue();

    String[] arrayValue() default { "foo", "bar" };

    boolean booleanValue();

    byte byteValue();

    char charValue();

    Class classValue();

    double doubleValue();

    Color enumValue();

    float floatValue();

    int intValue();

    long longValue();

    short shortValue();

    String stringValue();
    
    public enum Color
    {
        RED, GREEN, BLUE
    }
    
    @Target({ TYPE, METHOD })
    @Retention(RUNTIME)
    @Documented
    public @interface TestAnnotation2
    {
        Color[] colors();
    }
}
