// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package org.apache.tapestry5.internal.bindings;

import org.apache.tapestry5.Binding;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.PropertyConduit;
import org.apache.tapestry5.internal.services.StringInterner;
import org.apache.tapestry5.ioc.Location;
import org.apache.tapestry5.services.BindingFactory;
import org.apache.tapestry5.services.PropertyConduitSource;

/**
 * Binding factory for reading and updating JavaBean properties.
 *
 * Expression are evaluated via a {@link PropertyConduit}, which is generated by {@link PropertyConduitSource} (which
 * therefore defines the expression language).
 */
public class PropBindingFactory implements BindingFactory
{
    private final PropertyConduitSource source;

    private final StringInterner interner;

    public PropBindingFactory(PropertyConduitSource propertyConduitSource, StringInterner interner)
    {
        source = propertyConduitSource;
        this.interner = interner;
    }

    public Binding newBinding(String description, ComponentResources container,
                              ComponentResources component, String expression, Location location)
    {
        Object target = container.getComponent();
        Class targetClass = target.getClass();

        PropertyConduit conduit = source.create(targetClass, expression);

        String toString = interner.format("PropBinding[%s %s(%s)]", description, container
                .getCompleteId(), expression);

        return new PropBinding(location, target, conduit, expression, toString);
    }
}
