/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.util;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class LockSupport {
    private final Lock readLock;
    private final Lock writeLock;

    protected LockSupport() {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
    }

    protected final void acquireReadLock() {
        this.readLock.lock();
    }

    protected final void takeWriteLock() {
        this.writeLock.lock();
    }

    protected final void releaseReadLock() {
        this.readLock.unlock();
    }

    protected final void releaseWriteLock() {
        this.writeLock.unlock();
    }

    protected final void upgradeReadLockToWriteLock() {
        this.releaseReadLock();
        this.takeWriteLock();
    }

    protected final void downgradeWriteLockToReadLock() {
        this.acquireReadLock();
        this.releaseWriteLock();
    }
}

