/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.def.ContributionDef;
import org.apache.tapestry5.ioc.def.ContributionDef2;
import org.apache.tapestry5.ioc.def.ServiceDef;
import org.apache.tapestry5.ioc.def.ServiceDef2;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.internal.util.MessagesImpl;
import org.apache.tapestry5.plastic.PlasticUtils;

final class IOCMessages {
    private static final Messages MESSAGES = MessagesImpl.forClass(IOCMessages.class);

    IOCMessages() {
    }

    static String buildMethodConflict(String serviceId, String conflict, String existing) {
        return MESSAGES.format("build-method-conflict", new Object[]{serviceId, conflict, existing});
    }

    static String serviceWrongInterface(String serviceId, Class actualInterface, Class requestedInterface) {
        return MESSAGES.format("service-wrong-interface", new Object[]{serviceId, actualInterface.getName(), requestedInterface.getName()});
    }

    static String instantiateBuilderError(Class builderClass, Throwable cause) {
        return MESSAGES.format("instantiate-builder-error", new Object[]{builderClass.getName(), cause});
    }

    static String noServiceMatchesType(Class serviceInterface) {
        return MESSAGES.format("no-service-matches-type", new Object[]{serviceInterface.getName()});
    }

    static String manyServiceMatches(Class serviceInterface, List<String> ids) {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < ids.size(); ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(ids.get(i));
        }
        return MESSAGES.format("many-service-matches", new Object[]{serviceInterface.getName(), ids.size(), buffer.toString()});
    }

    static String unknownScope(String name) {
        return MESSAGES.format("unknown-scope", new Object[]{name});
    }

    static String decoratorReturnedWrongType(Method method, String serviceId, Object returned, Class serviceInterface) {
        return MESSAGES.format("decorator-returned-wrong-type", new Object[]{InternalUtils.asString(method), serviceId, returned, serviceInterface.getName()});
    }

    static String recursiveServiceBuild(ServiceDef def) {
        return MESSAGES.format("recursive-service-build", new Object[]{def.getServiceId(), def.toString()});
    }

    static String contributionWrongReturnType(Method method) {
        return MESSAGES.format("contribution-wrong-return-type", new Object[]{InternalUtils.asString(method), PlasticUtils.toTypeName(method.getReturnType())});
    }

    static String tooManyContributionParameters(Method method) {
        return MESSAGES.format("too-many-contribution-parameters", new Object[]{InternalUtils.asString(method)});
    }

    static String noContributionParameter(Method method) {
        return MESSAGES.format("no-contribution-parameter", new Object[]{InternalUtils.asString(method)});
    }

    static String contributionMethodError(Method method, Throwable cause) {
        return MESSAGES.format("contribution-method-error", new Object[]{InternalUtils.asString(method), cause});
    }

    static String contributionWasNull(String serviceId) {
        return MESSAGES.format("contribution-was-null", new Object[]{serviceId});
    }

    static String contributionKeyWasNull(String serviceId) {
        return MESSAGES.format("contribution-key-was-null", new Object[]{serviceId});
    }

    static String contributionWrongKeyType(String serviceId, Class actualClass, Class expectedClass) {
        return MESSAGES.format("contribution-wrong-key-type", new Object[]{serviceId, actualClass.getName(), expectedClass.getName()});
    }

    static String tooManyConfigurationParameters(String methodId) {
        return MESSAGES.format("too-many-configuration-parameters", new Object[]{methodId});
    }

    static String genericTypeNotSupported(Type type) {
        return MESSAGES.format("generic-type-not-supported", new Object[]{type});
    }

    static String contributionDuplicateKey(String serviceId, Object key, ContributionDef existingDef) {
        return MESSAGES.format("contribution-duplicate-key", new Object[]{serviceId, key, existingDef});
    }

    static String errorBuildingService(String serviceId, ServiceDef serviceDef, Throwable cause) {
        return MESSAGES.format("error-building-service", new Object[]{serviceId, serviceDef, cause});
    }

    static String noPublicConstructors(Class moduleClass) {
        return MESSAGES.format("no-public-constructors", new Object[]{moduleClass.getName()});
    }

    static String tooManyPublicConstructors(Class moduleClass, Constructor constructor) {
        return MESSAGES.format("too-many-public-constructors", new Object[]{moduleClass.getName(), constructor});
    }

    static String recursiveModuleConstructor(Class builderClass, Constructor constructor) {
        return MESSAGES.format("recursive-module-constructor", new Object[]{builderClass.getName(), constructor});
    }

    static String constructedConfiguration(Collection result) {
        return MESSAGES.format("constructed-configuration", new Object[]{result});
    }

    static String constructedConfiguration(Map result) {
        return MESSAGES.format("constructed-configuration", new Object[]{result});
    }

    static String serviceConstructionFailed(ServiceDef serviceDef, Throwable cause) {
        return MESSAGES.format("service-construction-failed", new Object[]{serviceDef.getServiceId(), cause});
    }

    static String serviceIdConflict(String serviceId, ServiceDef existing, ServiceDef conflicting) {
        return MESSAGES.format("service-id-conflict", new Object[]{serviceId, existing, conflicting});
    }

    static String noConstructor(Class implementationClass, String serviceId) {
        return MESSAGES.format("no-constructor", new Object[]{implementationClass.getName(), serviceId});
    }

    static String abstractServiceImplementation(Class implementationClass, String serviceId) {
        return MESSAGES.format("abstract-service-implementation", new Object[]{implementationClass.getName(), serviceId});
    }

    static String bindMethodMustBeStatic(String methodId) {
        return MESSAGES.format("bind-method-must-be-static", new Object[]{methodId});
    }

    static String errorInBindMethod(String methodId, Throwable cause) {
        return MESSAGES.format("error-in-bind-method", new Object[]{methodId, cause});
    }

    static String noAutobuildConstructor(Class clazz) {
        return MESSAGES.format("no-autobuild-constructor", new Object[]{clazz.getName()});
    }

    private static String toJavaClassNames(List<Class> classes) {
        Class[] asArray = classes.toArray(new Class[classes.size()]);
        Object[] namesArray = PlasticUtils.toTypeNames((Class[])asArray);
        List names = CollectionFactory.newList((Object[])namesArray);
        return InternalUtils.joinSorted(names);
    }

    static String noServicesMatchMarker(Class objectType, List<Class> markers) {
        return MESSAGES.format("no-services-match-marker", new Object[]{PlasticUtils.toTypeName((Class)objectType), IOCMessages.toJavaClassNames(markers)});
    }

    static String manyServicesMatchMarker(Class objectType, List<Class> markers, Collection<ServiceDef2> matchingServices) {
        return MESSAGES.format("many-services-match-marker", new Object[]{PlasticUtils.toTypeName((Class)objectType), IOCMessages.toJavaClassNames(markers), InternalUtils.joinSorted(matchingServices)});
    }

    static String overlappingServiceProxyProviders() {
        return MESSAGES.get("overlapping-service-proxy-providers");
    }

    static String unexpectedServiceProxyProvider() {
        return MESSAGES.get("unexpected-service-proxy-provider");
    }

    static String noProxyProvider(String serviceId) {
        return MESSAGES.format("no-proxy-provider", new Object[]{serviceId});
    }

    static String contributionForNonexistentService(ContributionDef cd) {
        return MESSAGES.format("contribution-for-nonexistent-service", new Object[]{cd, cd.getServiceId()});
    }

    static String contributionForUnqualifiedService(ContributionDef2 cd) {
        return MESSAGES.format("contribution-for-unqualified-service", new Object[]{cd, cd.getServiceInterface(), cd.getMarkers()});
    }
}

