/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.matrix.data;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.math3.exception.MaxCountExceededException;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.BlockRealMatrix;
import org.apache.commons.math3.linear.CholeskyDecomposition;
import org.apache.commons.math3.linear.DecompositionSolver;
import org.apache.commons.math3.linear.EigenDecomposition;
import org.apache.commons.math3.linear.LUDecomposition;
import org.apache.commons.math3.linear.QRDecomposition;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.SingularValueDecomposition;
import org.apache.sysds.common.Opcodes;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.codegen.CodegenUtils;
import org.apache.sysds.runtime.codegen.SpoofOperator;
import org.apache.sysds.runtime.compress.utils.IntArrayList;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.functionobjects.Builtin;
import org.apache.sysds.runtime.functionobjects.Divide;
import org.apache.sysds.runtime.functionobjects.MinusMultiply;
import org.apache.sysds.runtime.functionobjects.Multiply;
import org.apache.sysds.runtime.functionobjects.SwapIndex;
import org.apache.sysds.runtime.functionobjects.ValueFunction;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.matrix.data.LibMatrixFourier;
import org.apache.sysds.runtime.matrix.data.LibMatrixReorg;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.operators.AggregateBinaryOperator;
import org.apache.sysds.runtime.matrix.operators.BinaryOperator;
import org.apache.sysds.runtime.matrix.operators.LeftScalarOperator;
import org.apache.sysds.runtime.matrix.operators.ReorgOperator;
import org.apache.sysds.runtime.matrix.operators.RightScalarOperator;
import org.apache.sysds.runtime.matrix.operators.ScalarOperator;
import org.apache.sysds.runtime.matrix.operators.TernaryOperator;
import org.apache.sysds.runtime.matrix.operators.UnaryOperator;
import org.apache.sysds.runtime.util.DataConverter;
import org.apache.sysds.runtime.util.UtilFunctions;

public class LibCommonsMath {
    private static final Log LOG = LogFactory.getLog((String)LibCommonsMath.class.getName());
    private static final double RELATIVE_SYMMETRY_THRESHOLD = 1.0E-6;
    private static final double EIGEN_LAMBDA = 1.0E-8;

    private LibCommonsMath() {
    }

    public static boolean isSupportedUnaryOperation(String opcode) {
        return opcode.equals(Opcodes.INVERSE.toString()) || opcode.equals(Opcodes.CHOLESKY.toString()) || opcode.equals(Opcodes.DET.toString()) || opcode.equals(Opcodes.SQRT_MATRIX_JAVA.toString());
    }

    public static boolean isSupportedMultiReturnOperation(String opcode) {
        switch (opcode) {
            case "eigen": 
            case "fft": 
            case "fft_linearized": 
            case "ifft": 
            case "ifft_linearized": 
            case "lu": 
            case "qr": 
            case "rcm": 
            case "stft": 
            case "svd": {
                return true;
            }
        }
        return false;
    }

    public static boolean isSupportedMatrixMatrixOperation(String opcode) {
        return opcode.equals(Opcodes.SOLVE.toString());
    }

    public static MatrixBlock unaryOperations(MatrixBlock inj, String opcode) {
        if (opcode.equals(Opcodes.SQRT_MATRIX_JAVA.toString())) {
            return LibCommonsMath.computeSqrt(inj);
        }
        Array2DRowRealMatrix matrixInput = DataConverter.convertToArray2DRowRealMatrix(inj);
        if (opcode.equals(Opcodes.INVERSE.toString())) {
            return LibCommonsMath.computeMatrixInverse(matrixInput);
        }
        if (opcode.equals(Opcodes.CHOLESKY.toString())) {
            return LibCommonsMath.computeCholesky(matrixInput);
        }
        if (opcode.equals(Opcodes.DET.toString())) {
            return LibCommonsMath.computeDeterminant(matrixInput);
        }
        return null;
    }

    public static MatrixBlock[] multiReturnOperations(MatrixBlock in, String opcode, int threads) {
        return LibCommonsMath.multiReturnOperations(in, opcode, threads, 1L);
    }

    public static MatrixBlock[] multiReturnOperations(MatrixBlock in1, MatrixBlock in2, String opcode) {
        return LibCommonsMath.multiReturnOperations(in1, in2, opcode, 1, 1L);
    }

    public static MatrixBlock[] multiReturnOperations(MatrixBlock in, String opcode, int threads, int num_iterations, double tol) {
        if (opcode.equals("eigen_qr")) {
            return LibCommonsMath.computeEigenQR(in, num_iterations, tol, threads);
        }
        return LibCommonsMath.multiReturnOperations(in, opcode, threads, 1L);
    }

    public static MatrixBlock[] multiReturnOperations(MatrixBlock in, String opcode, int threads, long seed) {
        if (opcode.equals(Opcodes.QR.toString())) {
            return LibCommonsMath.computeQR(in);
        }
        if (opcode.equals("qr2")) {
            return LibCommonsMath.computeQR2(in, threads);
        }
        if (opcode.equals(Opcodes.LU.toString())) {
            return LibCommonsMath.computeLU(in);
        }
        if (opcode.equals(Opcodes.EIGEN.toString())) {
            return LibCommonsMath.computeEigen(in);
        }
        if (opcode.equals("eigen_lanczos")) {
            return LibCommonsMath.computeEigenLanczos(in, threads, seed);
        }
        if (opcode.equals("eigen_qr")) {
            return LibCommonsMath.computeEigenQR(in, threads);
        }
        if (opcode.equals(Opcodes.SVD.toString())) {
            return LibCommonsMath.computeSvd(in);
        }
        if (opcode.equals(Opcodes.FFT.toString())) {
            return LibCommonsMath.computeFFT(in, threads);
        }
        if (opcode.equals(Opcodes.IFFT.toString())) {
            return LibCommonsMath.computeIFFT(in, threads);
        }
        if (opcode.equals(Opcodes.FFT_LINEARIZED.toString())) {
            return LibCommonsMath.computeFFT_LINEARIZED(in, threads);
        }
        if (opcode.equals(Opcodes.IFFT_LINEARIZED.toString())) {
            return LibCommonsMath.computeIFFT_LINEARIZED(in, threads);
        }
        return null;
    }

    public static MatrixBlock[] multiReturnOperations(MatrixBlock in1, MatrixBlock in2, String opcode, int threads, long seed) {
        switch (opcode) {
            case "ifft": {
                return LibCommonsMath.computeIFFT(in1, in2, threads);
            }
            case "ifft_linearized": {
                return LibCommonsMath.computeIFFT_LINEARIZED(in1, in2, threads);
            }
            case "rcm": {
                return LibCommonsMath.computeRCM(in1, in2);
            }
        }
        return null;
    }

    public static MatrixBlock matrixMatrixOperations(MatrixBlock in1, MatrixBlock in2, String opcode) {
        if (opcode.equals(Opcodes.SOLVE.toString())) {
            if (in1.getNumRows() != in1.getNumColumns()) {
                throw new DMLRuntimeException("The A matrix, in solve(A,b) should have squared dimensions.");
            }
            return LibCommonsMath.computeSolve(in1, in2);
        }
        return null;
    }

    private static MatrixBlock computeSolve(MatrixBlock in1, MatrixBlock in2) {
        BlockRealMatrix matrixInput = DataConverter.convertToBlockRealMatrix(in1);
        BlockRealMatrix vectorInput = DataConverter.convertToBlockRealMatrix(in2);
        QRDecomposition qrdecompose = new QRDecomposition((RealMatrix)matrixInput);
        DecompositionSolver solver = qrdecompose.getSolver();
        RealMatrix solutionMatrix = solver.solve((RealMatrix)vectorInput);
        return DataConverter.convertToMatrixBlock(solutionMatrix);
    }

    private static MatrixBlock[] computeQR(MatrixBlock in) {
        Array2DRowRealMatrix matrixInput = DataConverter.convertToArray2DRowRealMatrix(in);
        QRDecomposition qrdecompose = new QRDecomposition((RealMatrix)matrixInput);
        RealMatrix H = qrdecompose.getH();
        RealMatrix R = qrdecompose.getR();
        MatrixBlock mbH = DataConverter.convertToMatrixBlock(H.getData());
        MatrixBlock mbR = DataConverter.convertToMatrixBlock(R.getData());
        return new MatrixBlock[]{mbH, mbR};
    }

    private static MatrixBlock[] computeLU(MatrixBlock in) {
        if (in.getNumRows() != in.getNumColumns()) {
            throw new DMLRuntimeException("LU Decomposition can only be done on a square matrix. Input matrix is rectangular (rows=" + in.getNumRows() + ", cols=" + in.getNumColumns() + ")");
        }
        Array2DRowRealMatrix matrixInput = DataConverter.convertToArray2DRowRealMatrix(in);
        LUDecomposition ludecompose = new LUDecomposition((RealMatrix)matrixInput);
        if (ludecompose.getDeterminant() == 0.0) {
            throw new DMLRuntimeException("LU Decomposition can only be done on a non-singular matrix.");
        }
        RealMatrix P2 = ludecompose.getP();
        RealMatrix L = ludecompose.getL();
        RealMatrix U = ludecompose.getU();
        MatrixBlock mbP = DataConverter.convertToMatrixBlock(P2.getData());
        MatrixBlock mbL = DataConverter.convertToMatrixBlock(L.getData());
        MatrixBlock mbU = DataConverter.convertToMatrixBlock(U.getData());
        return new MatrixBlock[]{mbP, mbL, mbU};
    }

    private static MatrixBlock[] computeEigen(MatrixBlock in) {
        if (in.getNumRows() != in.getNumColumns()) {
            throw new DMLRuntimeException("Eigen Decomposition can only be done on a square matrix. Input matrix is rectangular (rows=" + in.getNumRows() + ", cols=" + in.getNumColumns() + ")");
        }
        EigenDecomposition eigendecompose = null;
        try {
            Array2DRowRealMatrix matrixInput = DataConverter.convertToArray2DRowRealMatrix(in);
            eigendecompose = new EigenDecomposition((RealMatrix)matrixInput);
        }
        catch (MaxCountExceededException ex) {
            LOG.warn((Object)("Eigen: " + ex.getMessage() + ". Falling back to regularized eigen factorization."));
            eigendecompose = LibCommonsMath.computeEigenRegularized(in);
        }
        RealMatrix eVectorsMatrix = eigendecompose.getV();
        double[][] eVectors = eVectorsMatrix.getData();
        double[] eValues = eigendecompose.getRealEigenvalues();
        return LibCommonsMath.sortEVs(eValues, eVectors);
    }

    private static EigenDecomposition computeEigenRegularized(MatrixBlock in) {
        if (in == null || in.isEmptyBlock(false)) {
            throw new DMLRuntimeException("Invalid empty block");
        }
        MatrixBlock in2 = new MatrixBlock(in, false);
        DenseBlock a = in2.getDenseBlock();
        for (int i = 0; i < in2.rlen; ++i) {
            double[] avals = a.values(i);
            int apos = a.pos(i);
            for (int j = 0; j < in2.clen; ++j) {
                double v = avals[apos + j];
                int n = apos + j;
                avals[n] = avals[n] + Math.signum(v) * 1.0E-8;
            }
        }
        return new EigenDecomposition((RealMatrix)DataConverter.convertToArray2DRowRealMatrix(in2));
    }

    private static MatrixBlock[] computeFFT(MatrixBlock re, int threads) {
        if (re == null) {
            throw new DMLRuntimeException("Invalid empty block");
        }
        if (re.isEmptyBlock(false)) {
            return new MatrixBlock[]{re, new MatrixBlock(re.getNumRows(), re.getNumColumns(), true)};
        }
        re.sparseToDense();
        return LibMatrixFourier.fft(re, threads);
    }

    private static MatrixBlock[] computeIFFT(MatrixBlock re, MatrixBlock im, int threads) {
        if (re == null) {
            throw new DMLRuntimeException("Invalid empty block");
        }
        if (im != null && !im.isEmptyBlock(false)) {
            re.sparseToDense();
            im.sparseToDense();
            return LibMatrixFourier.ifft(re, im, threads);
        }
        if (re.isEmptyBlock(false)) {
            return new MatrixBlock[]{re, new MatrixBlock(re.getNumRows(), re.getNumColumns(), true)};
        }
        re.sparseToDense();
        return LibMatrixFourier.ifft(re, threads);
    }

    private static MatrixBlock[] computeIFFT(MatrixBlock re, int threads) {
        return LibCommonsMath.computeIFFT(re, null, threads);
    }

    private static MatrixBlock[] computeFFT_LINEARIZED(MatrixBlock re, int threads) {
        if (re == null) {
            throw new DMLRuntimeException("Invalid empty block");
        }
        if (re.isEmptyBlock(false)) {
            return new MatrixBlock[]{re, new MatrixBlock(re.getNumRows(), re.getNumColumns(), true)};
        }
        re.sparseToDense();
        return LibMatrixFourier.fft_linearized(re, threads);
    }

    private static MatrixBlock[] computeIFFT_LINEARIZED(MatrixBlock re, MatrixBlock im, int threads) {
        if (re == null) {
            throw new DMLRuntimeException("Invalid empty block");
        }
        if (im != null && !im.isEmptyBlock(false)) {
            re.sparseToDense();
            im.sparseToDense();
            return LibMatrixFourier.ifft_linearized(re, im, threads);
        }
        if (re.isEmptyBlock(false)) {
            return new MatrixBlock[]{re, new MatrixBlock(re.getNumRows(), re.getNumColumns(), true)};
        }
        re.sparseToDense();
        return LibMatrixFourier.ifft_linearized(re, threads);
    }

    private static MatrixBlock[] computeIFFT_LINEARIZED(MatrixBlock re, int threads) {
        return LibCommonsMath.computeIFFT_LINEARIZED(re, null, threads);
    }

    private static MatrixBlock[] computeSvd(MatrixBlock in) {
        Array2DRowRealMatrix matrixInput = DataConverter.convertToArray2DRowRealMatrix(in);
        SingularValueDecomposition svd = new SingularValueDecomposition((RealMatrix)matrixInput);
        double[] sigma = svd.getSingularValues();
        RealMatrix u = svd.getU();
        RealMatrix v = svd.getV();
        MatrixBlock U = DataConverter.convertToMatrixBlock(u.getData());
        MatrixBlock Sigma = DataConverter.convertToMatrixBlock(sigma, true);
        Sigma = LibMatrixReorg.diag(Sigma, new MatrixBlock(Sigma.rlen, Sigma.rlen, true));
        MatrixBlock V = DataConverter.convertToMatrixBlock(v.getData());
        return new MatrixBlock[]{U, Sigma, V};
    }

    private static MatrixBlock computeSqrt(MatrixBlock in) {
        Array2DRowRealMatrix matrixInput = DataConverter.convertToArray2DRowRealMatrix(in);
        EigenDecomposition ed = new EigenDecomposition((RealMatrix)matrixInput);
        return DataConverter.convertToMatrixBlock(ed.getSquareRoot());
    }

    private static MatrixBlock computeMatrixInverse(Array2DRowRealMatrix in) {
        if (!in.isSquare()) {
            throw new DMLRuntimeException("Input to inv() must be square matrix -- given: a " + in.getRowDimension() + "x" + in.getColumnDimension() + " matrix.");
        }
        QRDecomposition qrdecompose = new QRDecomposition((RealMatrix)in);
        DecompositionSolver solver = qrdecompose.getSolver();
        RealMatrix inverseMatrix = solver.getInverse();
        return DataConverter.convertToMatrixBlock(inverseMatrix.getData());
    }

    private static MatrixBlock computeCholesky(Array2DRowRealMatrix in) {
        if (!in.isSquare()) {
            throw new DMLRuntimeException("Input to cholesky() must be square matrix -- given: a " + in.getRowDimension() + "x" + in.getColumnDimension() + " matrix.");
        }
        CholeskyDecomposition cholesky = new CholeskyDecomposition((RealMatrix)in, 1.0E-6, 1.0E-10);
        RealMatrix rmL = cholesky.getL();
        return DataConverter.convertToMatrixBlock(rmL.getData());
    }

    private static MatrixBlock computeDeterminant(Array2DRowRealMatrix in) {
        if (!in.isSquare()) {
            throw new DMLRuntimeException("Determinant can only be computed for a square matrix. Input matrix is rectangular");
        }
        boolean useBuiltinStrategy = false;
        boolean useGaussianStrategy = true;
        int useBareissStrategy = 2;
        int useLaplaceStrategy = 3;
        int computationStrategy = 0;
        double determinant = 0.0;
        switch (computationStrategy) {
            case 1: {
                determinant = LibCommonsMath.computeDetGaussian(in);
                break;
            }
            case 3: {
                determinant = LibCommonsMath.computeDetLaplace(in);
                break;
            }
            case 2: {
                determinant = LibCommonsMath.computeDetBareiss(in);
                break;
            }
            default: {
                LUDecomposition ludecompose = new LUDecomposition((RealMatrix)in);
                determinant = ludecompose.getDeterminant();
            }
        }
        MatrixBlock determinantResult = new MatrixBlock(1, 1, false);
        determinantResult.set(0, 0, determinant);
        return determinantResult;
    }

    private static double computeDetGaussian(Array2DRowRealMatrix in) {
        double[][] matrix = in.getData();
        int size = in.getRowDimension();
        double determinant = 1.0;
        int swapCount = 0;
        for (int pivotRow = 0; pivotRow < size; ++pivotRow) {
            boolean nonZeroPivotFound = false;
            for (int swapRow = pivotRow; swapRow < size; ++swapRow) {
                if (!(Math.abs(matrix[swapRow][pivotRow]) > 1.0E-9)) continue;
                if (swapRow != pivotRow) {
                    double[] tempRow = matrix[swapRow];
                    matrix[swapRow] = matrix[pivotRow];
                    matrix[pivotRow] = tempRow;
                    ++swapCount;
                }
                nonZeroPivotFound = true;
                break;
            }
            if (!nonZeroPivotFound) {
                determinant = 0.0;
                break;
            }
            for (int row = pivotRow + 1; row < size; ++row) {
                double factor = matrix[row][pivotRow] / matrix[pivotRow][pivotRow];
                for (int col = pivotRow; col < size; ++col) {
                    matrix[row][col] = matrix[row][col] - factor * matrix[pivotRow][col];
                }
            }
        }
        for (int i = 0; i < size; ++i) {
            determinant *= matrix[i][i];
        }
        if (swapCount % 2 != 0) {
            determinant = -determinant;
        }
        return determinant;
    }

    private static double computeDetLaplace(Array2DRowRealMatrix in) {
        int length = in.getRowDimension();
        double determinant = 0.0;
        if (length == 2) {
            return in.getEntry(0, 0) * in.getEntry(1, 1) - in.getEntry(0, 1) * in.getEntry(1, 0);
        }
        for (int col = 0; col < length; ++col) {
            if (in.getEntry(0, col) == 0.0) continue;
            Array2DRowRealMatrix subMatrix = new Array2DRowRealMatrix(length - 1, length - 1);
            for (int i = 1; i < length; ++i) {
                int subCol = 0;
                for (int j = 0; j < length; ++j) {
                    if (j == col) continue;
                    subMatrix.setEntry(i - 1, subCol, in.getEntry(i, j));
                    ++subCol;
                }
            }
            int sign = col % 2 == 0 ? 1 : -1;
            double subDeterminant = LibCommonsMath.computeDeterminant(subMatrix).get(0, 0);
            determinant += (double)sign * in.getEntry(0, col) * subDeterminant;
        }
        return determinant;
    }

    private static double computeDetBareiss(Array2DRowRealMatrix in) {
        int n = in.getRowDimension();
        int sign = 1;
        for (int k = 0; k < n - 1; ++k) {
            if (0.0 == in.getEntry(k, k)) {
                boolean found = false;
                for (int m = k + 1; m < n; ++m) {
                    if (0.0 == in.getEntry(m, k)) continue;
                    found = true;
                    sign = -1 * sign;
                    double[] tmp = in.getRow(m);
                    in.setRow(m, in.getRow(k));
                    in.setRow(k, tmp);
                    break;
                }
                if (!found) {
                    in.getEntry(n - 1, n - 1);
                    break;
                }
            }
            for (int i = k + 1; i < n; ++i) {
                for (int j = k + 1; j < n; ++j) {
                    double den = 0 == k ? 1.0 : in.getEntry(k - 1, k - 1);
                    double num = in.getEntry(i, j) * in.getEntry(k, k) - in.getEntry(i, k) * in.getEntry(k, j);
                    in.setEntry(i, j, num / den);
                }
            }
        }
        return (double)sign * in.getEntry(n - 1, n - 1);
    }

    private static MatrixBlock randNormalizedVect(int dim, int threads, long seed) {
        MatrixBlock v1 = MatrixBlock.randOperations(dim, 1, 1.0, 0.0, 1.0, "UNIFORM", seed);
        double v1_sum = v1.sum();
        RightScalarOperator op_div_scalar = new RightScalarOperator((ValueFunction)Divide.getDivideFnObject(), v1_sum, threads);
        v1 = v1.scalarOperations(op_div_scalar, new MatrixBlock());
        UnaryOperator op_sqrt = new UnaryOperator(Builtin.getBuiltinFnObject(Builtin.BuiltinCode.SQRT), threads, true);
        if (Math.abs((v1 = v1.unaryOperations(op_sqrt, new MatrixBlock())).sumSq() - 1.0) >= 1.0E-7) {
            throw new DMLRuntimeException("v1 not correctly normalized (maybe try changing the seed)");
        }
        return v1;
    }

    private static MatrixBlock[] computeEigenLanczos(MatrixBlock in, int threads, long seed) {
        if (in.getNumRows() != in.getNumColumns()) {
            throw new DMLRuntimeException("Lanczos algorithm and Eigen Decomposition can only be done on a square matrix. Input matrix is rectangular (rows=" + in.getNumRows() + ", cols=" + in.getNumColumns() + ")");
        }
        int m = in.getNumRows();
        MatrixBlock v0 = new MatrixBlock(m, 1, 0.0);
        MatrixBlock v1 = LibCommonsMath.randNormalizedVect(m, threads, seed);
        MatrixBlock T = new MatrixBlock(m, m, 0.0);
        MatrixBlock TV = new MatrixBlock(m, m, 0.0);
        ReorgOperator op_t = new ReorgOperator(SwapIndex.getSwapIndexFnObject(), threads);
        TernaryOperator op_minus_mul = new TernaryOperator(MinusMultiply.getFnObject(), threads);
        AggregateBinaryOperator op_mul_agg = InstructionUtils.getMatMultOperator(threads);
        ScalarOperator op_div_scalar = new RightScalarOperator((ValueFunction)Divide.getDivideFnObject(), 1.0, threads);
        MatrixBlock beta = new MatrixBlock(1, 1, 0.0);
        for (int i = 0; i < m; ++i) {
            v1.putInto(TV, 0, i, false);
            MatrixBlock w1 = in.aggregateBinaryOperations(in, v1, op_mul_agg);
            MatrixBlock alpha = w1.aggregateBinaryOperations(v1.reorgOperations(op_t, new MatrixBlock(), 0, 0, m), w1, op_mul_agg);
            if (i < m - 1) {
                w1 = w1.ternaryOperations(op_minus_mul, v1, alpha, new MatrixBlock());
                w1 = w1.ternaryOperations(op_minus_mul, v0, beta, new MatrixBlock());
                beta.set(0, 0, Math.sqrt(w1.sumSq()));
                v0.copy(v1);
                op_div_scalar = ((ScalarOperator)op_div_scalar).setConstant(beta.getDouble(0, 0));
                w1.scalarOperations(op_div_scalar, v1);
                T.set(i + 1, i, beta.get(0, 0));
                T.set(i, i + 1, beta.get(0, 0));
            }
            T.set(i, i, alpha.get(0, 0));
        }
        MatrixBlock[] e = LibCommonsMath.computeEigen(T);
        TV.setNonZeros((long)m * (long)m);
        e[1] = TV.aggregateBinaryOperations(TV, e[1], op_mul_agg);
        return e;
    }

    private static MatrixBlock[] computeQR2(MatrixBlock in, int threads) {
        if (in.getNumRows() != in.getNumColumns()) {
            throw new DMLRuntimeException("QR2 Decomposition can only be done on a square matrix. Input matrix is rectangular (rows=" + in.getNumRows() + ", cols=" + in.getNumColumns() + ")");
        }
        int m = in.rlen;
        MatrixBlock A_n = new MatrixBlock();
        A_n.copy(in);
        MatrixBlock Q_n = new MatrixBlock(m, m, true);
        for (int i = 0; i < m; ++i) {
            Q_n.set(i, i, 1.0);
        }
        ReorgOperator op_t = new ReorgOperator(SwapIndex.getSwapIndexFnObject(), threads);
        AggregateBinaryOperator op_mul_agg = InstructionUtils.getMatMultOperator(threads);
        BinaryOperator op_sub = InstructionUtils.parseExtendedBinaryOperator("-");
        ScalarOperator op_div_scalar = new RightScalarOperator((ValueFunction)Divide.getDivideFnObject(), 1.0, threads);
        LeftScalarOperator op_mult_2 = new LeftScalarOperator((ValueFunction)Multiply.getMultiplyFnObject(), 2.0, threads);
        for (int k = 0; k < m; ++k) {
            MatrixBlock z = A_n.slice(k, m - 1, k, k);
            MatrixBlock uk = new MatrixBlock(m - k, 1, 0.0);
            uk.copy(z);
            uk.set(0, 0, uk.get(0, 0) + Math.signum(z.get(0, 0)) * Math.sqrt(z.sumSq()));
            op_div_scalar = ((ScalarOperator)op_div_scalar).setConstant(Math.sqrt(uk.sumSq()));
            uk = uk.scalarOperations(op_div_scalar, new MatrixBlock());
            MatrixBlock vk = new MatrixBlock(m, 1, 0.0);
            vk.copy(k, m - 1, 0, 0, uk, true);
            MatrixBlock vkt = vk.reorgOperations(op_t, new MatrixBlock(), 0, 0, m);
            MatrixBlock vkt2 = vkt.scalarOperations(op_mult_2, new MatrixBlock());
            MatrixBlock vkvkt2 = vk.aggregateBinaryOperations(vk, vkt2, op_mul_agg);
            A_n = A_n.binaryOperations(op_sub, A_n.aggregateBinaryOperations(vkvkt2, A_n, op_mul_agg));
            Q_n = Q_n.binaryOperations(op_sub, Q_n.aggregateBinaryOperations(Q_n, vkvkt2, op_mul_agg));
        }
        return new MatrixBlock[]{Q_n, A_n};
    }

    private static MatrixBlock[] computeEigenQR(MatrixBlock in, int threads) {
        return LibCommonsMath.computeEigenQR(in, 100, 1.0E-10, threads);
    }

    private static MatrixBlock[] computeEigenQR(MatrixBlock in, int num_iterations, double tol, int threads) {
        int i;
        if (in.getNumRows() != in.getNumColumns()) {
            throw new DMLRuntimeException("Eigen Decomposition (QR) can only be done on a square matrix. Input matrix is rectangular (rows=" + in.getNumRows() + ", cols=" + in.getNumColumns() + ")");
        }
        int m = in.rlen;
        AggregateBinaryOperator op_mul_agg = InstructionUtils.getMatMultOperator(threads);
        MatrixBlock Q_prod = new MatrixBlock(m, m, 0.0);
        for (i = 0; i < m; ++i) {
            Q_prod.set(i, i, 1.0);
        }
        for (i = 0; i < num_iterations; ++i) {
            MatrixBlock[] QR = LibCommonsMath.computeQR2(in, threads);
            Q_prod = Q_prod.aggregateBinaryOperations(Q_prod, QR[0], op_mul_agg);
            in = QR[1].aggregateBinaryOperations(QR[1], QR[0], op_mul_agg);
        }
        double[] check = in.getDenseBlockValues();
        double[] eval = new double[m];
        for (int i2 = 0; i2 < m; ++i2) {
            eval[i2] = check[i2 * m + i2];
        }
        double[] evec = Q_prod.getDenseBlockValues();
        return LibCommonsMath.sortEVs(eval, evec);
    }

    private static MatrixBlock computeHouseholder(MatrixBlock in, int threads) {
        int m = in.rlen;
        MatrixBlock A_n = new MatrixBlock(m, m, 0.0);
        A_n.copy(in);
        for (int k = 0; k < m - 2; ++k) {
            MatrixBlock ajk = A_n.slice(0, m - 1, k, k);
            for (int i = 0; i <= k; ++i) {
                ajk.set(i, 0, 0.0);
            }
            double alpha = Math.sqrt(ajk.sumSq());
            double ak1k = A_n.getDouble(k + 1, k);
            if (ak1k > 0.0) {
                alpha *= -1.0;
            }
            double r = Math.sqrt(0.5 * (alpha * alpha - ak1k * alpha));
            MatrixBlock v = new MatrixBlock(m, 1, 0.0);
            v.copy(ajk);
            v.set(k + 1, 0, ak1k - alpha);
            RightScalarOperator op_div_scalar = new RightScalarOperator((ValueFunction)Divide.getDivideFnObject(), 2.0 * r, threads);
            v = v.scalarOperations(op_div_scalar, new MatrixBlock());
            MatrixBlock P2 = new MatrixBlock(m, m, 0.0);
            for (int i = 0; i < m; ++i) {
                P2.set(i, i, 1.0);
            }
            ReorgOperator op_t = new ReorgOperator(SwapIndex.getSwapIndexFnObject(), threads);
            AggregateBinaryOperator op_mul_agg = InstructionUtils.getMatMultOperator(threads);
            BinaryOperator op_add = InstructionUtils.parseExtendedBinaryOperator(Opcodes.PLUS.toString());
            BinaryOperator op_sub = InstructionUtils.parseExtendedBinaryOperator(Opcodes.MINUS.toString());
            MatrixBlock v_t = v.reorgOperations(op_t, new MatrixBlock(), 0, 0, m);
            v_t = v_t.binaryOperations(op_add, v_t);
            MatrixBlock v_v_t_2 = A_n.aggregateBinaryOperations(v, v_t, op_mul_agg);
            P2 = P2.binaryOperations(op_sub, v_v_t_2);
            A_n = A_n.aggregateBinaryOperations(P2, A_n.aggregateBinaryOperations(A_n, P2, op_mul_agg), op_mul_agg);
        }
        return A_n;
    }

    private static MatrixBlock[] sortEVs(double[] eValues, double[][] eVectors) {
        int n = eValues.length;
        for (int i = 0; i < n; ++i) {
            int j;
            int k = i;
            double p = eValues[i];
            for (j = i + 1; j < n; ++j) {
                if (!(eValues[j] < p)) continue;
                k = j;
                p = eValues[j];
            }
            if (k == i) continue;
            eValues[k] = eValues[i];
            eValues[i] = p;
            for (j = 0; j < n; ++j) {
                p = eVectors[j][i];
                eVectors[j][i] = eVectors[j][k];
                eVectors[j][k] = p;
            }
        }
        MatrixBlock eval = DataConverter.convertToMatrixBlock(eValues, true);
        MatrixBlock evec = DataConverter.convertToMatrixBlock(eVectors);
        return new MatrixBlock[]{eval, evec};
    }

    private static MatrixBlock[] sortEVs(double[] eValues, double[] eVectors) {
        int n = eValues.length;
        for (int i = 0; i < n; ++i) {
            int j;
            int k = i;
            double p = eValues[i];
            for (j = i + 1; j < n; ++j) {
                if (!(eValues[j] < p)) continue;
                k = j;
                p = eValues[j];
            }
            if (k == i) continue;
            eValues[k] = eValues[i];
            eValues[i] = p;
            for (j = 0; j < n; ++j) {
                p = eVectors[j * n + i];
                eVectors[j * n + i] = eVectors[j * n + k];
                eVectors[j * n + k] = p;
            }
        }
        MatrixBlock eval = DataConverter.convertToMatrixBlock(eValues, true);
        MatrixBlock evec = new MatrixBlock(n, n, false);
        evec.init(eVectors, n, n);
        return new MatrixBlock[]{eval, evec};
    }

    private static MatrixBlock[] computeRCM(MatrixBlock A, MatrixBlock B) {
        int nr = Math.max(A.getNumRows(), B.getNumRows());
        int nc = Math.max(A.getNumColumns(), B.getNumColumns());
        MatrixBlock C = new MatrixBlock(nr, nc, false).allocateBlock();
        MatrixBlock N = new MatrixBlock(nr, nc, false).allocateBlock();
        double[] dC = C.getDenseBlockValues();
        double[] dN = N.getDenseBlockValues();
        SpoofOperator.SideInput sB = CodegenUtils.createSideInput(B);
        boolean mv = B.getNumRows() == 1;
        int numCols = Math.min(A.getNumColumns(), B.getNumColumns());
        HashMap<ClassLabel, IntArrayList> classLabelMapping = new HashMap<ClassLabel, IntArrayList>();
        int i = 0;
        int ai = 0;
        while (i < A.getNumRows()) {
            block8: {
                block9: {
                    block7: {
                        classLabelMapping.clear();
                        sB.reset();
                        if (!A.isInSparseFormat()) break block7;
                        if (A.getSparseBlock() == null || A.getSparseBlock().isEmpty(i)) break block8;
                        int alen = A.getSparseBlock().size(i);
                        int apos = A.getSparseBlock().pos(i);
                        int[] aix = A.getSparseBlock().indexes(i);
                        double[] avals = A.getSparseBlock().values(i);
                        for (int k = apos; k < apos + alen && aix[k] < numCols; ++k) {
                            int bval = (int)sB.getValue(mv ? 0 : i, aix[k]);
                            if (bval == 0) continue;
                            ClassLabel key = new ClassLabel((int)avals[k], bval);
                            if (!classLabelMapping.containsKey(key)) {
                                classLabelMapping.put(key, new IntArrayList());
                            }
                            ((IntArrayList)classLabelMapping.get(key)).appendValue(aix[k]);
                        }
                        break block9;
                    }
                    double[] denseBlk = A.getDenseBlockValues();
                    if (denseBlk == null) break;
                    for (int j = 0; j < numCols; ++j) {
                        int aVal = (int)denseBlk[ai + j];
                        int bVal = (int)sB.getValue(mv ? 0 : i, j);
                        if (aVal == 0 || bVal == 0) continue;
                        ClassLabel key = new ClassLabel(aVal, bVal);
                        if (!classLabelMapping.containsKey(key)) {
                            classLabelMapping.put(key, new IntArrayList());
                        }
                        ((IntArrayList)classLabelMapping.get(key)).appendValue(j);
                    }
                }
                int labelID = 1;
                for (Map.Entry entry : classLabelMapping.entrySet()) {
                    int nVal = ((IntArrayList)entry.getValue()).size();
                    int[] list = ((IntArrayList)entry.getValue()).extractValues();
                    int off = i * nc;
                    for (int k = 0; k < nVal; ++k) {
                        dN[off + list[k]] = nVal;
                        dC[off + list[k]] = labelID;
                    }
                    ++labelID;
                }
            }
            ++i;
            ai += A.getNumColumns();
        }
        C.recomputeNonZeros();
        C.examSparsity();
        N.recomputeNonZeros();
        N.examSparsity();
        return new MatrixBlock[]{C, N};
    }

    private static class ClassLabel {
        public int aVal;
        public int bVal;

        public ClassLabel(int aVal, int bVal) {
            this.aVal = aVal;
            this.bVal = bVal;
        }

        public int hashCode() {
            return UtilFunctions.intHashCode(this.aVal, this.bVal);
        }

        public boolean equals(Object o) {
            if (!(o instanceof ClassLabel)) {
                return false;
            }
            ClassLabel that = (ClassLabel)o;
            return this.aVal == that.aVal && this.bVal == that.bVal;
        }
    }
}

