/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.io;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.frame.data.FrameBlock;
import org.apache.sysds.runtime.frame.data.columns.Array;
import org.apache.sysds.runtime.frame.data.columns.ArrayWrapper;
import org.apache.sysds.runtime.frame.data.columns.DDCArray;
import org.apache.sysds.runtime.io.FrameWriter;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.runtime.matrix.data.Pair;
import org.apache.sysds.runtime.util.HDFSTool;

public class FrameWriterBinaryBlock
extends FrameWriter {
    @Override
    public final void writeFrameToHDFS(FrameBlock src, String fname, long rlen, long clen) throws IOException, DMLRuntimeException {
        JobConf job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
        Path path = new Path(fname);
        HDFSTool.deleteFileIfExistOnHDFS(fname);
        HDFSTool.deleteFileIfExistOnHDFS(fname + ".dict");
        if ((long)src.getNumRows() > rlen || (long)src.getNumColumns() > clen) {
            throw new IOException("Frame block [1:" + src.getNumRows() + ",1:" + src.getNumColumns() + "] out of overall frame range [1:" + rlen + ",1:" + clen + "].");
        }
        Pair<List<Pair<Integer, Array<?>>>, FrameBlock> prep = this.extractDictionaries(src);
        src = prep.getValue();
        this.writeBinaryBlockFrameToHDFS(path, job, prep.getValue(), rlen, clen);
        if (prep.getKey().size() > 0) {
            this.writeBinaryBlockDictsToSequenceFile(new Path(fname + ".dict"), job, prep.getKey());
        }
    }

    protected Pair<List<Pair<Integer, Array<?>>>, FrameBlock> extractDictionaries(FrameBlock src) {
        ArrayList dicts = new ArrayList();
        int blen = ConfigurationManager.getBlocksize();
        if (src.getNumRows() < blen) {
            return new Pair(dicts, src);
        }
        boolean modified = false;
        for (int i = 0; i < src.getNumColumns(); ++i) {
            Array<?> a = src.getColumn(i);
            if (!(a instanceof DDCArray)) continue;
            DDCArray d = (DDCArray)a;
            dicts.add(new Pair(i, d.getDict()));
            if (!modified) {
                modified = true;
                src = src.copyShallow();
            }
            src.setColumn(i, d.nullDict());
        }
        return new Pair(dicts, src);
    }

    protected void writeBinaryBlockFrameToHDFS(Path path, JobConf job, FrameBlock src, long rlen, long clen) throws IOException, DMLRuntimeException {
        FileSystem fs = IOUtilFunctions.getFileSystem(path);
        int blen = ConfigurationManager.getBlocksize();
        FrameWriterBinaryBlock.writeBinaryBlockFrameToSequenceFile(path, job, fs, src, blen, 0, (int)rlen);
        IOUtilFunctions.deleteCrcFilesFromLocalFileSystem(fs, path);
    }

    protected void writeBinaryBlockDictsToSequenceFile(Path path, JobConf job, List<Pair<Integer, Array<?>>> dicts) throws IOException, DMLRuntimeException {
        FileSystem fs = IOUtilFunctions.getFileSystem(path);
        FrameWriterBinaryBlock.writeBinaryBlockDictsToSequenceFile(path, job, fs, dicts);
        IOUtilFunctions.deleteCrcFilesFromLocalFileSystem(fs, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void writeBinaryBlockFrameToSequenceFile(Path path, JobConf job, FileSystem fs, FrameBlock src, int blen, int rl, int ru) throws IOException {
        SequenceFile.Writer writer = IOUtilFunctions.getSeqWriterFrame(path, (Configuration)job, 1);
        int rlen = src.getNumRows();
        int clen = src.getNumColumns();
        try {
            LongWritable index = new LongWritable();
            if (rlen <= blen) {
                index.set(1L);
                writer.append((Writable)index, (Writable)src);
            } else {
                for (int bi = rl; bi < ru; bi += blen) {
                    int len = Math.min(blen, rlen - bi);
                    FrameBlock block = src.slice(bi, bi + len - 1, 0, clen - 1);
                    if (bi == 0) {
                        block.setColumnMetadata(src.getColumnMetadata());
                    }
                    index.set((long)(bi + 1));
                    writer.append((Writable)index, (Writable)block);
                }
            }
        }
        finally {
            IOUtilFunctions.closeSilently((Closeable)writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void writeBinaryBlockDictsToSequenceFile(Path path, JobConf job, FileSystem fs, List<Pair<Integer, Array<?>>> dicts) throws IOException {
        SequenceFile.Writer writer = IOUtilFunctions.getSeqWriterArray(path, (Configuration)job, 1);
        try {
            LongWritable index = new LongWritable();
            for (int i = 0; i < dicts.size(); ++i) {
                Pair<Integer, Array<?>> p = dicts.get(i);
                index.set((long)p.getKey().intValue());
                writer.append((Writable)index, (Writable)new ArrayWrapper(p.getValue()));
            }
        }
        finally {
            IOUtilFunctions.closeSilently((Closeable)writer);
        }
    }
}

