/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.hops.rewrite;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.apache.sysds.common.Types;
import org.apache.sysds.hops.Hop;
import org.apache.sysds.hops.ParameterizedBuiltinOp;
import org.apache.sysds.hops.rewrite.HopRewriteRule;
import org.apache.sysds.hops.rewrite.HopRewriteUtils;
import org.apache.sysds.hops.rewrite.ProgramRewriteStatus;

public class RewriteNonScalarPrint
extends HopRewriteRule {
    @Override
    public ArrayList<Hop> rewriteHopDAGs(ArrayList<Hop> roots, ProgramRewriteStatus state) {
        if (roots != null) {
            for (Hop h : roots) {
                this.rewriteHopDAG(h, state);
            }
        }
        return roots;
    }

    @Override
    public Hop rewriteHopDAG(Hop root, ProgramRewriteStatus state) {
        if (root != null) {
            this.rewritePrintNonScalar(root);
        }
        return root;
    }

    private void rewritePrintNonScalar(Hop hop) {
        Hop child;
        if (HopRewriteUtils.isUnary(hop, Types.OpOp1.PRINT) && !(child = hop.getInput().get(0)).getDataType().isScalar()) {
            LinkedHashMap<String, Hop> args = new LinkedHashMap<String, Hop>();
            args.put("target", child);
            ParameterizedBuiltinOp toStringOp = HopRewriteUtils.createParameterizedBuiltinOp(child, args, Types.ParamBuiltinOp.TOSTRING);
            HopRewriteUtils.replaceChildReference(hop, child, toStringOp, 0);
            LOG.debug((Object)("Applied non-scalar print rewrite on hop ID = " + hop.getHopID()));
        }
    }
}

