/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.cp;

import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.functionobjects.CM;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.AggregateUnaryCPInstruction;
import org.apache.sysds.runtime.instructions.cp.CM_COV_Object;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.cp.DoubleObject;
import org.apache.sysds.runtime.instructions.cp.ScalarObject;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.operators.CMOperator;

public class CentralMomentCPInstruction
extends AggregateUnaryCPInstruction {
    private CentralMomentCPInstruction(CMOperator cm, CPOperand in1, CPOperand in2, CPOperand in3, CPOperand out, String opcode, String str) {
        super(cm, in1, in2, in3, out, AggregateUnaryCPInstruction.AUType.DEFAULT, opcode, str);
    }

    public static CentralMomentCPInstruction parseInstruction(String str) {
        int cmOrder;
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = parts[0];
        if (!opcode.equalsIgnoreCase("cm")) {
            throw new DMLRuntimeException("Unsupported opcode " + opcode);
        }
        InstructionUtils.checkNumFields(str, 4, 5);
        CPOperand in1 = new CPOperand(parts[1]);
        CPOperand in2 = new CPOperand(parts[2]);
        CPOperand in3 = parts.length == 5 ? null : new CPOperand(parts[3]);
        CPOperand out = new CPOperand(parts[parts.length - 2]);
        int numThreads = Integer.parseInt(parts[parts.length - 1]);
        try {
            cmOrder = Integer.parseInt(in3 == null ? in2.getName() : in3.getName());
        }
        catch (NumberFormatException e) {
            cmOrder = -1;
        }
        CMOperator.AggregateOperationTypes opType = CMOperator.getCMAggOpType(cmOrder);
        CMOperator cm = new CMOperator(CM.getCMFnObject(opType), opType, numThreads);
        return new CentralMomentCPInstruction(cm, in1, in2, in3, out, opcode, str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        String output_name = this.output.getName();
        MatrixBlock matBlock = ec.getMatrixInput(this.input1.getName());
        CPOperand scalarInput = this.input3 == null ? this.input2 : this.input3;
        ScalarObject order = ec.getScalarInput(scalarInput);
        CMOperator cm_op = (CMOperator)this._optr;
        if (cm_op.getAggOpType() == CMOperator.AggregateOperationTypes.INVALID) {
            cm_op = cm_op.setCMAggOp((int)order.getLongValue());
        }
        CM_COV_Object cmobj = null;
        if (this.input3 == null) {
            cmobj = matBlock.cmOperations(cm_op);
        } else {
            MatrixBlock wtBlock = ec.getMatrixInput(this.input2.getName());
            cmobj = matBlock.cmOperations(cm_op, wtBlock);
            ec.releaseMatrixInput(this.input2.getName());
        }
        ec.releaseMatrixInput(this.input1.getName());
        double val = cmobj.getRequiredResult(cm_op);
        ec.setScalarOutput(output_name, new DoubleObject(val));
    }
}

