/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.sysds.runtime.compress.DMLCompressionException;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.AColGroupCompressed;
import org.apache.sysds.runtime.compress.colgroup.ASDCZero;
import org.apache.sysds.runtime.compress.colgroup.ColGroupDDC;
import org.apache.sysds.runtime.compress.colgroup.ColGroupEmpty;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDC;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDCFOR;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDCSingleZeros;
import org.apache.sysds.runtime.compress.colgroup.ColGroupUtils;
import org.apache.sysds.runtime.compress.colgroup.FORUtil;
import org.apache.sysds.runtime.compress.colgroup.dictionary.ADictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.Dictionary;
import org.apache.sysds.runtime.compress.colgroup.mapping.AMapToData;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToFactory;
import org.apache.sysds.runtime.compress.colgroup.offset.AIterator;
import org.apache.sysds.runtime.compress.colgroup.offset.AOffset;
import org.apache.sysds.runtime.compress.colgroup.offset.OffsetFactory;
import org.apache.sysds.runtime.compress.cost.ComputationCostEstimator;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.functionobjects.Builtin;
import org.apache.sysds.runtime.functionobjects.Minus;
import org.apache.sysds.runtime.functionobjects.Plus;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.operators.BinaryOperator;
import org.apache.sysds.runtime.matrix.operators.RightScalarOperator;
import org.apache.sysds.runtime.matrix.operators.ScalarOperator;
import org.apache.sysds.runtime.matrix.operators.UnaryOperator;

public class ColGroupSDCZeros
extends ASDCZero {
    private static final long serialVersionUID = -3703199743391937991L;
    protected AMapToData _data;

    protected ColGroupSDCZeros(int numRows) {
        super(numRows);
    }

    private ColGroupSDCZeros(int[] colIndices, int numRows, ADictionary dict, AOffset indexes, AMapToData data, int[] cachedCounts) {
        super(colIndices, numRows, dict, indexes, cachedCounts);
        if (data.getUnique() != dict.getNumberOfValues(colIndices.length)) {
            throw new DMLCompressionException("Invalid construction of SDCZero group: number uniques: " + data.getUnique() + " vs." + dict.getNumberOfValues(colIndices.length));
        }
        this._data = data;
        this._zeros = true;
    }

    protected static AColGroup create(int[] colIndices, int numRows, ADictionary dict, AOffset offsets, AMapToData data, int[] cachedCounts) {
        if (dict == null) {
            return new ColGroupEmpty(colIndices);
        }
        return new ColGroupSDCZeros(colIndices, numRows, dict, offsets, data, cachedCounts);
    }

    @Override
    public AColGroup.CompressionType getCompType() {
        return AColGroup.CompressionType.SDC;
    }

    @Override
    public AColGroup.ColGroupType getColGroupType() {
        return AColGroup.ColGroupType.SDCZeros;
    }

    @Override
    protected void decompressToDenseBlockDenseDictionary(DenseBlock db, int rl, int ru, int offR, int offC, double[] values) {
        AIterator it = this._indexes.getIterator(rl);
        if (it == null) {
            return;
        }
        if (it.value() >= ru) {
            this._indexes.cacheIterator(it, ru);
        } else {
            this.decompressToDenseBlockDenseDictionaryWithProvidedIterator(db, rl, ru, offR, offC, values, it);
            this._indexes.cacheIterator(it, ru);
        }
    }

    @Override
    public final void decompressToDenseBlockDenseDictionaryWithProvidedIterator(DenseBlock db, int rl, int ru, int offR, int offC, double[] values, AIterator it) {
        int last = this._indexes.getOffsetToLast();
        if (it == null || it.value() >= ru || rl > last) {
            return;
        }
        boolean post = ru > last;
        boolean contiguous = db.isContiguous();
        if (post) {
            if (contiguous && this._colIndexes.length == 1) {
                this.decompressToDenseBlockDenseDictionaryPostSingleColContiguous(db, rl, ru, offR, offC, values, it);
            } else {
                this.decompressToDenseBlockDenseDictionaryPostGeneric(db, rl, ru, offR, offC, values, it);
            }
        } else if (contiguous && this._colIndexes.length == 1) {
            if (db.getDim(1) == 1) {
                ColGroupSDCZeros.decompressToDenseBlockDenseDictionaryPreSingleColOutContiguous(db, ru, offR, offC, values, it, this._data);
            } else {
                this.decompressToDenseBlockDenseDictionaryPreSingleColContiguous(db, rl, ru, offR, offC, values, it);
            }
        } else if (this._colIndexes.length == db.getDim(1)) {
            this.decompressToDenseBlockDenseDictionaryPreAllCols(db, rl, ru, offR, offC, values, it);
        } else {
            this.decompressToDenseBlockDenseDictionaryPreGeneric(db, rl, ru, offR, offC, values, it);
        }
    }

    private void decompressToDenseBlockDenseDictionaryPostSingleColContiguous(DenseBlock db, int rl, int ru, int offR, int offC, double[] values, AIterator it) {
        int off;
        int lastOff = this._indexes.getOffsetToLast() + offR;
        int nCol = db.getDim(1);
        double[] c = db.values(0);
        it.setOff(it.value() + offR);
        offC += this._colIndexes[0];
        while (it.value() < lastOff) {
            int n = off = it.value() * nCol + offC;
            c[n] = c[n] + values[this._data.getIndex(it.getDataIndex())];
            it.next();
        }
        int n = off = it.value() * nCol + offC;
        c[n] = c[n] + values[this._data.getIndex(it.getDataIndex())];
        it.setOff(it.value() - offR);
    }

    private void decompressToDenseBlockDenseDictionaryPostGeneric(DenseBlock db, int rl, int ru, int offR, int offC, double[] values, AIterator it) {
        int lastOff = this._indexes.getOffsetToLast();
        int nCol = this._colIndexes.length;
        while (true) {
            int idx = offR + it.value();
            double[] c = db.values(idx);
            int off = db.pos(idx) + offC;
            int offDict = this._data.getIndex(it.getDataIndex()) * nCol;
            for (int j = 0; j < nCol; ++j) {
                int n = off + this._colIndexes[j];
                c[n] = c[n] + values[offDict + j];
            }
            if (it.value() == lastOff) {
                return;
            }
            it.next();
        }
    }

    private static void decompressToDenseBlockDenseDictionaryPreSingleColOutContiguous(DenseBlock db, int ru, int offR, int offC, double[] values, AIterator it, AMapToData m) {
        double[] c = db.values(0);
        int of = offR + offC;
        int last = ru + of;
        it.setOff(it.value() + of);
        while (it.isNotOver(last)) {
            int n = it.value();
            c[n] = c[n] + values[m.getIndex(it.getDataIndex())];
            it.next();
        }
        it.setOff(it.value() - of);
    }

    private void decompressToDenseBlockDenseDictionaryPreSingleColContiguous(DenseBlock db, int rl, int ru, int offR, int offC, double[] values, AIterator it) {
        int last = ru + offR;
        int nCol = db.getDim(1);
        double[] c = db.values(0);
        it.setOff(it.value() + offR);
        offC += this._colIndexes[0];
        while (it.isNotOver(last)) {
            int off;
            int n = off = it.value() * nCol + offC;
            c[n] = c[n] + values[this._data.getIndex(it.getDataIndex())];
            it.next();
        }
        it.setOff(it.value() - offR);
    }

    private void decompressToDenseBlockDenseDictionaryPreGeneric(DenseBlock db, int rl, int ru, int offR, int offC, double[] values, AIterator it) {
        int nCol = this._colIndexes.length;
        while (it.isNotOver(ru)) {
            int idx = offR + it.value();
            double[] c = db.values(idx);
            int off = db.pos(idx) + offC;
            int offDict = this._data.getIndex(it.getDataIndex()) * nCol;
            for (int j = 0; j < nCol; ++j) {
                int n = off + this._colIndexes[j];
                c[n] = c[n] + values[offDict + j];
            }
            it.next();
        }
    }

    private void decompressToDenseBlockDenseDictionaryPreAllCols(DenseBlock db, int rl, int ru, int offR, int offC, double[] values, AIterator it) {
        int nCol = this._colIndexes.length;
        while (it.isNotOver(ru)) {
            int idx = offR + it.value();
            double[] c = db.values(idx);
            int off = db.pos(idx) + offC;
            int offDict = this._data.getIndex(it.getDataIndex()) * nCol;
            for (int j = 0; j < nCol; ++j) {
                int n = off + j;
                c[n] = c[n] + values[offDict + j];
            }
            it.next();
        }
    }

    @Override
    protected void decompressToDenseBlockSparseDictionary(DenseBlock db, int rl, int ru, int offR, int offC, SparseBlock sb) {
        AIterator it = this._indexes.getIterator(rl);
        if (it == null) {
            return;
        }
        if (it.value() >= ru) {
            this._indexes.cacheIterator(it, ru);
        } else {
            if (ru > this._indexes.getOffsetToLast()) {
                int lastOff = this._indexes.getOffsetToLast();
                while (true) {
                    int idx = offR + it.value();
                    double[] c = db.values(idx);
                    int dx = it.getDataIndex();
                    int dictIndex = this._data.getIndex(dx);
                    if (sb.isEmpty(dictIndex)) {
                        if (it.value() == lastOff) {
                            return;
                        }
                        it.next();
                        continue;
                    }
                    int off = db.pos(idx) + offC;
                    int apos = sb.pos(dictIndex);
                    int alen = sb.size(dictIndex) + apos;
                    double[] avals = sb.values(dictIndex);
                    int[] aix = sb.indexes(dictIndex);
                    for (int j = apos; j < alen; ++j) {
                        int n = off + this._colIndexes[aix[j]];
                        c[n] = c[n] + avals[j];
                    }
                    if (it.value() == lastOff) {
                        return;
                    }
                    it.next();
                }
            }
            while (it.isNotOver(ru)) {
                int idx = offR + it.value();
                int dx = it.getDataIndex();
                int dictIndex = this._data.getIndex(dx);
                if (sb.isEmpty(dictIndex)) {
                    it.next();
                    continue;
                }
                double[] c = db.values(idx);
                int off = db.pos(idx) + offC;
                int apos = sb.pos(dictIndex);
                int alen = sb.size(dictIndex) + apos;
                double[] avals = sb.values(dictIndex);
                int[] aix = sb.indexes(dictIndex);
                for (int j = apos; j < alen; ++j) {
                    int n = off + this._colIndexes[aix[j]];
                    c[n] = c[n] + avals[j];
                }
                it.next();
            }
            this._indexes.cacheIterator(it, ru);
        }
    }

    @Override
    protected void decompressToSparseBlockSparseDictionary(SparseBlock ret, int rl, int ru, int offR, int offC, SparseBlock sb) {
        AIterator it = this._indexes.getIterator(rl);
        if (it == null) {
            return;
        }
        if (it.value() >= ru) {
            this._indexes.cacheIterator(it, ru);
        } else {
            if (ru > this._indexes.getOffsetToLast()) {
                int lastOff = this._indexes.getOffsetToLast();
                while (true) {
                    int row = offR + it.value();
                    int dx = it.getDataIndex();
                    int dictIndex = this._data.getIndex(dx);
                    if (sb.isEmpty(dictIndex)) {
                        if (it.value() == lastOff) {
                            return;
                        }
                        it.next();
                        continue;
                    }
                    int apos = sb.pos(dictIndex);
                    int alen = sb.size(dictIndex) + apos;
                    double[] avals = sb.values(dictIndex);
                    int[] aix = sb.indexes(dictIndex);
                    for (int j = apos; j < alen; ++j) {
                        ret.append(row, this._colIndexes[aix[j]] + offC, avals[j]);
                    }
                    if (it.value() == lastOff) {
                        return;
                    }
                    it.next();
                }
            }
            while (it.isNotOver(ru)) {
                int row = offR + it.value();
                int dx = it.getDataIndex();
                int dictIndex = this._data.getIndex(dx);
                if (sb.isEmpty(dictIndex)) {
                    it.next();
                    continue;
                }
                int apos = sb.pos(dictIndex);
                int alen = sb.size(dictIndex) + apos;
                double[] avals = sb.values(dictIndex);
                int[] aix = sb.indexes(dictIndex);
                for (int j = apos; j < alen; ++j) {
                    ret.append(row, this._colIndexes[aix[j]] + offC, avals[j]);
                }
                it.next();
            }
            this._indexes.cacheIterator(it, ru);
        }
    }

    @Override
    protected void decompressToSparseBlockDenseDictionary(SparseBlock ret, int rl, int ru, int offR, int offC, double[] values) {
        AIterator it = this._indexes.getIterator(rl);
        if (it == null) {
            return;
        }
        if (it.value() >= ru) {
            this._indexes.cacheIterator(it, ru);
        } else {
            if (ru > this._indexes.getOffsetToLast()) {
                int lastOff = this._indexes.getOffsetToLast();
                int nCol = this._colIndexes.length;
                while (true) {
                    int row = offR + it.value();
                    int dx = it.getDataIndex();
                    int offDict = this._data.getIndex(dx) * nCol;
                    for (int j = 0; j < nCol; ++j) {
                        ret.append(row, this._colIndexes[j] + offC, values[offDict + j]);
                    }
                    if (it.value() == lastOff) {
                        return;
                    }
                    it.next();
                }
            }
            int nCol = this._colIndexes.length;
            while (it.isNotOver(ru)) {
                int row = offR + it.value();
                int dx = it.getDataIndex();
                int offDict = this._data.getIndex(dx) * nCol;
                for (int j = 0; j < nCol; ++j) {
                    ret.append(row, this._colIndexes[j] + offC, values[offDict + j]);
                }
                it.next();
            }
            this._indexes.cacheIterator(it, ru);
        }
    }

    @Override
    public double getIdx(int r, int colIdx) {
        AIterator it = this._indexes.getIterator(r);
        if (it == null || it.value() != r) {
            return 0.0;
        }
        int nCol = this._colIndexes.length;
        return this._dict.getValue(this._data.getIndex(it.getDataIndex()) * nCol + colIdx);
    }

    @Override
    protected void computeRowSums(double[] c, int rl, int ru, double[] preAgg) {
        ColGroupSDCZeros.computeRowSums(c, rl, ru, preAgg, this._data, this._indexes, this._numRows);
    }

    protected static final void computeRowSums(double[] c, int rl, int ru, double[] preAgg, AMapToData data, AOffset indexes, int nRows) {
        AIterator it = indexes.getIterator(rl);
        if (it == null) {
            return;
        }
        if (it.value() > ru) {
            indexes.cacheIterator(it, ru);
        } else if (ru >= indexes.getOffsetToLast()) {
            int maxId = data.size() - 1;
            int n = it.value();
            c[n] = c[n] + preAgg[data.getIndex(it.getDataIndex())];
            while (it.getDataIndex() < maxId) {
                it.next();
                int n2 = it.value();
                c[n2] = c[n2] + preAgg[data.getIndex(it.getDataIndex())];
            }
        } else {
            while (it.isNotOver(ru)) {
                int n = it.value();
                c[n] = c[n] + preAgg[data.getIndex(it.getDataIndex())];
                it.next();
            }
            indexes.cacheIterator(it, ru);
        }
    }

    @Override
    protected void computeRowMxx(double[] c, Builtin builtin, int rl, int ru, double[] preAgg) {
        ColGroupSDC.computeRowMxx(c, builtin, rl, ru, preAgg, this._data, this._indexes, this._numRows, 0.0);
    }

    @Override
    public int[] getCounts(int[] counts) {
        return this._data.getCounts(counts);
    }

    @Override
    protected void multiplyScalar(double v, double[] resV, int offRet, AIterator it) {
        int dx = this._data.getIndex(it.getDataIndex());
        this._dict.multiplyScalar(v, resV, offRet, dx, this._colIndexes);
    }

    @Override
    public void preAggregateDense(MatrixBlock m, double[] preAgg, int rl, int ru, int cl, int cu) {
        this._data.preAggregateDense(m, preAgg, rl, ru, cl, cu, this._indexes);
    }

    @Override
    public void preAggregateSparse(SparseBlock sb, double[] preAgg, int rl, int ru) {
        this._data.preAggregateSparse(sb, preAgg, rl, ru, this._indexes);
    }

    @Override
    public long estimateInMemorySize() {
        long size = super.estimateInMemorySize();
        size += this._indexes.getInMemorySize();
        return size += this._data.getInMemorySize();
    }

    @Override
    public AColGroup scalarOperation(ScalarOperator op) {
        boolean isSparseSafeOp;
        double val0 = op.executeScalar(0.0);
        boolean bl = isSparseSafeOp = op.sparseSafe || val0 == 0.0;
        if (isSparseSafeOp) {
            return ColGroupSDCZeros.create(this._colIndexes, this._numRows, this._dict.applyScalarOp(op), this._indexes, this._data, this.getCachedCounts());
        }
        if (op.fn instanceof Plus || op.fn instanceof Minus && op instanceof RightScalarOperator) {
            double[] reference = FORUtil.createReference(this._colIndexes.length, val0);
            return ColGroupSDCFOR.create(this._colIndexes, this._numRows, this._dict, this._indexes, this._data, this.getCachedCounts(), reference);
        }
        ADictionary newDict = this._dict.applyScalarOp(op);
        double[] defaultTuple = FORUtil.createReference(this._colIndexes.length, val0);
        return ColGroupSDC.create(this._colIndexes, this._numRows, newDict, defaultTuple, this._indexes, this._data, this.getCachedCounts());
    }

    @Override
    public AColGroup unaryOperation(UnaryOperator op) {
        double val0 = op.fn.execute(0L);
        ADictionary nDict = this._dict.applyUnaryOp(op);
        if (val0 == 0.0) {
            return ColGroupSDCZeros.create(this._colIndexes, this._numRows, nDict, this._indexes, this._data, this.getCachedCounts());
        }
        double[] defaultTuple = new double[this._colIndexes.length];
        Arrays.fill(defaultTuple, val0);
        return ColGroupSDC.create(this._colIndexes, this._numRows, nDict, defaultTuple, this._indexes, this._data, this.getCachedCounts());
    }

    @Override
    public AColGroup binaryRowOpLeft(BinaryOperator op, double[] v, boolean isRowSafe) {
        if (isRowSafe) {
            ADictionary newDict = this._dict.binOpLeft(op, v, this._colIndexes);
            return ColGroupSDCZeros.create(this._colIndexes, this._numRows, newDict, this._indexes, this._data, this.getCachedCounts());
        }
        if (op.fn instanceof Plus) {
            double[] reference = ColGroupUtils.binaryDefRowLeft(op, v, this._colIndexes);
            return ColGroupSDCFOR.create(this._colIndexes, this._numRows, this._dict, this._indexes, this._data, this.getCachedCounts(), reference);
        }
        ADictionary newDict = this._dict.binOpLeft(op, v, this._colIndexes);
        double[] defaultTuple = new double[this._colIndexes.length];
        for (int i = 0; i < this._colIndexes.length; ++i) {
            defaultTuple[i] = op.fn.execute(v[this._colIndexes[i]], 0.0);
        }
        return ColGroupSDC.create(this._colIndexes, this._numRows, newDict, defaultTuple, this._indexes, this._data, this.getCachedCounts());
    }

    @Override
    public AColGroup binaryRowOpRight(BinaryOperator op, double[] v, boolean isRowSafe) {
        if (isRowSafe) {
            ADictionary ret = this._dict.binOpRight(op, v, this._colIndexes);
            return ColGroupSDCZeros.create(this._colIndexes, this._numRows, ret, this._indexes, this._data, this.getCachedCounts());
        }
        if (op.fn instanceof Plus) {
            double[] def = ColGroupUtils.binaryDefRowRight(op, v, this._colIndexes);
            return ColGroupSDCFOR.create(this._colIndexes, this._numRows, this._dict, this._indexes, this._data, this.getCachedCounts(), def);
        }
        ADictionary newDict = this._dict.binOpRight(op, v, this._colIndexes);
        double[] defaultTuple = new double[this._colIndexes.length];
        for (int i = 0; i < this._colIndexes.length; ++i) {
            defaultTuple[i] = op.fn.execute(0.0, v[this._colIndexes[i]]);
        }
        return ColGroupSDC.create(this._colIndexes, this._numRows, newDict, defaultTuple, this._indexes, this._data, this.getCachedCounts());
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        this._indexes.write(out);
        this._data.write(out);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this._indexes = OffsetFactory.readIn(in);
        this._data = MapToFactory.readIn(in);
    }

    @Override
    public long getExactSizeOnDisk() {
        long ret = super.getExactSizeOnDisk();
        ret += this._indexes.getExactSizeOnDisk();
        return ret += this._data.getInMemorySize();
    }

    @Override
    public boolean sameIndexStructure(AColGroupCompressed that) {
        if (that instanceof ColGroupSDCZeros) {
            ColGroupSDCZeros th = (ColGroupSDCZeros)that;
            return th._indexes == this._indexes && th._data == this._data;
        }
        return false;
    }

    @Override
    public void preAggregateThatDDCStructure(ColGroupDDC that, Dictionary ret) {
        this._data.preAggregateSDCZ_DDC(that._data, that._dict, this._indexes, ret, that._colIndexes.length);
    }

    @Override
    public void preAggregateThatSDCZerosStructure(ColGroupSDCZeros that, Dictionary ret) {
        this._data.preAggregateSDCZ_SDCZ(that._data, that._dict, that._indexes, this._indexes, ret, that._colIndexes.length);
    }

    @Override
    public void preAggregateThatSDCSingleZerosStructure(ColGroupSDCSingleZeros that, Dictionary ret) {
        AIterator itThat = that._indexes.getIterator();
        AIterator itThis = this._indexes.getIterator();
        int nCol = that._colIndexes.length;
        int finalOffThis = this._indexes.getOffsetToLast();
        int finalOffThat = that._indexes.getOffsetToLast();
        double[] v = ret.getValues();
        while (true) {
            if (itThat.value() == itThis.value()) {
                int to = this._data.getIndex(itThis.getDataIndex());
                that._dict.addToEntry(v, 0, to, nCol);
                if (itThat.value() >= finalOffThat) break;
                itThat.next();
                if (itThis.value() >= finalOffThis) break;
                itThis.next();
                continue;
            }
            if (itThat.value() < itThis.value()) {
                if (itThat.value() >= finalOffThat) break;
                itThat.next();
                continue;
            }
            if (itThis.value() >= finalOffThis) break;
            itThis.next();
        }
    }

    @Override
    public AColGroup replace(double pattern, double replace) {
        ADictionary replaced = this._dict.replace(pattern, replace, this._colIndexes.length);
        if (pattern == 0.0) {
            double[] defaultTuple = new double[this._colIndexes.length];
            for (int i = 0; i < this._colIndexes.length; ++i) {
                defaultTuple[i] = replace;
            }
            return ColGroupSDC.create(this._colIndexes, this._numRows, replaced, defaultTuple, this._indexes, this._data, this.getCachedCounts());
        }
        return this.copyAndSet(replaced);
    }

    @Override
    protected void computeProduct(double[] c, int nRows) {
        c[0] = 0.0;
    }

    @Override
    protected void computeRowProduct(double[] c, int rl, int ru, double[] preAgg) {
        for (int i = 0; i < c.length; ++i) {
            c[i] = 0.0;
        }
    }

    @Override
    protected void computeColProduct(double[] c, int nRows) {
        for (int i = 0; i < c.length; ++i) {
            c[i] = 0.0;
        }
    }

    @Override
    public double getCost(ComputationCostEstimator e, int nRows) {
        int nVals = this.getNumValues();
        int nCols = this.getNumCols();
        int nRowsScanned = this._data.size();
        return e.getCost(nRows, nRowsScanned, nCols, nVals, this._dict.getSparsity());
    }

    @Override
    protected int getIndexesSize() {
        return this._data.size();
    }

    @Override
    protected int numRowsToMultiply() {
        return this._data.size();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append(String.format("\n%15s", "Indexes: "));
        sb.append(this._indexes.toString());
        sb.append(String.format("\n%15s", "Data: "));
        sb.append(this._data);
        return sb.toString();
    }
}

